/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleMatrix;
import jp.crestmuse.cmx.math.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HmmReader {
    public static <O extends Observation> Hmm<O> read(Reader reader, OpdfReader<? extends Opdf<O>> opdfReader) throws IOException, FileFormatException {
        return HmmReader.read(reader, opdfReader, false);
    }

    public static <O extends Observation> Hmm<O> read(Reader reader, OpdfReader<? extends Opdf<O>> opdfReader, boolean bl) throws IOException, FileFormatException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        HmmReader.initSyntaxTable(streamTokenizer);
        HmmReader.readWords(streamTokenizer, "Hmm", "v1.0", "NbStates");
        int n = (int)HmmReader.readNumber(streamTokenizer);
        DoubleArray doubleArray = Utils.createDoubleArray(n);
        DoubleMatrix doubleMatrix = bl ? Utils.createSparseDoubleMatrix(n, n) : Utils.createDoubleMatrix(n, n);
        ArrayList<Opdf<O>> arrayList = new ArrayList<Opdf<O>>(n);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            HmmReader.readState(streamTokenizer, n, i, doubleArray, doubleMatrix, arrayList, stringArray, opdfReader);
        }
        return new Hmm(doubleArray, doubleMatrix, arrayList, stringArray);
    }

    private static <O extends Observation> void readState(StreamTokenizer streamTokenizer, int n, int n2, DoubleArray doubleArray, DoubleMatrix doubleMatrix, List<Opdf<O>> list, String[] stringArray, OpdfReader<? extends Opdf<O>> opdfReader) throws IOException, FileFormatException {
        HmmReader.readWords(streamTokenizer, "State");
        try {
            HmmReader.readWords(streamTokenizer, "Label");
            streamTokenizer.nextToken();
            stringArray[n2] = streamTokenizer.sval;
        }
        catch (FileFormatException fileFormatException) {
            streamTokenizer.pushBack();
        }
        HmmReader.readWords(streamTokenizer, "Pi");
        doubleArray.set(n2, HmmReader.readNumber(streamTokenizer));
        HmmReader.readWords(streamTokenizer, "A");
        for (int i = 0; i < n; ++i) {
            doubleMatrix.set(n2, i, HmmReader.readNumber(streamTokenizer));
        }
        list.add(opdfReader.read(streamTokenizer));
    }

    static void readWords(StreamTokenizer streamTokenizer, String ... stringArray) throws IOException, FileFormatException {
        for (String string : stringArray) {
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == -3) {
                if (streamTokenizer.sval.equals(string)) continue;
                throw new FileFormatException(streamTokenizer.lineno(), "Syntax error: unexpected token '" + streamTokenizer.sval + "', ('" + string + "' expected)");
            }
            if (streamTokenizer.ttype > 0) {
                if (string.length() == 1 && streamTokenizer.ttype == string.charAt(0)) continue;
                throw new FileFormatException(streamTokenizer.lineno(), "Syntax error: unexpected token '" + (char)streamTokenizer.ttype + "' (" + string + "' expected)");
            }
            throw new FileFormatException(streamTokenizer.lineno(), "Syntax error: '" + string + "' expected");
        }
    }

    static double readNumber(StreamTokenizer streamTokenizer) throws IOException, FileFormatException {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            throw new FileFormatException(streamTokenizer.lineno(), "Syntax error: number expected");
        }
        return streamTokenizer.nval;
    }

    static void initSyntaxTable(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.parseNumbers();
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.commentChar(35);
    }
}

