/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.draw;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HmmDrawerDot<H extends Hmm<?>> {
    protected double minimumAij = 0.01;
    protected double minimumPi = 0.01;
    protected NumberFormat probabilityFormat = NumberFormat.getInstance();

    public HmmDrawerDot() {
        this.probabilityFormat.setMaximumFractionDigits(2);
    }

    protected String convert(H h) {
        String string = this.beginning();
        string = string + this.transitions((Hmm<?>)h);
        string = string + this.states(h);
        return string + this.ending();
    }

    protected String beginning() {
        return "digraph G {\n";
    }

    protected String transitions(Hmm<?> hmm) {
        String string = "";
        for (int i = 0; i < hmm.nbStates(); ++i) {
            for (int j = 0; j < hmm.nbStates(); ++j) {
                if (!(hmm.getAij(i, j) >= this.minimumAij)) continue;
                string = string + "\t" + i + " -> " + j + " [label=" + this.probabilityFormat.format(hmm.getAij(i, j)) + "];\n";
            }
        }
        return string;
    }

    protected String states(H h) {
        String string = "";
        for (int i = 0; i < ((Hmm)h).nbStates(); ++i) {
            string = string + "\t" + i + " [";
            string = ((Hmm)h).getPi(i) >= this.minimumPi ? string + "shape=doublecircle, label=\"" + i + " - Pi= " + this.probabilityFormat.format(((Hmm)h).getPi(i)) + " - " + this.opdfLabel(h, i) + "\"" : string + "shape=circle, label=\"" + i + " - " + this.opdfLabel(h, i) + "\"";
            string = string + "];\n";
        }
        return string;
    }

    protected String opdfLabel(H h, int n) {
        return "[ " + ((Hmm)h).getOpdf(n).toString() + " ]";
    }

    protected String ending() {
        return "}\n";
    }

    public void write(H h, String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        fileWriter.write(this.convert(h));
        fileWriter.close();
    }
}

