/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.sample;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.ObservationDiscrete;
import be.ac.ulg.montefiore.run.jahmm.OpdfDiscrete;
import be.ac.ulg.montefiore.run.jahmm.OpdfDiscreteFactory;
import be.ac.ulg.montefiore.run.jahmm.draw.GenericHmmDrawerDot;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchLearner;
import be.ac.ulg.montefiore.run.jahmm.toolbox.KullbackLeiblerDistanceCalculator;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleExample {
    public static void main(String[] stringArray) throws IOException {
        Hmm<ObservationDiscrete<Packet>> hmm = SimpleExample.buildHmm();
        List<List<ObservationDiscrete<Packet>>> list = SimpleExample.generateSequences(hmm);
        BaumWelchLearner baumWelchLearner = new BaumWelchLearner();
        Hmm<ObservationDiscrete<Packet>> hmm2 = SimpleExample.buildInitHmm();
        KullbackLeiblerDistanceCalculator kullbackLeiblerDistanceCalculator = new KullbackLeiblerDistanceCalculator();
        for (int i = 0; i < 10; ++i) {
            System.out.println("Distance at iteration " + i + ": " + kullbackLeiblerDistanceCalculator.distance(hmm2, hmm));
            hmm2 = baumWelchLearner.iterate(hmm2, list);
        }
        System.out.println("Resulting HMM:\n" + hmm2);
        ObservationDiscrete<Packet> observationDiscrete = Packet.OK.observation();
        ObservationDiscrete<Packet> observationDiscrete2 = Packet.LOSS.observation();
        ArrayList<ObservationDiscrete<Packet>> arrayList = new ArrayList<ObservationDiscrete<Packet>>();
        arrayList.add(observationDiscrete);
        arrayList.add(observationDiscrete);
        arrayList.add(observationDiscrete2);
        System.out.println("Sequence probability: " + hmm2.probability(arrayList));
        new GenericHmmDrawerDot().write(hmm2, "learntHmm.dot");
    }

    static Hmm<ObservationDiscrete<Packet>> buildHmm() {
        Hmm<ObservationDiscrete<Packet>> hmm = new Hmm<ObservationDiscrete<Packet>>(2, new OpdfDiscreteFactory<Packet>(Packet.class));
        hmm.setPi(0, 0.95);
        hmm.setPi(1, 0.05);
        hmm.setOpdf(0, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.95, 0.05}));
        hmm.setOpdf(1, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.2, 0.8}));
        hmm.setAij(0, 1, 0.05);
        hmm.setAij(0, 0, 0.95);
        hmm.setAij(1, 0, 0.1);
        hmm.setAij(1, 1, 0.9);
        return hmm;
    }

    static Hmm<ObservationDiscrete<Packet>> buildInitHmm() {
        Hmm<ObservationDiscrete<Packet>> hmm = new Hmm<ObservationDiscrete<Packet>>(2, new OpdfDiscreteFactory<Packet>(Packet.class));
        hmm.setPi(0, 0.5);
        hmm.setPi(1, 0.5);
        hmm.setOpdf(0, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.8, 0.2}));
        hmm.setOpdf(1, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.1, 0.9}));
        hmm.setAij(0, 1, 0.2);
        hmm.setAij(0, 0, 0.8);
        hmm.setAij(1, 0, 0.2);
        hmm.setAij(1, 1, 0.8);
        return hmm;
    }

    static <O extends Observation> List<List<O>> generateSequences(Hmm<O> hmm) {
        MarkovGenerator<O> markovGenerator = new MarkovGenerator<O>(hmm);
        ArrayList<List<O>> arrayList = new ArrayList<List<O>>();
        for (int i = 0; i < 200; ++i) {
            arrayList.add(markovGenerator.observationSequence(100));
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Packet {
        OK,
        LOSS;


        public ObservationDiscrete<Packet> observation() {
            return new ObservationDiscrete<Packet>(this);
        }
    }
}

