/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.ActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.RelatedObjs;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.Types;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.HmmReader;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationSequencesWriter;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationWriter;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfReader;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenerateActionHandler
extends ActionHandler {
    GenerateActionHandler() {
    }

    @Override
    public void act() throws FileNotFoundException, IOException, FileFormatException, AbnormalTerminationException {
        EnumSet<CommandLineArguments.Arguments> enumSet = EnumSet.of(CommandLineArguments.Arguments.OPDF, CommandLineArguments.Arguments.OUT_SEQS, CommandLineArguments.Arguments.IN_HMM);
        CommandLineArguments.checkArgs(enumSet);
        InputStream inputStream = CommandLineArguments.Arguments.IN_HMM.getAsInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        OutputStream outputStream = CommandLineArguments.Arguments.OUT_SEQS.getAsOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        this.write(inputStreamReader, outputStreamWriter, Types.relatedObjs());
        ((Writer)outputStreamWriter).flush();
    }

    private <O extends Observation> void write(Reader reader, Writer writer, RelatedObjs<O> relatedObjs) throws IOException, FileFormatException {
        ObservationWriter<O> observationWriter = relatedObjs.observationWriter();
        OpdfReader<Opdf<O>> opdfReader = relatedObjs.opdfReader();
        Hmm<O> hmm = HmmReader.read(reader, opdfReader);
        MarkovGenerator<O> markovGenerator = relatedObjs.generator(hmm);
        ArrayList<List<O>> arrayList = new ArrayList<List<O>>();
        for (int i = 0; i < 100; ++i) {
            arrayList.add(markovGenerator.observationSequence(1000));
        }
        ObservationSequencesWriter.write(writer, observationWriter, arrayList);
    }
}

