/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.cli;

import be.ac.ulg.montefiore.run.jahmm.apps.cli.AbnormalTerminationException;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.BWActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CommandLineArguments;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.CreateActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.GenerateActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.HelpActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.KLActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.KMeansActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.PrintActionHandler;
import be.ac.ulg.montefiore.run.jahmm.apps.cli.WrongArgumentsException;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import java.io.FileNotFoundException;
import java.io.IOException;

abstract class ActionHandler {
    ActionHandler() {
    }

    public void parseArguments(String[] stringArray) throws WrongArgumentsException {
        CommandLineArguments.parse(stringArray);
    }

    public abstract void act() throws FileNotFoundException, IOException, FileFormatException, AbnormalTerminationException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Actions {
        HELP("-help", HelpActionHandler.class),
        PRINT("print", PrintActionHandler.class),
        CREATE("create", CreateActionHandler.class),
        BW("learn-bw", BWActionHandler.class),
        KMEANS("learn-kmeans", KMeansActionHandler.class),
        GENERATE("generate", GenerateActionHandler.class),
        KL("distance-kl", KLActionHandler.class);

        private String argument;
        private Class<? extends ActionHandler> handler;

        private Actions(String string2, Class<? extends ActionHandler> clazz) {
            this.argument = string2;
            this.handler = clazz;
        }

        public String toString() {
            return this.argument;
        }

        public Class<? extends ActionHandler> handler() {
            return this.handler;
        }
    }
}

