/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViterbiCalculator {
    private double[][] delta;
    private int[][] psy;
    private int[] stateSequence;
    private double lnProbability;

    public <O extends Observation> ViterbiCalculator(List<? extends O> list, Hmm<O> hmm) {
        int n;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty sequence");
        }
        this.delta = new double[list.size()][hmm.nbStates()];
        this.psy = new int[list.size()][hmm.nbStates()];
        this.stateSequence = new int[list.size()];
        for (int i = 0; i < hmm.nbStates(); ++i) {
            this.delta[0][i] = -Math.log(hmm.getPi(i)) - Math.log(hmm.getOpdf(i).probability((Observation)list.get(0)));
            this.psy[0][i] = 0;
        }
        Iterator<O> iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        int n2 = 1;
        while (iterator.hasNext()) {
            Observation observation = (Observation)iterator.next();
            for (int i = 0; i < hmm.nbStates(); ++i) {
                this.computeStep(hmm, observation, n2, i);
            }
            ++n2;
        }
        this.lnProbability = Double.MAX_VALUE;
        for (n = 0; n < hmm.nbStates(); ++n) {
            double d = this.delta[list.size() - 1][n];
            if (!(this.lnProbability > d)) continue;
            this.lnProbability = d;
            this.stateSequence[list.size() - 1] = n;
        }
        this.lnProbability = -this.lnProbability;
        for (n = list.size() - 2; n >= 0; --n) {
            this.stateSequence[n] = this.psy[n + 1][this.stateSequence[n + 1]];
        }
    }

    private <O extends Observation> void computeStep(Hmm<O> hmm, O o, int n, int n2) {
        double d = Double.MAX_VALUE;
        int n3 = 0;
        for (int i = 0; i < hmm.nbStates(); ++i) {
            double d2 = this.delta[n - 1][i] - Math.log(hmm.getAij(i, n2));
            if (!(d > d2)) continue;
            d = d2;
            n3 = i;
        }
        this.delta[n][n2] = d - Math.log(hmm.getOpdf(n2).probability(o));
        this.psy[n][n2] = n3;
    }

    public double lnProbability() {
        return this.lnProbability;
    }

    public int[] stateSequence() {
        return (int[])this.stateSequence.clone();
    }
}

