/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.distributions.MultiGaussianDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfMultiGaussian
implements Opdf<ObservationVector> {
    private MultiGaussianDistribution distribution;
    private static final long serialVersionUID = 1L;

    public OpdfMultiGaussian(int n) {
        this.distribution = new MultiGaussianDistribution(n);
    }

    public OpdfMultiGaussian(double[] dArray, double[][] dArray2) {
        if (dArray2.length == 0 || dArray.length != dArray2.length || dArray2.length != dArray2[0].length) {
            throw new IllegalArgumentException();
        }
        this.distribution = new MultiGaussianDistribution(dArray, dArray2);
    }

    public double[] mean() {
        return this.distribution.mean();
    }

    public double[][] covariance() {
        return this.distribution.covariance();
    }

    public int dimension() {
        return this.distribution.dimension();
    }

    @Override
    public double probability(ObservationVector observationVector) {
        if (observationVector.dimension() != this.distribution.dimension()) {
            throw new IllegalArgumentException("Vector has a wrong dimension");
        }
        return this.distribution.probability(observationVector.value);
    }

    @Override
    public ObservationVector generate() {
        return new ObservationVector(this.distribution.generate());
    }

    public void fit(ObservationVector ... observationVectorArray) {
        this.fit((Collection<? extends ObservationVector>)Arrays.asList(observationVectorArray));
    }

    @Override
    public void fit(Collection<? extends ObservationVector> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Empty observation set");
        }
        double[] dArray = new double[collection.size()];
        Arrays.fill(dArray, 1.0 / (double)collection.size());
        this.fit(collection, dArray);
    }

    public void fit(ObservationVector[] observationVectorArray, double[] dArray) {
        this.fit((Collection<? extends ObservationVector>)Arrays.asList(observationVectorArray), dArray);
    }

    @Override
    public void fit(Collection<? extends ObservationVector> collection, double[] dArray) {
        int n;
        if (collection.isEmpty() || collection.size() != dArray.length) {
            throw new IllegalArgumentException();
        }
        double[] dArray2 = new double[this.dimension()];
        for (int i = 0; i < this.dimension(); ++i) {
            n = 0;
            for (ObservationVector observationVector : collection) {
                int n2 = i;
                dArray2[n2] = dArray2[n2] + observationVector.value[i] * dArray[n++];
            }
        }
        double[][] dArray3 = new double[this.dimension()][this.dimension()];
        n = 0;
        for (ObservationVector observationVector : collection) {
            int n3;
            double[] dArray4 = observationVector.value;
            double[] dArray5 = new double[dArray4.length];
            for (n3 = 0; n3 < dArray4.length; ++n3) {
                dArray5[n3] = dArray4[n3] - dArray2[n3];
            }
            for (n3 = 0; n3 < this.dimension(); ++n3) {
                for (int i = 0; i < this.dimension(); ++i) {
                    double[] dArray6 = dArray3[n3];
                    int n4 = i;
                    dArray6[n4] = dArray6[n4] + dArray5[n3] * dArray5[i] * dArray[n];
                }
            }
            ++n;
        }
        this.distribution = new MultiGaussianDistribution(dArray2, dArray3);
    }

    public OpdfMultiGaussian clone() {
        try {
            return (OpdfMultiGaussian)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        String string = "Multi-variate Gaussian distribution --- Mean: [ ";
        double[] dArray = this.distribution.mean();
        for (int i = 0; i < dArray.length; ++i) {
            string = string + numberFormat.format(dArray[i]) + " ";
        }
        return string + "]";
    }
}

