/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfInteger
implements Opdf<ObservationInteger> {
    private double[] probabilities;
    private static final long serialVersionUID = 1L;

    public OpdfInteger(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.probabilities = new double[n];
        for (int i = 0; i < n; ++i) {
            this.probabilities[i] = 1.0 / (double)n;
        }
    }

    public OpdfInteger(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Invalid empty array");
        }
        this.probabilities = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d;
            this.probabilities[i] = dArray[i];
            if (!(d < 0.0)) continue;
            throw new IllegalArgumentException();
        }
    }

    public int nbEntries() {
        return this.probabilities.length;
    }

    @Override
    public double probability(ObservationInteger observationInteger) {
        if (observationInteger.value > this.probabilities.length - 1) {
            throw new IllegalArgumentException("Wrong observation value");
        }
        return this.probabilities[observationInteger.value];
    }

    @Override
    public ObservationInteger generate() {
        double d = Math.random();
        for (int i = 0; i < this.probabilities.length - 1; ++i) {
            double d2;
            d -= this.probabilities[i];
            if (!(d2 < 0.0)) continue;
            return new ObservationInteger(i);
        }
        return new ObservationInteger(this.probabilities.length - 1);
    }

    public void fit(ObservationInteger ... observationIntegerArray) {
        this.fit((Collection<? extends ObservationInteger>)Arrays.asList(observationIntegerArray));
    }

    @Override
    public void fit(Collection<? extends ObservationInteger> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Empty observation set");
        }
        for (int i = 0; i < this.probabilities.length; ++i) {
            this.probabilities[i] = 0.0;
        }
        for (ObservationInteger observationInteger : collection) {
            int n = observationInteger.value;
            this.probabilities[n] = this.probabilities[n] + 1.0;
        }
        int n = 0;
        while (n < this.probabilities.length) {
            int n2 = n++;
            this.probabilities[n2] = this.probabilities[n2] / (double)collection.size();
        }
    }

    public void fit(ObservationInteger[] observationIntegerArray, double[] dArray) {
        this.fit((Collection<? extends ObservationInteger>)Arrays.asList(observationIntegerArray), dArray);
    }

    @Override
    public void fit(Collection<? extends ObservationInteger> collection, double[] dArray) {
        if (collection.isEmpty() || collection.size() != dArray.length) {
            throw new IllegalArgumentException();
        }
        Arrays.fill(this.probabilities, 0.0);
        int n = 0;
        for (ObservationInteger observationInteger : collection) {
            int n2 = observationInteger.value;
            this.probabilities[n2] = this.probabilities[n2] + dArray[n++];
        }
    }

    public OpdfInteger clone() {
        try {
            return (OpdfInteger)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        String string = "Integer distribution --- ";
        int n = 0;
        while (n < this.nbEntries()) {
            ObservationInteger observationInteger = new ObservationInteger(n);
            string = string + numberFormat.format(this.probability(observationInteger)) + (++n < this.nbEntries() ? " " : "");
        }
        return string;
    }
}

