/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Centroid;
import be.ac.ulg.montefiore.run.jahmm.CentroidFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansCalculator<K extends CentroidFactory<? super K>> {
    private ArrayList<Cluster<K>> clusters;

    public KMeansCalculator(int n, List<? extends K> list) {
        boolean bl;
        Cluster<K> cluster;
        int n2;
        CentroidFactory centroidFactory;
        int n3;
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal number of clusters");
        }
        this.clusters = new ArrayList(n);
        int n4 = 0;
        block0: for (n3 = 0; n3 < list.size() && n4 < n && list.size() - n3 > n - n4; ++n3) {
            centroidFactory = (CentroidFactory)list.get(n3);
            for (n2 = 0; n2 < n4; ++n2) {
                cluster = this.clusters.get(n2);
                if (cluster.centroid().distance(centroidFactory) != 0.0) continue;
                cluster.add(centroidFactory);
                continue block0;
            }
            this.clusters.add(new Cluster(this, (CentroidFactory)list.get(n3)));
            ++n4;
        }
        while (n4 < n && n3 < list.size()) {
            this.clusters.add(new Cluster(this, (CentroidFactory)list.get(n3)));
            ++n3;
            ++n4;
        }
        while (n4 < n) {
            this.clusters.add(new Cluster());
            ++n4;
        }
        while (n3 < list.size()) {
            centroidFactory = (CentroidFactory)list.get(n3);
            this.nearestCluster(centroidFactory).add(centroidFactory);
            ++n3;
        }
        do {
            bl = true;
            for (n2 = 0; n2 < n; ++n2) {
                cluster = this.clusters.get(n2);
                List<K> list2 = cluster.elements();
                for (int i = 0; i < list2.size(); ++i) {
                    Cluster<CentroidFactory> cluster2;
                    CentroidFactory centroidFactory2 = (CentroidFactory)list2.get(i);
                    if (!(cluster.centroid().distance(centroidFactory2) > 0.0) || cluster == (cluster2 = this.nearestCluster(centroidFactory2))) continue;
                    cluster2.add(centroidFactory2);
                    cluster.remove(i);
                    bl = false;
                }
            }
        } while (!bl);
    }

    private Cluster<K> nearestCluster(K k) {
        double d = Double.MAX_VALUE;
        Cluster<K> cluster = null;
        for (int i = 0; i < this.clusters.size(); ++i) {
            double d2 = this.clusters.get(i).centroid().distance(k);
            if (!(d > d2)) continue;
            d = d2;
            cluster = this.clusters.get(i);
        }
        return cluster;
    }

    public Collection<K> cluster(int n) {
        return this.clusters.get(n).elements();
    }

    public int nbClusters() {
        return this.clusters.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Cluster<L extends CentroidFactory<? super L>> {
        private List<L> elements;
        private Centroid<? super L> centroid;

        public Cluster() {
            this.elements = new ArrayList<L>();
            this.centroid = null;
        }

        public Cluster(L l) {
            this.elements = new ArrayList<L>();
            this.elements.add(l);
            this.centroid = l.factor();
        }

        public List<L> elements() {
            return this.elements;
        }

        public void add(L l) {
            if (this.centroid == null) {
                this.centroid = l.factor();
            } else {
                this.centroid.reevaluateAdd(l, this.elements);
            }
            this.elements.add(l);
        }

        public void remove(int n) {
            this.centroid.reevaluateRemove(this.elements.get(n), this.elements);
            this.elements.remove(n);
        }

        public Centroid<? super L> centroid() {
            return this.centroid;
        }
    }
}

