/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardBackwardScaledCalculator
extends ForwardBackwardCalculator {
    private double[] ctFactors;
    private double lnProbability;

    public <O extends Observation> ForwardBackwardScaledCalculator(List<? extends O> list, Hmm<O> hmm, EnumSet<ForwardBackwardCalculator.Computation> enumSet) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.ctFactors = new double[list.size()];
        Arrays.fill(this.ctFactors, 0.0);
        this.computeAlpha(hmm, list);
        if (enumSet.contains((Object)ForwardBackwardCalculator.Computation.BETA)) {
            this.computeBeta(hmm, list);
        }
        this.computeProbability(list, hmm, enumSet);
    }

    public <O extends Observation> ForwardBackwardScaledCalculator(List<? extends O> list, Hmm<O> hmm) {
        this(list, hmm, EnumSet.of(ForwardBackwardCalculator.Computation.ALPHA));
    }

    @Override
    protected <O extends Observation> void computeAlpha(Hmm<? super O> hmm, List<O> list) {
        this.alpha = new double[list.size()][hmm.nbStates()];
        for (int i = 0; i < hmm.nbStates(); ++i) {
            this.computeAlphaInit(hmm, (Observation)list.get(0), i);
        }
        this.scale(this.ctFactors, this.alpha, 0);
        Iterator<O> iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        for (int i = 1; i < list.size(); ++i) {
            Observation observation = (Observation)iterator.next();
            for (int j = 0; j < hmm.nbStates(); ++j) {
                this.computeAlphaStep(hmm, observation, i, j);
            }
            this.scale(this.ctFactors, this.alpha, i);
        }
    }

    @Override
    protected <O extends Observation> void computeBeta(Hmm<? super O> hmm, List<O> list) {
        int n;
        this.beta = new double[list.size()][hmm.nbStates()];
        for (n = 0; n < hmm.nbStates(); ++n) {
            this.beta[list.size() - 1][n] = 1.0 / this.ctFactors[list.size() - 1];
        }
        for (n = list.size() - 2; n >= 0; --n) {
            int n2 = 0;
            while (n2 < hmm.nbStates()) {
                this.computeBetaStep(hmm, (Observation)list.get(n + 1), n, n2);
                double[] dArray = this.beta[n];
                int n3 = n2++;
                dArray[n3] = dArray[n3] / this.ctFactors[n];
            }
        }
    }

    private void scale(double[] dArray, double[][] dArray2, int n) {
        int n2;
        double[] dArray3 = dArray2[n];
        double d = 0.0;
        for (n2 = 0; n2 < dArray3.length; ++n2) {
            d += dArray3[n2];
        }
        dArray[n] = d;
        n2 = 0;
        while (n2 < dArray3.length) {
            int n3 = n2++;
            dArray3[n3] = dArray3[n3] / d;
        }
    }

    private <O extends Observation> void computeProbability(List<O> list, Hmm<? super O> hmm, EnumSet<ForwardBackwardCalculator.Computation> enumSet) {
        this.lnProbability = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            this.lnProbability += Math.log(this.ctFactors[i]);
        }
        this.probability = Math.exp(this.lnProbability);
    }

    public double lnProbability() {
        return this.lnProbability;
    }
}

