/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardBackwardCalculator {
    protected double[][] alpha = null;
    protected double[][] beta = null;
    protected double probability;

    protected ForwardBackwardCalculator() {
    }

    public <O extends Observation> ForwardBackwardCalculator(List<? extends O> list, Hmm<O> hmm, EnumSet<Computation> enumSet) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty sequence");
        }
        if (enumSet.contains((Object)Computation.ALPHA)) {
            this.computeAlpha(hmm, list);
        }
        if (enumSet.contains((Object)Computation.BETA)) {
            this.computeBeta(hmm, list);
        }
        this.computeProbability(list, hmm, enumSet);
    }

    public <O extends Observation> ForwardBackwardCalculator(List<? extends O> list, Hmm<O> hmm) {
        this(list, hmm, EnumSet.of(Computation.ALPHA));
    }

    protected <O extends Observation> void computeAlpha(Hmm<? super O> hmm, List<O> list) {
        this.alpha = new double[list.size()][hmm.nbStates()];
        for (int i = 0; i < hmm.nbStates(); ++i) {
            this.computeAlphaInit(hmm, (Observation)list.get(0), i);
        }
        Iterator<O> iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        for (int i = 1; i < list.size(); ++i) {
            Observation observation = (Observation)iterator.next();
            for (int j = 0; j < hmm.nbStates(); ++j) {
                this.computeAlphaStep(hmm, observation, i, j);
            }
        }
    }

    protected <O extends Observation> void computeAlphaInit(Hmm<? super O> hmm, O o, int n) {
        this.alpha[0][n] = hmm.getPi(n) * hmm.getOpdf(n).probability(o);
    }

    protected <O extends Observation> void computeAlphaStep(Hmm<? super O> hmm, O o, int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < hmm.nbStates(); ++i) {
            d += this.alpha[n - 1][i] * hmm.getAij(i, n2);
        }
        this.alpha[n][n2] = d * hmm.getOpdf(n2).probability(o);
    }

    protected <O extends Observation> void computeBeta(Hmm<? super O> hmm, List<O> list) {
        int n;
        this.beta = new double[list.size()][hmm.nbStates()];
        for (n = 0; n < hmm.nbStates(); ++n) {
            this.beta[list.size() - 1][n] = 1.0;
        }
        for (n = list.size() - 2; n >= 0; --n) {
            for (int i = 0; i < hmm.nbStates(); ++i) {
                this.computeBetaStep(hmm, (Observation)list.get(n + 1), n, i);
            }
        }
    }

    protected <O extends Observation> void computeBetaStep(Hmm<? super O> hmm, O o, int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < hmm.nbStates(); ++i) {
            d += this.beta[n + 1][i] * hmm.getAij(n2, i) * hmm.getOpdf(i).probability(o);
        }
        this.beta[n][n2] = d;
    }

    public double alphaElement(int n, int n2) {
        if (this.alpha == null) {
            throw new UnsupportedOperationException("Alpha array has not been computed");
        }
        return this.alpha[n][n2];
    }

    public double betaElement(int n, int n2) {
        if (this.beta == null) {
            throw new UnsupportedOperationException("Beta array has not been computed");
        }
        return this.beta[n][n2];
    }

    private <O extends Observation> void computeProbability(List<O> list, Hmm<? super O> hmm, EnumSet<Computation> enumSet) {
        this.probability = 0.0;
        if (enumSet.contains((Object)Computation.ALPHA)) {
            for (int i = 0; i < hmm.nbStates(); ++i) {
                this.probability += this.alpha[list.size() - 1][i];
            }
        } else {
            for (int i = 0; i < hmm.nbStates(); ++i) {
                this.probability += hmm.getPi(i) * hmm.getOpdf(i).probability((Observation)list.get(0)) * this.beta[0][i];
            }
        }
    }

    public double probability() {
        return this.probability;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Computation {
        ALPHA,
        BETA;

    }
}

