/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.DiscreteDistribution;

public class PoissonDistribution
implements DiscreteDistribution {
    private final double mean;
    private static final double[] logFactTable = new double[]{0.0, 0.0, 0.6931471805599453, 1.791759469228055, 3.1780538303479458, 4.787491742782046, 6.579251212010101, 8.525161361065415, 10.60460290274525, 12.801827480081469, 15.104412573075516, 17.502307845873887, 19.987214495661885, 22.552163853123425, 25.19122118273868, 27.89927138384089, 30.671860106080672, 33.50507345013689, 36.39544520803305, 39.339884187199495, 42.335616460753485, 45.38013889847691, 48.47118135183523, 51.60667556776438, 54.78472939811232, 58.00360522298052, 61.261701761002, 64.55753862700634, 67.88974313718154, 71.25703896716801};
    private final double C0 = 0.9189385332046728;
    private final double C1 = 0.08333333333333333;
    private final double C3 = -0.002777777777777778;
    private final double C5 = 7.936507936507937E-4;
    private final double C7 = -5.952380952380953E-4;
    private static final long serialVersionUID = 2516179242233627286L;

    public PoissonDistribution(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.mean = d;
    }

    public double mean() {
        return this.mean;
    }

    public int generate() {
        int n = 0;
        double d = 1.0;
        double d2 = Math.exp(-this.mean);
        while (d > d2) {
            d *= Math.random();
            ++n;
        }
        return n - 1;
    }

    public double probability(int n) {
        return Math.exp((double)n * Math.log(this.mean) - this.logFactorial(n) - this.mean);
    }

    private double logFactorial(int n) {
        if (n >= logFactTable.length) {
            double d = 1.0 / (double)n;
            return ((double)n + 0.5) * Math.log(n) - (double)n + 0.9189385332046728 + d * (0.08333333333333333 + d * d * (-0.002777777777777778 + d * d * (7.936507936507937E-4 + d * d * -5.952380952380953E-4)));
        }
        return logFactTable[n];
    }
}

