/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.distributions.RandomDistribution;
import java.util.Arrays;
import java.util.Random;

public class GaussianMixtureDistribution
implements RandomDistribution {
    private static final Random random = new Random();
    private GaussianDistribution[] distributions;
    private double[] proportions;
    private static final long serialVersionUID = 2634624658500627331L;

    public GaussianMixtureDistribution(int n) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.distributions = new GaussianDistribution[n];
        this.proportions = new double[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = (1.0 + 2.0 * (double)n2) / (2.0 * (double)n);
        }
        Arrays.fill(dArray2, 1.0);
        Arrays.fill(this.proportions, 1.0 / (double)n);
        for (n2 = 0; n2 < this.distributions.length; ++n2) {
            this.distributions[n2] = new GaussianDistribution(dArray[n2], dArray2[n2]);
        }
    }

    public GaussianMixtureDistribution(double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        if (dArray.length == 0 || dArray.length != dArray2.length || dArray.length != dArray3.length) {
            throw new IllegalArgumentException();
        }
        this.distributions = new GaussianDistribution[dArray.length];
        this.proportions = new double[dArray.length];
        for (int i = 0; i < this.distributions.length; ++i) {
            this.distributions[i] = new GaussianDistribution(dArray[i], dArray2[i]);
        }
        double d = 0.0;
        for (n = 0; n < dArray3.length; ++n) {
            d += dArray3[n];
        }
        for (n = 0; n < dArray3.length; ++n) {
            this.proportions[n] = dArray3[n] / d;
        }
    }

    public int nbGaussians() {
        return this.distributions.length;
    }

    public GaussianDistribution[] distributions() {
        return (GaussianDistribution[])this.distributions.clone();
    }

    public double[] proportions() {
        return (double[])this.proportions.clone();
    }

    public double generate() {
        double d = random.nextDouble();
        double d2 = 0.0;
        for (int i = 0; i < this.proportions.length; ++i) {
            if (!(d <= (d2 += this.proportions[i]))) continue;
            return this.distributions[i].generate();
        }
        throw new RuntimeException("Internal error");
    }

    public double probability(double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.distributions.length; ++i) {
            d2 += this.distributions[i].probability(d) * this.proportions[i];
        }
        return d2;
    }
}

