/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.RandomDistribution;
import java.util.Random;

public class GaussianDistribution
implements RandomDistribution {
    private double mean;
    private double deviation;
    private double variance;
    private static final Random randomGenerator = new Random();
    private static final long serialVersionUID = 9127329839769283975L;

    public GaussianDistribution() {
        this(0.0, 1.0);
    }

    public GaussianDistribution(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Variance must be positive");
        }
        this.mean = d;
        this.variance = d2;
        this.deviation = Math.sqrt(d2);
    }

    public double mean() {
        return this.mean;
    }

    public double variance() {
        return this.variance;
    }

    public double generate() {
        return randomGenerator.nextGaussian() * this.deviation + this.mean;
    }

    public double probability(double d) {
        double d2 = -0.5 * (d - this.mean) * (d - this.mean) / this.variance;
        return Math.pow(Math.PI * 2 * this.variance, -0.5) * Math.exp(d2);
    }
}

