/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import jp.crestmuse.cmx.filewrappers.CSVWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationDataSet;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteUpdateListener;
import jp.crestmuse.cmx.handlers.NoteHandlerPartwise;
import jp.crestmuse.cmx.misc.MutableMusicEvent;
import jp.crestmuse.cmx.misc.MutableNote;
import jp.crestmuse.cmx.misc.TreeView;

public class DeviatedPerformance {
    public static int TICKS_PER_BEAT = 480;
    private int BASE_VELOCITY = 100;
    private int TEMPO = 72;
    private Sequence sequence = new Sequence(0.0f, TICKS_PER_BEAT);
    private MusicXMLWrapper musicxml;
    private ArrayList<DeviatedNote> deviatedNotes = new ArrayList();
    private TreeMap<Integer, Integer> ticks2tempo = new TreeMap();
    private TreeMap<Integer, Integer> ticks2msec = new TreeMap();
    private final int linearDivision = 8;
    private List<DeviatedNoteUpdateListener> listeners;
    private Track tempoTrack;
    private TreeMap<Integer, MidiEvent> ticks2midievent = new TreeMap();

    public DeviatedPerformance(final DeviationInstanceWrapper deviationInstanceWrapper) throws IOException, InvalidMidiDataException {
        this.listeners = new LinkedList<DeviatedNoteUpdateListener>();
        this.processNonPartwiseControls(deviationInstanceWrapper);
        this.calcMsecs();
        final HashMap hashMap = new HashMap();
        final HashMap hashMap2 = new HashMap();
        this.musicxml = deviationInstanceWrapper.getTargetMusicXML();
        this.musicxml.processNotePartwise(new NoteHandlerPartwise(){
            private Track track;
            private TreeMap<Integer, Double> tick2basedynamics;

            @Override
            public void beginPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
                this.track = DeviatedPerformance.this.sequence.createTrack();
                hashMap.put(part.id(), this.track);
                this.tick2basedynamics = DeviatedPerformance.this.getTick2BaseDynamics(deviationInstanceWrapper, part.id());
                hashMap2.put(part.id(), this.tick2basedynamics);
            }

            @Override
            public void beginMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            @Override
            public void endMeasure(MusicXMLWrapper.Measure measure, MusicXMLWrapper musicXMLWrapper) {
            }

            @Override
            public void endPart(MusicXMLWrapper.Part part, MusicXMLWrapper musicXMLWrapper) {
            }

            @Override
            public void processMusicData(MusicXMLWrapper.MusicData musicData, MusicXMLWrapper musicXMLWrapper) {
                if (!(musicData instanceof MusicXMLWrapper.Note)) {
                    return;
                }
                MusicXMLWrapper.Note note = (MusicXMLWrapper.Note)musicData;
                if (note.rest() || "none".equals(note.notehead()) || note.containsTieType("stop")) {
                    return;
                }
                double d = 1.0;
                for (Map.Entry<Integer, Double> entry : this.tick2basedynamics.entrySet()) {
                    if (entry.getKey() > note.onset(TICKS_PER_BEAT)) break;
                    d = entry.getValue();
                }
                try {
                    DeviationInstanceWrapper.ChordDeviation chordDeviation;
                    if (deviationInstanceWrapper.getMissNote(note) != null) {
                        DeviatedPerformance.this.deviatedNotes.add(new DeviatedNote(note, true, this.track, d));
                        return;
                    }
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 1.0;
                    double d5 = 1.0;
                    DeviationInstanceWrapper.NoteDeviation noteDeviation = deviationInstanceWrapper.getNoteDeviation(note);
                    if (noteDeviation != null) {
                        d2 += noteDeviation.attack();
                        d3 += noteDeviation.release();
                        d4 *= noteDeviation.dynamics();
                        d5 *= noteDeviation.endDynamics();
                    }
                    if ((chordDeviation = deviationInstanceWrapper.getChordDeviation(note)) != null) {
                        d2 += chordDeviation.attack();
                        d3 += chordDeviation.release();
                        d4 *= chordDeviation.dynamics();
                        d5 *= chordDeviation.endDynamics();
                    }
                    String string = "rate";
                    if (noteDeviation != null) {
                        string = noteDeviation.dynamicsType();
                    }
                    DeviatedPerformance.this.deviatedNotes.add(new DeviatedNote(note, false, this.track, d2, d3, d4, d5, d, string));
                }
                catch (InvalidMidiDataException invalidMidiDataException) {
                    invalidMidiDataException.printStackTrace();
                }
            }
        });
        for (Map.Entry entry : hashMap.entrySet()) {
            this.processExtraNotes(deviationInstanceWrapper, (String)entry.getKey(), (Track)entry.getValue(), (TreeMap)hashMap2.get(entry.getKey()));
        }
        int n = 0;
        while ((long)n < this.sequence.getTickLength()) {
            if (n > this.ticks2tempo.lastKey()) {
                this.setTempo(n, this.ticks2tempo.get(this.ticks2tempo.lastKey()));
            }
            n += TICKS_PER_BEAT;
        }
        Collections.sort(this.deviatedNotes);
    }

    private void processNonPartwiseControls(DeviationInstanceWrapper deviationInstanceWrapper) {
        this.tempoTrack = this.sequence.createTrack();
        this.setTempo(0, this.TEMPO);
        int[] nArray = new int[]{this.TEMPO};
        TreeView<DeviationInstanceWrapper.Control> treeView = deviationInstanceWrapper.getNonPartwiseControlView();
        int n = this.addTempo(treeView.getRoot(), this.TEMPO, nArray);
        while (treeView.hasElementsAtNextTime()) {
            n = this.addTempo(treeView.getFirstElementAtNextTime(), n, nArray);
            while (treeView.hasMoreElementsAtSameTime()) {
                n = this.addTempo(treeView.getNextElementAtSameTime(), n, nArray);
            }
        }
    }

    private int addTempo(DeviationInstanceWrapper.Control control, int n, int[] nArray) {
        int n2;
        if (control == null) {
            return n;
        }
        if (control.type().equals("tempo")) {
            n2 = n = (int)control.value();
        } else if (control.type().equals("tempo-deviation")) {
            n2 = (int)((double)n * control.value());
            String string = null;
            if (control.containsAttributeInChild("curve")) {
                string = control.getChildAttribute("curve");
            }
            if (string != null && string.equals("linear")) {
                double d = (double)TICKS_PER_BEAT / 8.0;
                double d2 = (double)(n2 - nArray[0]) / 8.0;
                for (int i = 7; i >= 1; --i) {
                    try {
                        this.setTempo(control.timestamp(TICKS_PER_BEAT) - (int)(d * (double)i), n2 - (int)(d2 * (double)i));
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        } else {
            return n;
        }
        try {
            this.setTempo(control.timestamp(TICKS_PER_BEAT), n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        nArray[0] = n2;
        return n;
    }

    public void setTempo(int n, int n2) {
        MetaMessage metaMessage = new MetaMessage();
        int n3 = 60000000 / n2;
        try {
            metaMessage.setMessage(81, new byte[]{(byte)(n3 / 65536), (byte)(n3 % 65536 / 256), (byte)(n3 % 256)}, 3);
            MidiEvent midiEvent = this.ticks2midievent.get(n);
            if (midiEvent != null) {
                this.tempoTrack.remove(midiEvent);
            }
            midiEvent = new MidiEvent(metaMessage, n);
            this.tempoTrack.add(midiEvent);
            this.ticks2tempo.put(n, n2);
            this.ticks2midievent.put(n, midiEvent);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    private void calcMsecs() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (Map.Entry<Integer, Integer> entry : this.ticks2tempo.entrySet()) {
            n = (int)((double)n + (double)(entry.getKey() - n2) / (double)TICKS_PER_BEAT / (double)n3 * 60.0 * 1000.0);
            this.ticks2msec.put(entry.getKey(), n);
            n2 = entry.getKey();
            n3 = entry.getValue();
        }
    }

    private TreeMap<Integer, Double> getTick2BaseDynamics(DeviationInstanceWrapper deviationInstanceWrapper, String string) {
        TreeMap<Integer, Double> treeMap = new TreeMap<Integer, Double>();
        TreeView<DeviationInstanceWrapper.Control> treeView = deviationInstanceWrapper.getPartwiseControlView(string);
        treeView.getRoot();
        while (treeView.hasElementsAtNextTime()) {
            this.addBaseDynamics(treeView.getFirstElementAtNextTime(), treeMap);
            while (treeView.hasMoreElementsAtSameTime()) {
                this.addBaseDynamics(treeView.getNextElementAtSameTime(), treeMap);
            }
        }
        return treeMap;
    }

    private void addBaseDynamics(DeviationInstanceWrapper.Control control, TreeMap<Integer, Double> treeMap) {
        if (control == null || !control.type().equals("base-dynamics")) {
            return;
        }
        try {
            treeMap.put(control.timestamp(TICKS_PER_BEAT), control.value());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void processExtraNotes(DeviationInstanceWrapper deviationInstanceWrapper, String string, Track track, TreeMap<Integer, Double> treeMap) {
        TreeView<DeviationInstanceWrapper.ExtraNote> treeView = deviationInstanceWrapper.getExtraNoteView(string);
        this.addExtraNote(treeView.getRoot(), string, track, treeMap);
        while (treeView.hasElementsAtNextTime()) {
            this.addExtraNote(treeView.getFirstElementAtNextTime(), string, track, treeMap);
            while (treeView.hasMoreElementsAtSameTime()) {
                this.addExtraNote(treeView.getNextElementAtSameTime(), string, track, treeMap);
            }
        }
    }

    private void addExtraNote(DeviationInstanceWrapper.ExtraNote extraNote, String string, Track track, TreeMap<Integer, Double> treeMap) {
        if (extraNote == null) {
            return;
        }
        try {
            int n = extraNote.timestamp(TICKS_PER_BEAT);
            int n2 = n + (int)(extraNote.duration() * (double)TICKS_PER_BEAT);
            double d = 1.0;
            for (Map.Entry<Integer, Double> entry : treeMap.entrySet()) {
                if (entry.getKey() > n) break;
                d = entry.getValue();
            }
            this.deviatedNotes.add(new DeviatedNote(null, false, track, n, n2, extraNote.notenum(), 0.0, 0.0, extraNote.dynamics(), extraNote.endDynamics(), string, d, "rate"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public MusicXMLWrapper getMusicXML() {
        return this.musicxml;
    }

    public ArrayList<DeviatedNote> getDeviatedNotes() {
        return this.deviatedNotes;
    }

    public Map<Integer, Integer> getTicks2Tempo() {
        return this.ticks2tempo;
    }

    public void addListener(DeviatedNoteUpdateListener deviatedNoteUpdateListener) {
        this.listeners.add(deviatedNoteUpdateListener);
    }

    private void notifyUpdate(DeviatedNote deviatedNote) {
        for (DeviatedNoteUpdateListener deviatedNoteUpdateListener : this.listeners) {
            deviatedNoteUpdateListener.noteUpdated(deviatedNote);
        }
    }

    public DeviationInstanceWrapper calcDeviation() throws InvalidFileTypeException {
        DeviationDataSet deviationDataSet = new DeviationDataSet(this.musicxml);
        double d = 0.0;
        Iterator<Object> iterator = this.ticks2tempo.values().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            d += (double)n;
        }
        deviationDataSet.addNonPartwiseControl(1, 1.0, "tempo", d /= (double)this.ticks2tempo.size());
        for (Map.Entry entry : this.ticks2tempo.entrySet()) {
            deviationDataSet.addNonPartwiseControl((Integer)entry.getKey() / (TICKS_PER_BEAT * 4) + 1, (double)((Integer)entry.getKey() % (TICKS_PER_BEAT * 4)) / (double)TICKS_PER_BEAT + 1.0, "tempo-deviation", (double)((Integer)entry.getValue()).intValue() / d);
        }
        for (DeviatedNote deviatedNote : this.deviatedNotes) {
            deviatedNote.write(deviationDataSet);
        }
        return deviationDataSet.toWrapper();
    }

    public CSVWrapper toTempoBaseCSV(int n) {
        int n2;
        CSVWrapper cSVWrapper = new CSVWrapper();
        cSVWrapper.addRow();
        cSVWrapper.addValue(0, "measure");
        cSVWrapper.addValue(0, "beat");
        cSVWrapper.addValue(0, "tempo");
        Iterator<Map.Entry<Integer, Integer>> iterator = this.ticks2tempo.entrySet().iterator();
        Map.Entry<Integer, Integer> entry = iterator.next();
        int n3 = entry.getValue();
        if (iterator.hasNext()) {
            entry = iterator.next();
        }
        Iterator<DeviatedNote> iterator2 = this.deviatedNotes.iterator();
        DeviatedNote deviatedNote = null;
        if (iterator2.hasNext()) {
            deviatedNote = iterator2.next();
        }
        int n4 = 0;
        for (n2 = 0; n2 < (int)(this.sequence.getTickLength() / (long)n) + 1; ++n2) {
            cSVWrapper.addRow();
            cSVWrapper.addValue(n2 + 1, n2 / 4 + 1 + "");
            cSVWrapper.addValue(n2 + 1, n2 % 4 + 1 + "");
            if (n2 * n >= entry.getKey() && iterator.hasNext()) {
                entry = iterator.next();
                n3 = entry.getValue();
            }
            cSVWrapper.addValue(n2 + 1, n3 + "");
            int n5 = 0;
            while (deviatedNote != null && (n2 + 1) * n > deviatedNote.onset(n)) {
                cSVWrapper.addValue(n2 + 1, (double)deviatedNote.onsetOriginal() / (double)n + "");
                cSVWrapper.addValue(n2 + 1, deviatedNote.getAttack() + "");
                cSVWrapper.addValue(n2 + 1, (double)deviatedNote.offsetOriginal() / (double)n + "");
                cSVWrapper.addValue(n2 + 1, deviatedNote.getRelease() + "");
                cSVWrapper.addValue(n2 + 1, deviatedNote.notenum() + "");
                cSVWrapper.addValue(n2 + 1, deviatedNote.velocity() + "");
                deviatedNote = iterator2.hasNext() ? iterator2.next() : null;
                ++n5;
            }
            n4 = Math.max(n5, n4);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            cSVWrapper.addValue(0, "onset");
            cSVWrapper.addValue(0, "onset deviation");
            cSVWrapper.addValue(0, "offset");
            cSVWrapper.addValue(0, "offset deviation");
            cSVWrapper.addValue(0, "notenum");
            cSVWrapper.addValue(0, "velocity");
        }
        return cSVWrapper;
    }

    public CSVWrapper toSccBaseCSV(int n) {
        CSVWrapper cSVWrapper = new CSVWrapper();
        cSVWrapper.addRow();
        cSVWrapper.addValue(0, "measure");
        cSVWrapper.addValue(0, "beat");
        cSVWrapper.addValue(0, "onset");
        cSVWrapper.addValue(0, "onset deviation");
        cSVWrapper.addValue(0, "offset");
        cSVWrapper.addValue(0, "offset deviation");
        cSVWrapper.addValue(0, "notenum");
        cSVWrapper.addValue(0, "velocity");
        int n2 = 1;
        for (DeviatedNote deviatedNote : this.deviatedNotes) {
            cSVWrapper.addRow();
            int n3 = deviatedNote.onset();
            cSVWrapper.addValue(n2, n3 / (n * 4) + 1 + "");
            cSVWrapper.addValue(n2, n3 % (n * 4) / n + 1 + "");
            cSVWrapper.addValue(n2, (double)deviatedNote.onsetOriginal() / (double)n + "");
            cSVWrapper.addValue(n2, deviatedNote.getAttack() + "");
            cSVWrapper.addValue(n2, (double)deviatedNote.offsetOriginal() / (double)n + "");
            cSVWrapper.addValue(n2, deviatedNote.getRelease() + "");
            cSVWrapper.addValue(n2, deviatedNote.notenum() + "");
            cSVWrapper.addValue(n2, deviatedNote.velocity() + "");
            ++n2;
        }
        return cSVWrapper;
    }

    public class DeviatedNote
    extends MutableNote {
        private MusicXMLWrapper.Note note;
        private double attack;
        private double release;
        private double dynamics;
        private double endDynamics;
        private boolean isMissNote;
        private double baseDynamics;
        private String dynamicsType;
        private String partid;
        private Track track;
        private MidiEvent noteOn;
        private MidiEvent noteOff;

        private DeviatedNote(MusicXMLWrapper.Note note, boolean bl, Track track, double d) throws InvalidMidiDataException {
            this(note, bl, track, 0.0, 0.0, 1.0, 1.0, d, "rate");
        }

        private DeviatedNote(MusicXMLWrapper.Note note, boolean bl, Track track, double d, double d2, double d3, double d4, double d5, String string) throws InvalidMidiDataException {
            this(note, bl, track, note.onset(TICKS_PER_BEAT), note.offset(TICKS_PER_BEAT), note.notenum(), d, d2, d3, d4, null, d5, string);
        }

        private DeviatedNote(MusicXMLWrapper.Note note, boolean bl, Track track, int n, int n2, int n3, double d, double d2, double d3, double d4, String string, double d5, String string2) throws InvalidMidiDataException {
            super(n, n2, n3, DeviatedPerformance.this.BASE_VELOCITY, DeviatedPerformance.this.BASE_VELOCITY, TICKS_PER_BEAT);
            this.note = note;
            this.attack = d;
            this.release = d2;
            this.dynamics = d3;
            this.endDynamics = d4;
            this.partid = string;
            this.baseDynamics = d5;
            this.dynamicsType = string2;
            this.track = track;
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(144, this.notenum(), this.velocity());
            this.noteOn = new MidiEvent(shortMessage, this.onset());
            ShortMessage shortMessage2 = new ShortMessage();
            shortMessage2.setMessage(128, this.notenum(), this.offVelocity());
            this.noteOff = new MidiEvent(shortMessage2, this.offset());
            track.add(this.noteOn);
            track.add(this.noteOff);
            this.setMissNote(bl);
        }

        @Override
        public int onset() {
            return super.onset() + (int)((double)TICKS_PER_BEAT * this.attack);
        }

        public int onsetOriginal() {
            return super.onset();
        }

        @Override
        public int onsetInMSec() {
            return this.tickInMSec(new OnsetHandler());
        }

        public int onsetOriginalInMSec() {
            return this.tickInMSec(new OnsetOriginalHandler());
        }

        @Override
        public int offset() {
            return super.offset() + (int)((double)TICKS_PER_BEAT * this.release);
        }

        public int offsetOriginal() {
            return super.offset();
        }

        @Override
        public int offsetInMSec() {
            return this.tickInMSec(new OffsetHandler());
        }

        public int offsetOriginalInMSec() {
            return this.tickInMSec(new OffsetOriginalHandler());
        }

        private int tickInMSec(TickHandler tickHandler) {
            int n = 0;
            Iterator iterator = DeviatedPerformance.this.ticks2msec.keySet().iterator();
            while (iterator.hasNext()) {
                int n2;
                n = n2 = ((Integer)iterator.next()).intValue();
                if (n2 <= tickHandler.tick()) continue;
                break;
            }
            return (Integer)DeviatedPerformance.this.ticks2msec.get(n) + (int)((double)(tickHandler.tick() - n) / (double)TICKS_PER_BEAT / (double)((Integer)DeviatedPerformance.this.ticks2tempo.get(n)).intValue() * 60.0 * 1000.0);
        }

        @Override
        public int velocity() {
            if (this.isMissNote) {
                return 0;
            }
            int n = this.dynamicsType.equals("diff") ? (int)((double)super.velocity() * (this.baseDynamics + this.dynamics)) : (int)((double)super.velocity() * this.baseDynamics * this.dynamics);
            return Math.min(n, 127);
        }

        public double velocity2dynamics(int n) {
            if (this.dynamicsType.equals("diff")) {
                return (double)n / (double)super.velocity() - this.baseDynamics;
            }
            return (double)n / ((double)super.velocity() * this.baseDynamics);
        }

        @Override
        public int offVelocity() {
            int n = this.dynamicsType.equals("diff") ? (int)((double)super.offVelocity() * (this.baseDynamics + this.dynamics)) : (int)((double)super.offVelocity() * this.baseDynamics * this.dynamics);
            return Math.min(n, 127);
        }

        public MusicXMLWrapper.Note getNote() {
            return this.note;
        }

        public boolean isExtraNote() {
            return this.note == null;
        }

        public double getAttack() {
            return this.attack;
        }

        public double getRelease() {
            return this.release;
        }

        public double getDynamics() {
            return this.dynamics;
        }

        public double getEndDynamics() {
            return this.endDynamics;
        }

        public boolean getIsMissNote() {
            return this.isMissNote;
        }

        public void setMissNote(boolean bl) throws InvalidMidiDataException {
            this.isMissNote = bl;
            this.updateMidiEvent();
            DeviatedPerformance.this.notifyUpdate(this);
        }

        public void setExtraNote() {
            this.note = null;
        }

        public boolean changeDeviation(double d, double d2) throws InvalidMidiDataException {
            return this.changeDeviation(d, d2, this.dynamics, this.endDynamics);
        }

        public boolean changeDeviation(double d, double d2, double d3, double d4) throws InvalidMidiDataException {
            this.attack += d;
            this.release += d2;
            if (this.onset() >= this.offset() || d3 < 0.0 || d4 < 0.0) {
                this.attack -= d;
                this.release -= d2;
                return false;
            }
            this.dynamics = d3;
            this.endDynamics = d4;
            this.updateMidiEvent();
            DeviatedPerformance.this.notifyUpdate(this);
            return true;
        }

        public boolean changeAttackInMsec(int n) throws InvalidMidiDataException {
            int n2 = (Integer)DeviatedPerformance.this.ticks2msec.firstKey();
            for (Map.Entry entry : DeviatedPerformance.this.ticks2msec.entrySet()) {
                if ((Integer)entry.getValue() > n) break;
                n2 = (Integer)entry.getKey();
            }
            double d = (double)((Integer)DeviatedPerformance.this.ticks2tempo.get(n2)).intValue() / 60.0;
            double d2 = (double)(n - (Integer)DeviatedPerformance.this.ticks2msec.get(n2)) / 1000.0;
            int n3 = (int)(d * d2 * (double)TICKS_PER_BEAT);
            int n4 = n2 + n3;
            return this.changeDeviation((double)(n4 - this.onset()) / (double)TICKS_PER_BEAT, 0.0);
        }

        public boolean changeReleaseInMsec(int n) throws InvalidMidiDataException {
            int n2 = (Integer)DeviatedPerformance.this.ticks2msec.firstKey();
            for (Map.Entry entry : DeviatedPerformance.this.ticks2msec.entrySet()) {
                if ((Integer)entry.getValue() > n) break;
                n2 = (Integer)entry.getKey();
            }
            double d = (double)((Integer)DeviatedPerformance.this.ticks2tempo.get(n2)).intValue() / 60.0;
            double d2 = (double)(n - (Integer)DeviatedPerformance.this.ticks2msec.get(n2)) / 1000.0;
            int n3 = (int)(d * d2 * (double)TICKS_PER_BEAT);
            int n4 = n2 + n3;
            return this.changeDeviation(0.0, (double)(n4 - this.offset()) / (double)TICKS_PER_BEAT);
        }

        private void updateMidiEvent() throws InvalidMidiDataException {
            ShortMessage shortMessage = (ShortMessage)this.noteOn.getMessage();
            shortMessage.setMessage(shortMessage.getStatus(), shortMessage.getData1(), this.velocity());
            MidiEvent midiEvent = new MidiEvent(shortMessage, this.onset());
            ShortMessage shortMessage2 = (ShortMessage)this.noteOff.getMessage();
            shortMessage2.setMessage(shortMessage2.getStatus(), shortMessage2.getData1(), this.offVelocity());
            MidiEvent midiEvent2 = new MidiEvent(shortMessage2, this.offset());
            this.track.remove(this.noteOn);
            this.track.remove(this.noteOff);
            this.track.add(midiEvent);
            this.track.add(midiEvent2);
            this.noteOn = midiEvent;
            this.noteOff = midiEvent2;
        }

        public void write(DeviationDataSet deviationDataSet) {
            if (this.note == null) {
                if (this.isMissNote) {
                    return;
                }
                int n = this.onset() / (TICKS_PER_BEAT * 4) + 1;
                double d = (double)(this.onset() % (TICKS_PER_BEAT * 4)) / (double)TICKS_PER_BEAT + 1.0;
                double d2 = (double)(this.offset() - this.onset()) / (double)TICKS_PER_BEAT;
                deviationDataSet.addExtraNote(this.partid, n, d, this.notenum(), d2, this.dynamics, this.endDynamics);
            } else if (this.isMissNote) {
                deviationDataSet.addMissNote(this.note);
            } else if (this.attack != 0.0 || this.release != 0.0 || this.dynamics != 1.0 || this.endDynamics != 1.0) {
                deviationDataSet.addNoteDeviation(this.note, this.attack, this.release, this.dynamics, this.endDynamics);
            }
        }

        @Override
        public int compareTo(MutableMusicEvent mutableMusicEvent) {
            return this.onset() == mutableMusicEvent.onset() ? this.notenum() - ((DeviatedNote)mutableMusicEvent).notenum() : this.onset() - mutableMusicEvent.onset();
        }

        private class OffsetOriginalHandler
        extends TickHandler {
            private OffsetOriginalHandler() {
            }

            @Override
            int tick() {
                return DeviatedNote.this.offsetOriginal();
            }
        }

        private class OffsetHandler
        extends TickHandler {
            private OffsetHandler() {
            }

            @Override
            int tick() {
                return DeviatedNote.this.offset();
            }
        }

        private class OnsetOriginalHandler
        extends TickHandler {
            private OnsetOriginalHandler() {
            }

            @Override
            int tick() {
                return DeviatedNote.this.onsetOriginal();
            }
        }

        private class OnsetHandler
        extends TickHandler {
            private OnsetHandler() {
            }

            @Override
            int tick() {
                return DeviatedNote.this.onset();
            }
        }

        private abstract class TickHandler {
            private TickHandler() {
            }

            abstract int tick();
        }
    }
}

