/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor.controller;

import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.crestmuse.cmx.gui.deveditor.controller.ChangeAttackInMSec;
import jp.crestmuse.cmx.gui.deveditor.controller.ChangeDeviation;
import jp.crestmuse.cmx.gui.deveditor.controller.ChangeReleaseInMSec;
import jp.crestmuse.cmx.gui.deveditor.controller.DeviatedNoteControler;
import jp.crestmuse.cmx.gui.deveditor.model.Const;
import jp.crestmuse.cmx.gui.deveditor.view.MainFrame;
import jp.crestmuse.cmx.gui.deveditor.view.PianoRollPanel;

public class PrintableDeviatedNoteMoveController
implements MouseListener,
MouseMotionListener {
    private PianoRollPanel pianoRollPanel;
    private NoteMoveHandle holdNote;
    private DeviatedNoteControler deviatedNoteController;

    public PrintableDeviatedNoteMoveController(PianoRollPanel pianoRollPanel, DeviatedNoteControler deviatedNoteControler) {
        this.pianoRollPanel = pianoRollPanel;
        this.deviatedNoteController = deviatedNoteControler;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && !this.pianoRollPanel.existHoverNote() && this.holdNote == null) {
            if (Const.SHOW_AS_TICK_TIME) {
                MainFrame.getInstance().setPlayPosition(this.pianoRollPanel.getDeviatedPerformance().getSequence().getTickLength() * (long)mouseEvent.getX() / (long)this.pianoRollPanel.getPreferredSize().width);
            } else {
                MainFrame.getInstance().setPlayPosition(this.pianoRollPanel.getDeviatedPerformance().getSequence().getMicrosecondLength() * (long)mouseEvent.getX() / (long)this.pianoRollPanel.getPreferredSize().width);
            }
        } else if (mouseEvent.getButton() == 3 && this.pianoRollPanel.existHoverNote()) {
            this.pianoRollPanel.releaseHoverNote();
            this.pianoRollPanel.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        PianoRollPanel.PrintableDeviatedNote printableDeviatedNote = this.pianoRollPanel.getSelectedNote();
        if (printableDeviatedNote != null) {
            if (printableDeviatedNote.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) {
                this.holdNote = mouseEvent.getX() > printableDeviatedNote.getX() + printableDeviatedNote.getWidth() / 2 ? new OffsetMoveHandle(printableDeviatedNote.getX(), printableDeviatedNote.getX(), printableDeviatedNote.getWidth()) : new OnsetMoveHandle(printableDeviatedNote.getX() + printableDeviatedNote.getWidth(), printableDeviatedNote.getX(), printableDeviatedNote.getWidth());
                try {
                    Point point = MouseInfo.getPointerInfo().getLocation();
                    Robot robot = new Robot();
                    robot.mouseMove(point.x + this.holdNote.press(mouseEvent.getX()), point.y);
                }
                catch (AWTException aWTException) {
                    aWTException.printStackTrace();
                }
                return;
            }
            this.holdNote = null;
        }
        for (PianoRollPanel.PrintableDeviatedNote printableDeviatedNote2 : this.pianoRollPanel.getDeviatedNotes()) {
            if (!printableDeviatedNote2.show() || !printableDeviatedNote2.isMouseOver(mouseEvent.getX(), mouseEvent.getY())) continue;
            this.deviatedNoteController.select(printableDeviatedNote2.getDeviatedNote());
            break;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.holdNote != null) {
            this.holdNote.release();
            this.holdNote = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.holdNote != null) {
            this.holdNote.drag(mouseEvent.getX());
            this.pianoRollPanel.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.holdNote != null) {
            return;
        }
        this.pianoRollPanel.releaseHoverNote();
        for (PianoRollPanel.PrintableDeviatedNote printableDeviatedNote : this.pianoRollPanel.getDeviatedNotes()) {
            if (!printableDeviatedNote.isMouseOver(mouseEvent.getX(), mouseEvent.getY()) || !printableDeviatedNote.show()) continue;
            this.pianoRollPanel.setHoverNote(printableDeviatedNote);
            if (printableDeviatedNote.isMouseOnRight(mouseEvent.getX(), mouseEvent.getY())) {
                this.pianoRollPanel.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            this.pianoRollPanel.setCursor(Cursor.getPredefinedCursor(10));
            break;
        }
        if (this.pianoRollPanel.getHoverNote() == null) {
            this.pianoRollPanel.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.pianoRollPanel.repaint();
    }

    private class OffsetMoveHandle
    extends NoteMoveHandle {
        OffsetMoveHandle(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        int press(int n) {
            return this.prevX + this.prevWidth - n;
        }

        @Override
        void drag(int n) {
            PianoRollPanel.PrintableDeviatedNote printableDeviatedNote = PrintableDeviatedNoteMoveController.this.pianoRollPanel.getSelectedNote();
            printableDeviatedNote.setWidth(Math.max(n - printableDeviatedNote.getX(), 1));
        }

        @Override
        void release() {
            PianoRollPanel.PrintableDeviatedNote printableDeviatedNote = PrintableDeviatedNoteMoveController.this.pianoRollPanel.getSelectedNote();
            if (Const.SHOW_AS_TICK_TIME) {
                ChangeDeviation changeDeviation = new ChangeDeviation(printableDeviatedNote.getDeviatedNote(), 0.0, (double)(printableDeviatedNote.getWidth() - this.prevWidth) / (double)PianoRollPanel.WIDTH_PER_BEAT);
                PrintableDeviatedNoteMoveController.this.deviatedNoteController.update(changeDeviation);
            } else {
                int n = (int)(PrintableDeviatedNoteMoveController.this.pianoRollPanel.getDeviatedPerformance().getSequence().getMicrosecondLength() / 1000L);
                int n2 = ((PrintableDeviatedNoteMoveController)PrintableDeviatedNoteMoveController.this).pianoRollPanel.getPreferredSize().width;
                PrintableDeviatedNoteMoveController.this.deviatedNoteController.update(new ChangeReleaseInMSec(printableDeviatedNote.getDeviatedNote(), (printableDeviatedNote.getX() + printableDeviatedNote.getWidth()) * n / n2));
            }
        }
    }

    private class OnsetMoveHandle
    extends NoteMoveHandle {
        private OnsetMoveHandle(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        @Override
        int press(int n) {
            return this.prevX - n;
        }

        @Override
        void drag(int n) {
            PianoRollPanel.PrintableDeviatedNote printableDeviatedNote = PrintableDeviatedNoteMoveController.this.pianoRollPanel.getSelectedNote();
            printableDeviatedNote.setX(Math.min(n, this.limit - 1));
            printableDeviatedNote.setWidth(this.limit - printableDeviatedNote.getX());
        }

        @Override
        void release() {
            PianoRollPanel.PrintableDeviatedNote printableDeviatedNote = PrintableDeviatedNoteMoveController.this.pianoRollPanel.getSelectedNote();
            if (Const.SHOW_AS_TICK_TIME) {
                ChangeDeviation changeDeviation = new ChangeDeviation(printableDeviatedNote.getDeviatedNote(), (double)(printableDeviatedNote.getX() - this.prevX) / (double)PianoRollPanel.WIDTH_PER_BEAT, 0.0);
                PrintableDeviatedNoteMoveController.this.deviatedNoteController.update(changeDeviation);
            } else {
                int n = (int)(PrintableDeviatedNoteMoveController.this.pianoRollPanel.getDeviatedPerformance().getSequence().getMicrosecondLength() / 1000L);
                int n2 = ((PrintableDeviatedNoteMoveController)PrintableDeviatedNoteMoveController.this).pianoRollPanel.getPreferredSize().width;
                PrintableDeviatedNoteMoveController.this.deviatedNoteController.update(new ChangeAttackInMSec(printableDeviatedNote.getDeviatedNote(), printableDeviatedNote.getX() * n / n2));
            }
        }
    }

    private abstract class NoteMoveHandle {
        int limit;
        int prevX;
        int prevWidth;

        private NoteMoveHandle(int n, int n2, int n3) {
            this.limit = n;
            this.prevX = n2;
            this.prevWidth = n3;
        }

        abstract int press(int var1);

        abstract void drag(int var1);

        abstract void release();
    }
}

