/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.dppatheditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.gui.deveditor.model.DeviatedPerformance;
import jp.crestmuse.cmx.gui.deveditor.view.DeviatedPerformancePlayer;
import jp.crestmuse.cmx.gui.dppatheditor.FrameController;
import jp.crestmuse.cmx.gui.dppatheditor.KeyBoardPanel;
import jp.crestmuse.cmx.gui.dppatheditor.TempoCurve;
import jp.crestmuse.cmx.misc.PerformanceMatcher3;

public class MainFrame
extends JFrame {
    public static final int ROW_HEADER_WIDTH = 32;
    private static Dimension VIEWPORT_DIM = new Dimension(720, 320);
    public static final float WIDTH_PER_TICK = 0.075f;
    public static final int HEIGHT_PER_NOTE = 16;
    private LinkedList<PfmNote> pfmNotes;
    private LinkedList<ScoreNote> scoreNotes;
    private PfmNote selectedPfmNote;
    private ScoreNote selectedScoreNote;
    private PerformanceMatcher3 pm3;
    private int[] score2pfm;
    private DeviatedPerformancePlayer player;
    private HashMap<ScoreNote, Integer> extranote2index;
    private PfmPanel pfmPanel;
    private JScrollPane north;
    private TempoCurve tempo;
    private final DeviatedPerformance deviatedPerformance;

    public MainFrame(DeviatedPerformance deviatedPerformance, PerformanceMatcher3 performanceMatcher3, int[] nArray, DeviatedPerformancePlayer deviatedPerformancePlayer, final FrameController frameController) {
        Object object2;
        this.deviatedPerformance = deviatedPerformance;
        this.pm3 = performanceMatcher3;
        this.score2pfm = nArray;
        this.player = deviatedPerformancePlayer;
        this.pfmNotes = new LinkedList();
        this.scoreNotes = new LinkedList();
        this.extranote2index = new HashMap();
        int n = 0;
        for (Object object2 : deviatedPerformance.getDeviatedNotes()) {
            this.pfmNotes.add(new PfmNote((DeviatedPerformance.DeviatedNote)object2));
            if (!object2.isExtraNote()) {
                this.scoreNotes.add(new ScoreNote((DeviatedPerformance.DeviatedNote)object2));
                this.pfmNotes.getLast().pair = this.scoreNotes.getLast();
                this.scoreNotes.getLast().pair = this.pfmNotes.getLast();
            }
            n = Math.max(n, object2.offset());
        }
        this.pfmPanel = new PfmPanel();
        ScorePanel scorePanel = new ScorePanel();
        object2 = new Dimension(this.tick2position(n), 2048);
        this.pfmPanel.setPreferredSize((Dimension)object2);
        scorePanel.setPreferredSize((Dimension)object2);
        this.north = new JScrollPane();
        this.north.getViewport().setScrollMode(0);
        this.north.getViewport().setPreferredSize(VIEWPORT_DIM);
        this.north.setViewportView(this.pfmPanel);
        this.north.setRowHeaderView(new KeyBoardPanel());
        class ColumnHeader
        extends JPanel {
            ColumnHeader() {
                this.setPreferredSize(new Dimension(((MainFrame)MainFrame.this).pfmPanel.getPreferredSize().width, 16));
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                int n = 0;
                int n2 = 1;
                while (n < this.getWidth()) {
                    try {
                        n = (int)((float)MainFrame.this.deviatedPerformance.getMusicXML().getCumulativeTicks(n2, DeviatedPerformance.TICKS_PER_BEAT) * 0.075f);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        break;
                    }
                    graphics.drawString(String.valueOf(n2), n, 10);
                    ++n2;
                }
            }
        }
        this.north.setColumnHeaderView(new ColumnHeader());
        final JScrollPane jScrollPane = new JScrollPane(22, 31);
        jScrollPane.getViewport().setScrollMode(0);
        jScrollPane.getViewport().setPreferredSize(VIEWPORT_DIM);
        jScrollPane.setViewportView(scorePanel);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(32, 1));
        jScrollPane.setRowHeaderView(jPanel);
        this.tempo = new TempoCurve(deviatedPerformance, object2.width);
        final JScrollPane jScrollPane2 = new JScrollPane(22, 31);
        jScrollPane2.getViewport().setScrollMode(0);
        jScrollPane2.getViewport().setPreferredSize(new Dimension(MainFrame.VIEWPORT_DIM.width, TempoCurve.PANEL_HEIGHT));
        jScrollPane2.setViewportView(this.tempo);
        jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(32, 1));
        jScrollPane2.setRowHeaderView(jPanel);
        this.north.getViewport().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jScrollPane.getViewport().setViewPosition(MainFrame.this.north.getViewport().getViewPosition());
                int n = ((MainFrame)MainFrame.this).north.getViewport().getViewPosition().x;
                jScrollPane2.getViewport().setViewPosition(new Point(n, 0));
            }
        });
        this.north.getViewport().setViewPosition(new Point(0, object2.height / 2));
        JPanel jPanel2 = new JPanel();
        final JButton jButton = new JButton("play");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.player.isNowPlaying()) {
                    MainFrame.this.player.stop();
                    jButton.setText("play");
                } else {
                    MainFrame.this.player.play();
                    jButton.setText("stop");
                    Thread thread = new Thread(new Repainter());
                    thread.start();
                }
            }
        });
        JButton jButton2 = new JButton("ReGenerate");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    frameController.reGenerateDeviation();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        JButton jButton3 = new JButton("save");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    frameController.save();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(this.north);
        jPanel3.add(jScrollPane);
        jPanel3.add(jScrollPane2);
        jPanel3.add(jPanel2);
        this.add(jPanel3);
        this.pack();
    }

    public int[] getScore2pfm() {
        return this.score2pfm;
    }

    private int tick2position(int n) {
        return (int)((float)n * 0.075f);
    }

    private int position2tick(int n) {
        return (int)(this.player.getCurrentSequence().getTickLength() * (long)n / (long)this.pfmPanel.getWidth());
    }

    private int notenum2position(int n) {
        return (127 - n) * 16;
    }

    private class Repainter
    implements Runnable {
        private Repainter() {
        }

        public void run() {
            while (MainFrame.this.player.isNowPlaying()) {
                MainFrame.this.pfmPanel.repaint();
                int n = MainFrame.this.tick2position((int)MainFrame.this.player.getTickPosition()) - MainFrame.this.north.getWidth() / 2;
                n = Math.max(n, 0);
                Point point = MainFrame.this.north.getViewport().getViewPosition();
                point.x = n;
                MainFrame.this.north.getViewport().setViewPosition(point);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    private class PfmNote
    extends ScoreNote {
        boolean enable;
        int voice;
        Color roundColor;

        PfmNote(DeviatedPerformance.DeviatedNote deviatedNote) {
            super(deviatedNote);
            this.x = MainFrame.this.tick2position(deviatedNote.onset()) + 1;
            this.width = MainFrame.this.tick2position(deviatedNote.offset()) - this.x - 2;
            if (this.deviatedNote.isExtraNote()) {
                this.voice = 1;
                this.color = new Color(255, 255, 0, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.YELLOW;
            } else if (this.deviatedNote.getNote().voice() == 1) {
                this.voice = 2;
                this.color = new Color(255, 0, 0, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.RED;
            } else if (this.deviatedNote.getNote().voice() == 2) {
                this.voice = 4;
                this.color = new Color(255, 127, 0, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.ORANGE;
            } else if (this.deviatedNote.getNote().voice() == 3) {
                this.voice = 8;
                this.color = new Color(255, 175, 175, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.PINK;
            } else if (this.deviatedNote.getNote().voice() == 4) {
                this.voice = 16;
                this.color = new Color(255, 0, 255, this.deviatedNote.velocity() * 2);
                this.roundColor = Color.MAGENTA;
            } else {
                this.voice = 32;
                this.color = new Color(255, 0, 127, this.deviatedNote.velocity() * 2);
                this.roundColor = new Color(255, 0, 127);
            }
        }

        void draw(Graphics graphics) {
            graphics.setColor(this.color);
            graphics.fillRect(this.x - 1, this.y - 1, this.width + 2, this.height + 2);
            graphics.setColor(this.roundColor);
            graphics.drawRect(this.x, this.y, this.width, this.height);
            if (this.deviatedNote.getIsMissNote()) {
                graphics.setColor(Color.BLACK);
                graphics.drawString("miss", this.x, this.y);
            }
        }

        void drawAsSelected(Graphics graphics) {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(this.x, this.y, this.width, this.height);
            if (this.deviatedNote.getIsMissNote()) {
                graphics.setColor(Color.RED);
                graphics.drawString("miss", this.x, this.y);
            }
        }

        void edited() {
            this.color = Color.BLUE;
            this.roundColor = Color.BLUE;
        }

        boolean isClicked(int n, int n2) {
            if (this.deviatedNote.getIsMissNote()) {
                return false;
            }
            return super.isClicked(n, n2);
        }
    }

    private class ScoreNote {
        ScoreNote pair;
        DeviatedPerformance.DeviatedNote deviatedNote;
        int x;
        int y;
        int width;
        int height;
        Color color;

        ScoreNote(DeviatedPerformance.DeviatedNote deviatedNote) {
            this.deviatedNote = deviatedNote;
            this.x = MainFrame.this.tick2position(deviatedNote.onsetOriginal()) + 1;
            this.y = MainFrame.this.notenum2position(deviatedNote.notenum()) + 1;
            this.width = MainFrame.this.tick2position(deviatedNote.offsetOriginal()) - this.x - 2;
            this.height = MainFrame.this.notenum2position(deviatedNote.notenum() - 1) - this.y - 2;
            this.color = Color.BLACK;
        }

        void draw(Graphics graphics) {
            graphics.setColor(this.color);
            graphics.drawRect(this.x, this.y, this.width, this.height);
        }

        void drawAsSelected(Graphics graphics) {
            graphics.setColor(this.color);
            graphics.fillRect(this.x, this.y, this.width, this.height);
        }

        boolean isClicked(int n, int n2) {
            return n >= this.x && n <= this.x + this.width && n2 >= this.y && n2 <= this.y + this.height;
        }
    }

    private class ScorePanel
    extends JPanel {
        ScorePanel() {
            this.addMouseListener(new ScorePanelMouseAdapter());
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = 0;
            int n2 = 1;
            while (n < this.getWidth()) {
                try {
                    n = (int)((float)MainFrame.this.deviatedPerformance.getMusicXML().getCumulativeTicks(n2, DeviatedPerformance.TICKS_PER_BEAT) * 0.075f);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
                graphics.drawLine(n, 0, n, this.getHeight());
                ++n2;
            }
            for (ScoreNote scoreNote : MainFrame.this.scoreNotes) {
                scoreNote.draw(graphics);
            }
            if (MainFrame.this.selectedScoreNote != null) {
                MainFrame.this.selectedScoreNote.drawAsSelected(graphics);
            }
        }

        class ScorePanelMouseAdapter
        extends MouseAdapter {
            ScorePanelMouseAdapter() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                for (ScoreNote scoreNote : MainFrame.this.scoreNotes) {
                    if (!scoreNote.isClicked(mouseEvent.getX(), mouseEvent.getY())) continue;
                    int n = (Integer)MainFrame.this.pm3.getMusicxmlwrappernote2Index().get(scoreNote.deviatedNote.getNote());
                    if (scoreNote == MainFrame.this.selectedScoreNote) {
                        MainFrame.this.extranote2index.put(MainFrame.this.selectedPfmNote, MainFrame.this.score2pfm[n]);
                        ((MainFrame)MainFrame.this).score2pfm[n] = -1;
                        scoreNote.pair = null;
                        ((MainFrame)MainFrame.this).selectedPfmNote.pair = null;
                        MainFrame.this.selectedScoreNote = null;
                        MainFrame.this.selectedPfmNote.edited();
                        MainFrame.this.repaint();
                        return;
                    }
                    if (scoreNote.deviatedNote.notenum() != ((MainFrame)MainFrame.this).selectedPfmNote.deviatedNote.notenum()) {
                        JOptionPane.showMessageDialog(MainFrame.this, "different note number");
                        return;
                    }
                    if (((MainFrame)MainFrame.this).selectedPfmNote.pair == null) {
                        int n2 = -1;
                        if (MainFrame.this.extranote2index.containsKey(MainFrame.this.selectedPfmNote)) {
                            n2 = (Integer)MainFrame.this.extranote2index.get(MainFrame.this.selectedPfmNote);
                        } else {
                            int n3 = Integer.MAX_VALUE;
                            for (Map.Entry entry : MainFrame.this.pm3.getExtraNoteMap().entrySet()) {
                                int n4;
                                if (((SCCXMLWrapper.Note)entry.getKey()).notenum() != ((MainFrame)MainFrame.this).selectedPfmNote.deviatedNote.notenum() || (n4 = Math.abs(((SCCXMLWrapper.Note)entry.getKey()).onsetInMilliSec() - ((MainFrame)MainFrame.this).selectedPfmNote.deviatedNote.onsetInMSec())) >= n3) continue;
                                n2 = (Integer)entry.getValue();
                                n3 = n4;
                            }
                        }
                        if (n2 != -1) {
                            if (scoreNote.pair != null) {
                                MainFrame.this.extranote2index.put(scoreNote.pair, MainFrame.this.score2pfm[n]);
                                scoreNote.pair.pair = null;
                            }
                            ((MainFrame)MainFrame.this).score2pfm[n] = n2;
                            ((MainFrame)MainFrame.this).selectedPfmNote.pair = scoreNote;
                            scoreNote.pair = MainFrame.this.selectedPfmNote;
                            MainFrame.this.selectedScoreNote = scoreNote;
                            MainFrame.this.selectedPfmNote.edited();
                            MainFrame.this.repaint();
                        }
                        return;
                    }
                    int n5 = (Integer)MainFrame.this.pm3.getMusicxmlwrappernote2Index().get(((MainFrame)MainFrame.this).selectedPfmNote.deviatedNote.getNote());
                    if (scoreNote.pair != null) {
                        MainFrame.this.extranote2index.put(scoreNote.pair, MainFrame.this.score2pfm[n]);
                        scoreNote.pair.pair = null;
                    }
                    ((MainFrame)MainFrame.this).score2pfm[n] = MainFrame.this.score2pfm[n5];
                    ((MainFrame)MainFrame.this).score2pfm[n5] = -1;
                    scoreNote.pair = MainFrame.this.selectedPfmNote;
                    ((MainFrame)MainFrame.this).selectedPfmNote.pair.pair = null;
                    ((MainFrame)MainFrame.this).selectedPfmNote.pair = scoreNote;
                    MainFrame.this.selectedScoreNote = scoreNote;
                    MainFrame.this.selectedPfmNote.edited();
                    MainFrame.this.repaint();
                    break;
                }
            }
        }
    }

    private class PfmPanel
    extends JPanel {
        PfmPanel() {
            this.addMouseListener(new PfmPanelMouseAdapter());
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            int n = 0;
            int n2 = 1;
            while (n < this.getWidth()) {
                try {
                    n = (int)((float)MainFrame.this.deviatedPerformance.getMusicXML().getCumulativeTicks(n2, DeviatedPerformance.TICKS_PER_BEAT) * 0.075f);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
                graphics.drawLine(n, 0, n, this.getHeight());
                ++n2;
            }
            for (PfmNote pfmNote : MainFrame.this.pfmNotes) {
                pfmNote.draw(graphics);
            }
            if (MainFrame.this.selectedPfmNote != null) {
                MainFrame.this.selectedPfmNote.drawAsSelected(graphics);
            }
            graphics.setColor(Color.GREEN);
            int n3 = MainFrame.this.tick2position((int)MainFrame.this.player.getTickPosition());
            graphics.drawLine(n3, 0, n3, this.getHeight());
        }

        private class PfmPanelMouseAdapter
        extends MouseAdapter {
            private PfmPanelMouseAdapter() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                for (PfmNote pfmNote : MainFrame.this.pfmNotes) {
                    if (!pfmNote.isClicked(mouseEvent.getX(), mouseEvent.getY())) continue;
                    MainFrame.this.selectedPfmNote = pfmNote;
                    MainFrame.this.selectedScoreNote = pfmNote.pair;
                    MainFrame.this.repaint();
                    return;
                }
                MainFrame.this.selectedPfmNote = null;
                MainFrame.this.selectedScoreNote = null;
                if (mouseEvent.getClickCount() >= 2) {
                    MainFrame.this.player.setTickPosition((long)MainFrame.this.position2tick(mouseEvent.getX()));
                }
                MainFrame.this.repaint();
            }
        }
    }
}

