#!/bin/zsh

release=`basename $PWD`
jarfile=BayesianBand

mkdir classes
javac -d classes -sourcepath src src/**/*.java
( cd classes ; jar cvfm ../${jarfile}.jar ../META-INF/MANIFEST.MF * )
rm -r classes

if [ -e doc ] ; then
  rm -r doc/*
else
  mkdir doc
fi
javadoc -d doc -protected -version -author src/**/*.java

( cd .. ; rm ${release}.zip ; zip -r ${release}.zip $release -x ${release}/**/.svn/**/{*,.*} ${release}/**/*~ )

