/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.sound;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jp.crestmuse.cmx.amusaj.sp.MidiInputModule;
import jp.crestmuse.cmx.amusaj.sp.MidiOutputModule;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualKeyboard
extends JFrame
implements MidiDevice {
    public static int VELOCITY = 127;
    public static int BASE_NOTE_NUM = 60;
    private boolean isOpen = false;
    private Transmitter transmitter = new VirtualKeyboardTransmitter();

    @Override
    public void close() {
        this.isOpen = false;
        this.transmitter.close();
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return null;
    }

    @Override
    public int getMaxReceivers() {
        return 0;
    }

    @Override
    public int getMaxTransmitters() {
        return 1;
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public Receiver getReceiver() throws MidiUnavailableException {
        return null;
    }

    @Override
    public List<Receiver> getReceivers() {
        return null;
    }

    @Override
    public Transmitter getTransmitter() throws MidiUnavailableException {
        return this.transmitter;
    }

    @Override
    public List<Transmitter> getTransmitters() {
        LinkedList<Transmitter> linkedList = new LinkedList<Transmitter>();
        linkedList.add(this.transmitter);
        return linkedList;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void open() throws MidiUnavailableException {
        this.isOpen = true;
    }

    public static void main(String[] stringArray) {
        try {
            VirtualKeyboard virtualKeyboard = new VirtualKeyboard();
            MidiInputModule midiInputModule = new MidiInputModule(virtualKeyboard);
            MidiOutputModule midiOutputModule = new MidiOutputModule(MidiSystem.getReceiver());
            SPExecutor sPExecutor = new SPExecutor(null, 1);
            sPExecutor.addSPModule(midiInputModule);
            sPExecutor.addSPModule(midiOutputModule);
            sPExecutor.connect(midiInputModule, 0, midiOutputModule, 0);
            sPExecutor.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class VirtualKeyboardTransmitter
    implements Transmitter {
        private Receiver receiver = null;
        private HashMap<Character, Integer> key2num = new HashMap();

        public VirtualKeyboardTransmitter() {
            this.key2num.put(Character.valueOf('z'), BASE_NOTE_NUM);
            this.key2num.put(Character.valueOf('s'), BASE_NOTE_NUM + 1);
            this.key2num.put(Character.valueOf('x'), BASE_NOTE_NUM + 2);
            this.key2num.put(Character.valueOf('d'), BASE_NOTE_NUM + 3);
            this.key2num.put(Character.valueOf('c'), BASE_NOTE_NUM + 4);
            this.key2num.put(Character.valueOf('v'), BASE_NOTE_NUM + 5);
            this.key2num.put(Character.valueOf('g'), BASE_NOTE_NUM + 6);
            this.key2num.put(Character.valueOf('b'), BASE_NOTE_NUM + 7);
            this.key2num.put(Character.valueOf('h'), BASE_NOTE_NUM + 8);
            this.key2num.put(Character.valueOf('n'), BASE_NOTE_NUM + 9);
            this.key2num.put(Character.valueOf('j'), BASE_NOTE_NUM + 10);
            this.key2num.put(Character.valueOf('m'), BASE_NOTE_NUM + 11);
            this.key2num.put(Character.valueOf('q'), BASE_NOTE_NUM + 12);
            this.key2num.put(Character.valueOf('2'), BASE_NOTE_NUM + 13);
            this.key2num.put(Character.valueOf('w'), BASE_NOTE_NUM + 14);
            this.key2num.put(Character.valueOf('3'), BASE_NOTE_NUM + 15);
            this.key2num.put(Character.valueOf('e'), BASE_NOTE_NUM + 16);
            this.key2num.put(Character.valueOf('r'), BASE_NOTE_NUM + 17);
            this.key2num.put(Character.valueOf('5'), BASE_NOTE_NUM + 18);
            this.key2num.put(Character.valueOf('t'), BASE_NOTE_NUM + 19);
            this.key2num.put(Character.valueOf('6'), BASE_NOTE_NUM + 20);
            this.key2num.put(Character.valueOf('y'), BASE_NOTE_NUM + 21);
            this.key2num.put(Character.valueOf('7'), BASE_NOTE_NUM + 22);
            this.key2num.put(Character.valueOf('u'), BASE_NOTE_NUM + 23);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VirtualKeyboard.this.addKeyListener(new KeyListener(){
                        private boolean[] pressed = new boolean[256];

                        public void keyPressed(KeyEvent keyEvent) {
                            if (VirtualKeyboardTransmitter.this.receiver == null || !VirtualKeyboardTransmitter.this.key2num.containsKey(Character.valueOf(keyEvent.getKeyChar()))) {
                                return;
                            }
                            if (this.pressed[keyEvent.getKeyChar()]) {
                                return;
                            }
                            try {
                                ShortMessage shortMessage = new ShortMessage();
                                shortMessage.setMessage(144, (Integer)VirtualKeyboardTransmitter.this.key2num.get(Character.valueOf(keyEvent.getKeyChar())), VELOCITY);
                                VirtualKeyboardTransmitter.this.receiver.send(shortMessage, -1L);
                            }
                            catch (InvalidMidiDataException invalidMidiDataException) {
                                invalidMidiDataException.printStackTrace();
                            }
                            this.pressed[keyEvent.getKeyChar()] = true;
                        }

                        public void keyReleased(KeyEvent keyEvent) {
                            if (VirtualKeyboardTransmitter.this.receiver == null || !VirtualKeyboardTransmitter.this.key2num.containsKey(Character.valueOf(keyEvent.getKeyChar()))) {
                                return;
                            }
                            try {
                                ShortMessage shortMessage = new ShortMessage();
                                shortMessage.setMessage(128, (Integer)VirtualKeyboardTransmitter.this.key2num.get(Character.valueOf(keyEvent.getKeyChar())), VELOCITY);
                                VirtualKeyboardTransmitter.this.receiver.send(shortMessage, -1L);
                            }
                            catch (InvalidMidiDataException invalidMidiDataException) {
                                invalidMidiDataException.printStackTrace();
                            }
                            this.pressed[keyEvent.getKeyChar()] = false;
                        }

                        public void keyTyped(KeyEvent keyEvent) {
                        }
                    });
                    VirtualKeyboard.this.setVisible(true);
                }
            });
        }

        public void close() {
            VirtualKeyboard.this.setVisible(false);
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }
    }
}

