/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.math;

import jp.crestmuse.cmx.math.BooleanArray;
import jp.crestmuse.cmx.math.BooleanArrayFactory;
import jp.crestmuse.cmx.math.ComplexArray;
import jp.crestmuse.cmx.math.ComplexArrayFactory;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import org.apache.commons.math.stat.descriptive.rank.Median;

public class Operations {
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private static final BooleanArrayFactory bfactory = BooleanArrayFactory.getFactory();
    private static final ComplexArrayFactory cfactory = ComplexArrayFactory.getFactory();
    private static final Median median = new Median();

    private Operations() {
    }

    public static DoubleArray subarray(DoubleArray doubleArray, int n, int n2) {
        int n3 = n2 - n;
        DoubleArray doubleArray2 = factory.createArray(n3);
        for (int i = 0; i < n3; ++i) {
            doubleArray2.set(i, doubleArray.get(n + i));
        }
        return doubleArray2;
    }

    public static ComplexArray subarray(ComplexArray complexArray, int n, int n2) {
        int n3 = n2 - n;
        ComplexArray complexArray2 = cfactory.createArray(n3);
        for (int i = 0; i < n3; ++i) {
            complexArray2.set(i, complexArray.getReal(n + i), complexArray.getImag(n + i));
        }
        return complexArray2;
    }

    public static DoubleArray add(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        DoubleArray doubleArray3 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray3.set(i, doubleArray.get(i) + doubleArray2.get(i));
        }
        return doubleArray3;
    }

    public static void addX(DoubleArray doubleArray, DoubleArray doubleArray2) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) + doubleArray2.get(i));
        }
    }

    public static DoubleArray add(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, doubleArray.get(i) + d);
        }
        return doubleArray2;
    }

    public static void addX(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) + d);
        }
    }

    public static void addX(DoubleArray doubleArray, DoubleArray doubleArray2, int n) {
        int n2 = doubleArray2.length();
        for (int i = 0; i < n2; ++i) {
            doubleArray.set(i + n, doubleArray.get(i + n) + doubleArray2.get(i));
        }
    }

    public static DoubleArray div(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, doubleArray.get(i) / d);
        }
        return doubleArray2;
    }

    public static void divX(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) / d);
        }
    }

    public static double sum(DoubleArray doubleArray) {
        double d = 0.0;
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            d += doubleArray.get(i);
        }
        return d;
    }

    public static MinResult min(DoubleArray doubleArray) {
        MinResult minResult = new MinResult();
        minResult.min = Double.POSITIVE_INFINITY;
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = doubleArray.get(i);
            if (!(d < minResult.min)) continue;
            minResult.min = d2;
            minResult.argmin = i;
        }
        return minResult;
    }

    public static MaxResult max(DoubleArray doubleArray) {
        MaxResult maxResult = new MaxResult();
        maxResult.max = Double.NEGATIVE_INFINITY;
        maxResult.max2nd = Double.NEGATIVE_INFINITY;
        maxResult.max3rd = Double.NEGATIVE_INFINITY;
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = doubleArray.get(i);
            if (d > maxResult.max) {
                maxResult.max3rd = maxResult.max2nd;
                maxResult.argmax3rd = maxResult.argmax3rd;
                maxResult.max2nd = maxResult.max;
                maxResult.argmax2nd = maxResult.argmax;
                maxResult.max = d2;
                maxResult.argmax = i;
                continue;
            }
            if (d2 > maxResult.max2nd) {
                maxResult.max3rd = maxResult.max2nd;
                maxResult.argmax3rd = maxResult.argmax3rd;
                maxResult.max2nd = d2;
                maxResult.argmax2nd = i;
                continue;
            }
            if (!(d2 > maxResult.max3rd)) continue;
            maxResult.max3rd = d2;
            maxResult.argmax3rd = i;
        }
        return maxResult;
    }

    public static double median(DoubleArray doubleArray) {
        return median.evaluate(doubleArray.toArray());
    }

    public static boolean containsNaNInf(DoubleArray doubleArray) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            if (!Double.isNaN(doubleArray.get(i)) && !Double.isInfinite(doubleArray.get(i))) continue;
            return true;
        }
        return false;
    }

    public static DoubleArray makeArithmeticSeries(double d, double d2, int n) {
        DoubleArray doubleArray = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, d + (double)i * d2);
        }
        return doubleArray;
    }

    public static DoubleArray makeArithmeticSeries(double d, int n) {
        return Operations.makeArithmeticSeries(d, 1.0, n);
    }

    public static DoubleArray makeArithmeticSeries(int n) {
        return Operations.makeArithmeticSeries(1.0, 1.0, n);
    }

    public static DoubleArray nn2cent(DoubleArray doubleArray) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, doubleArray.get(i) * 100.0 - 1200.0);
        }
        return doubleArray2;
    }

    public static void nn2centX(DoubleArray doubleArray) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, doubleArray.get(i) * 100.0 - 1200.0);
        }
    }

    public static void Hz2centX(DoubleArray doubleArray) {
        int n = doubleArray.length();
        for (int i = 0; i < n; ++i) {
            doubleArray.set(i, 1200.0 * Operations.log2(doubleArray.get(i) / 440.0 / 0.037162722343835));
        }
    }

    public static DoubleArray Hz2cent(DoubleArray doubleArray) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            doubleArray2.set(i, 1200.0 * Operations.log2(doubleArray.get(i) / 440.0 / 0.037162722343835));
        }
        return doubleArray2;
    }

    private static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static BooleanArray lessThan(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        BooleanArray booleanArray = bfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            booleanArray.set(i, doubleArray.get(i) < d);
        }
        return booleanArray;
    }

    public static BooleanArray greaterThan(DoubleArray doubleArray, double d) {
        int n = doubleArray.length();
        BooleanArray booleanArray = bfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            booleanArray.set(i, doubleArray.get(i) > d);
        }
        return booleanArray;
    }

    public static BooleanArray or(BooleanArray booleanArray, BooleanArray booleanArray2) {
        int n = booleanArray.length();
        BooleanArray booleanArray3 = bfactory.createArray(n);
        for (int i = 0; i < n; ++i) {
            booleanArray3.set(i, booleanArray.get(i) || booleanArray2.get(i));
        }
        return booleanArray3;
    }

    public static DoubleArray removeMask(DoubleArray doubleArray, BooleanArray booleanArray) {
        int n = doubleArray.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (booleanArray.get(i)) continue;
            ++n2;
        }
        DoubleArray doubleArray2 = factory.createArray(n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (booleanArray.get(i)) continue;
            doubleArray2.set(n3, doubleArray.get(i));
            ++n3;
        }
        return doubleArray2;
    }

    public static DoubleArray mask(DoubleArray doubleArray, BooleanArray booleanArray, double d) {
        int n = doubleArray.length();
        DoubleArray doubleArray2 = factory.createArray(n);
        for (int i = 0; i < n; ++i) {
            if (booleanArray.get(i)) {
                doubleArray2.set(i, d);
                continue;
            }
            doubleArray2.set(i, doubleArray.get(i));
        }
        return doubleArray2;
    }

    public static final int Hz2nn(double d) {
        return 57 + (int)(12.0 * Math.log(d / 220.0) / Math.log(2.0));
    }

    public static final double nn2Hz(double d) {
        return 220.0 * Math.pow(2.0, (d - 57.0) / 12.0);
    }

    public static class MaxResult {
        public double max;
        public int argmax;
        public double max2nd;
        public int argmax2nd;
        public double max3rd;
        public int argmax3rd;
    }

    public static class MinResult {
        public double min;
        public int argmin;
    }
}

