/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;

public class NaiveVoicingCalculator
implements Calculator {
    private MusicRepresentation musicRepresentation;
    private static final int BASE_NN = 36;
    private static final int[][] basslines = new int[][]{{0, 4, 7, 0}, {2, 0, -3, 2}, {4, -1, -5, 4}, {-7, 0, 5, -7}, {-5, 7, 2, -5}, {-3, -1, 0, -3}, {-1, 0, 1, 2}};

    public NaiveVoicingCalculator(MusicRepresentation musicRepresentation) {
        this.musicRepresentation = musicRepresentation;
    }

    public MusicRepresentation.Type[] drivenBy() {
        return new MusicRepresentation.Type[]{MusicRepresentation.Type.Chord};
    }

    public void update(MusicRepresentation.MusicElement musicElement, int n) {
        MusicRepresentation.MusicElement musicElement2 = this.musicRepresentation.addVoicingHighElement(n);
        MusicRepresentation.MusicElement musicElement3 = this.musicRepresentation.addVoicingMidHighElement(n);
        MusicRepresentation.MusicElement musicElement4 = this.musicRepresentation.addVoicingMidLowElement(n);
        MusicRepresentation.MusicElement musicElement5 = this.musicRepresentation.addVoicingLowElement(n);
        int n2 = musicElement.getHighestProbIndex();
        if (n > this.musicRepresentation.getDivision() && this.musicRepresentation.getChordElement(n - this.musicRepresentation.getDivision()).getHighestProbIndex() == n2 && this.musicRepresentation.getChordElement(n - this.musicRepresentation.getDivision() * 2).getHighestProbIndex() == n2) {
            int n3 = musicElement.getRankedProbIndex(1);
            if (musicElement.getProb(n3) > 0.0) {
                n2 = n3;
            }
            this.musicRepresentation.getChordElement(n).setEvidence(n2);
        }
        int[] nArray = this.diatonicMapC(musicElement.getLabel(n2));
        musicElement2.setProb(nArray[0], musicElement.getProb(n2));
        musicElement3.setProb(nArray[1], musicElement.getProb(n2));
        musicElement4.setProb(nArray[2], musicElement.getProb(n2));
        musicElement5.setProb(nArray[3], musicElement.getProb(n2));
        MusicRepresentation.MusicElement musicElement6 = this.musicRepresentation.addBassElement(n);
        for (int i = 0; i < 4; ++i) {
            musicElement6 = this.musicRepresentation.addBassElement(n + i * 2);
            musicElement6.setEvidence(36 + basslines[n2][i]);
        }
    }

    private int[] diatonicMapC(String string) {
        int[] nArray = string.equals("C") ? new int[]{55, 57, 60, 64} : (string.equals("Dm") ? new int[]{57, 60, 62, 65} : (string.equals("Em") ? new int[]{59, 62, 64, 67} : (string.equals("F") ? new int[]{57, 60, 62, 65} : (string.equals("G") ? new int[]{55, 59, 62, 65} : (string.equals("Am") ? new int[]{55, 57, 60, 64} : new int[]{57, 59, 62, 65})))));
        return nArray;
    }
}

