/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.inference;

import java.util.HashMap;
import java.util.Map;
import jp.crestmuse.cmx.amusaj.commands.ChordConverter;
import jp.crestmuse.cmx.inference.Calculator;
import jp.crestmuse.cmx.inference.MusicRepresentation;

public class BassCalculator
implements Calculator {
    private MusicRepresentation musicRepresentation;
    private Map<String, Integer> diatonic2notenum;
    private double[] seqMap = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 0.1, 1.0, 0.1, 0.5, 0.5, 0.1, 0.1, 0.1, 0.1, 0.1, 0.5, 0.5, 0.1, 1.0, 0.1, 1.0, 1.0, 1.0, 1.0, 1.0};
    private int BASE = 36;
    private double[][] noteTable = new double[12][3];
    private ChordConverter cc = new ChordConverter();

    public BassCalculator(MusicRepresentation musicRepresentation) {
        this.musicRepresentation = musicRepresentation;
        this.diatonic2notenum = new HashMap<String, Integer>();
        this.diatonic2notenum.put("C", 0);
        this.diatonic2notenum.put("Dm", 2);
        this.diatonic2notenum.put("Em", 4);
        this.diatonic2notenum.put("F", 5);
        this.diatonic2notenum.put("G", 7);
        this.diatonic2notenum.put("Am", 9);
        this.diatonic2notenum.put("Bm(b5)", 11);
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.noteTable[i][j] = 0.5;
            }
        }
        this.noteTable[0][1] = 0.01;
        this.noteTable[4][1] = 0.01;
        this.noteTable[7][1] = 0.01;
    }

    public MusicRepresentation.Type[] drivenBy() {
        return new MusicRepresentation.Type[]{MusicRepresentation.Type.Chord};
    }

    public void update(MusicRepresentation.MusicElement musicElement, int n) {
        String string;
        String string2 = musicElement.getLabel(musicElement.getHighestProbIndex());
        try {
            MusicRepresentation.MusicElement musicElement2 = this.musicRepresentation.getChordElement(n + this.musicRepresentation.getDivision());
            if (musicElement2 == null) {
                musicElement2 = this.musicRepresentation.addChordElement(n + this.musicRepresentation.getDivision());
                musicElement2.setProb(musicElement2.indexOf(string2), 0.1);
                string = string2;
            } else {
                string = musicElement2.getLabel(musicElement2.getHighestProbIndex());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = string2;
        }
        int n2 = this.diatonic2notenum.get(string2) + this.BASE;
        MusicRepresentation.MusicElement musicElement3 = this.musicRepresentation.addBassElement(n);
        musicElement3.setProb(n2, 1.0);
        int[] nArray = this.getNearestPath(string2, string);
        for (int i = 0; i < nArray.length; ++i) {
            musicElement3 = this.musicRepresentation.addBassElement(n + (i + 1) * 2);
            musicElement3.setProb(n2 + nArray[i], 0.5);
        }
    }

    private int[] getNearestPath(String string, String string2) {
        int n;
        int n2;
        int n3;
        int n4 = 3;
        int n5 = 25;
        int[] nArray = new int[n4];
        DPElement[][] dPElementArray = new DPElement[n4][n5];
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                dPElementArray[n3][n2] = new DPElement();
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = this.diatonic2notenum.get(string) + this.BASE;
            dPElementArray[0][n3].dist = this.getNoteDist(string, 0, n2) + this.getSeqDist(n2, n2 + n3 - 12);
        }
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n5; ++n) {
                    double d;
                    if (Math.abs(n2 - n) > 12 || !(dPElementArray[n3 + 1][n].dist > (d = dPElementArray[n3][n2].dist + this.getNoteDist(string, n3 + 1, n - 12 + this.BASE) + this.getSeqDist(n - 12 + this.BASE, n2 - 12 + this.BASE)))) continue;
                    dPElementArray[n3 + 1][n].dist = d;
                    dPElementArray[n3 + 1][n].from = n2;
                }
            }
        }
        double d = Double.MAX_VALUE;
        n = 0;
        for (int i = 0; i < n5; ++i) {
            double d2;
            int n6 = this.diatonic2notenum.get(string2) + this.BASE;
            if (Math.abs(n6 - i - 12 + this.BASE) > 12 || !((d2 = dPElementArray[n4 - 1][i].dist + this.getSeqDist(i - 12 + this.BASE, n6)) < d)) continue;
            d = d2;
            n = i;
        }
        while (n4 > 0) {
            nArray[--n4] = n - 12;
            n = dPElementArray[n4][n].from;
        }
        return nArray;
    }

    private double getNoteDist(String string, int n, int n2) {
        n2 = this.cc.noteTransfer("C", n2 % 12);
        return this.noteTable[n2][n];
    }

    private double getSeqDist(int n, int n2) {
        return this.seqMap[n2 - n + 12];
    }

    private class DPElement {
        double dist = Double.MAX_VALUE;
        int from = -1;

        private DPElement() {
        }
    }
}

