/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.MidiInputModule;
import jp.crestmuse.cmx.amusaj.sp.MidiOutputModule;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.misc.QueueReader;
import jp.crestmuse.cmx.sound.SMFPlayer;

public class MidiModuleSamples
implements Runnable {
    SPExecutor sp = null;
    SMFPlayer player = null;
    MidiInputModule mi = null;
    MidiOutputModule mo = null;
    OctaveUp ou = null;
    PrintModule pm = null;

    public static MidiDevice.Info[] getMidiDeviceInfos() {
        return MidiSystem.getMidiDeviceInfo();
    }

    public MidiDevice setMidiDevice() {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        MidiDevice midiDevice = null;
        for (int i = 0; i < infoArray.length; ++i) {
            try {
                System.err.println("*** " + i + " ***");
                System.err.println("  Description:" + infoArray[i].getDescription());
                System.err.println("  Name:" + infoArray[i].getName());
                System.err.println("  Vendor:" + infoArray[i].getVendor());
                midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
                if (midiDevice instanceof Sequencer) {
                    System.err.println("  *** This is Sequencer.");
                }
                if (midiDevice instanceof Synthesizer) {
                    System.err.println("  *** This is Synthesizer.");
                }
                System.err.println();
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in), 1);
            System.out.print("Using Device Number: ");
            String string = bufferedReader.readLine();
            midiDevice = MidiSystem.getMidiDevice(infoArray[Integer.parseInt(string)]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return midiDevice;
    }

    public void run() {
        while (this.player.isNowPlaying()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.sp.stop();
        this.mi.close();
    }

    public MidiModuleSamples(String[] stringArray) {
        try {
            this.sp = new SPExecutor(null, 0);
            this.player = new SMFPlayer();
            this.player.readSMF(stringArray[0]);
            this.mi = new MidiInputModule(this.player, MidiSystem.getMidiDevice(MidiSystem.getMidiDeviceInfo()[0]));
            this.mo = new MidiOutputModule(MidiSystem.getReceiver());
            this.pm = new PrintModule();
            this.sp.addSPModule(this.mi);
            this.sp.addSPModule(this.pm);
            this.sp.addSPModule(this.mo);
            this.sp.connect(this.mi, 0, this.pm, 0);
            this.sp.connect(this.pm, 0, this.mo, 0);
            this.sp.start();
            System.out.println("press enter to start >>>");
            System.in.read();
            this.player.play();
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        new MidiModuleSamples(stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PrintModule
    extends SPModule<MidiEventWithTicktime, MidiEventWithTicktime> {
        @Override
        public void execute(List<QueueReader<MidiEventWithTicktime>> list, List<TimeSeriesCompatible<MidiEventWithTicktime>> list2) throws InterruptedException {
            MidiEventWithTicktime midiEventWithTicktime = list.get(0).take();
            System.out.println(midiEventWithTicktime.getMessage().getMessage()[1]);
            list2.get(0).add(midiEventWithTicktime);
        }

        @Override
        public int getInputChannels() {
            return 1;
        }

        @Override
        public int getOutputChannels() {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OctaveUp
    extends SPModule<MidiEventWithTicktime, MidiEventWithTicktime> {
        @Override
        public void execute(List<QueueReader<MidiEventWithTicktime>> list, List<TimeSeriesCompatible<MidiEventWithTicktime>> list2) throws InterruptedException {
            MidiEventWithTicktime midiEventWithTicktime = list.get(0).take();
            ShortMessage shortMessage = (ShortMessage)midiEventWithTicktime.getMessage();
            try {
                shortMessage.setMessage(shortMessage.getStatus(), Math.min(127, shortMessage.getData1() + 12), shortMessage.getData2());
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
            }
            list2.get(0).add(new MidiEventWithTicktime(shortMessage, midiEventWithTicktime.getTick(), midiEventWithTicktime.music_position));
        }

        @Override
        public int getInputChannels() {
            return 1;
        }

        @Override
        public int getOutputChannels() {
            return 1;
        }
    }
}

