/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.commands.ChordConverter;
import jp.crestmuse.cmx.amusaj.filewrappers.ArffWrapper;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCC2ARFF
extends CMXCommand<FileWrapperCompatible, FileWrapperCompatible> {
    private ArffWrapper arff = new ArffWrapper("chord");

    SCC2ARFF() {
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"};
        String[] stringArray2 = new String[]{"A", "A#", "A#aug", "A#dim", "A#m", "Aaug", "Adim", "Am", "B", "Baug", "Bdim", "Bm", "C", "C#", "C#aug", "C#dim", "C#m", "Caug", "Cdim", "Cm", "D", "D#", "D#aug", "D#dim", "D#m", "Daug", "Ddim", "Dm", "E", "Eaug", "Edim", "Em", "F", "F#", "F#aug", "F#dim", "F#m", "Faug", "Fdim", "Fm", "G", "G#", "G#aug", "G#dim", "G#m", "Gaug", "Gdim", "Gm"};
        this.arff.addAttribute("CurrentNote", stringArray);
        this.arff.addAttribute("CurrentChord", stringArray2);
        this.arff.addAttribute("NextNote", stringArray);
        this.arff.addAttribute("NextChord", stringArray2);
    }

    @Override
    protected FileWrapperCompatible run(FileWrapperCompatible fileWrapperCompatible) throws IOException, ParserConfigurationException, SAXException, TransformerException, InvalidFileTypeException {
        SCCXMLWrapper sCCXMLWrapper = (SCCXMLWrapper)fileWrapperCompatible;
        ChordConverter chordConverter = new ChordConverter();
        int n = -1;
        String string = null;
        String string2 = "UNDEFINED";
        for (int i = 0; i < sCCXMLWrapper.getHeaderElementList().length; ++i) {
            if (!sCCXMLWrapper.getHeaderElementList()[i].name().equals("KEY")) continue;
            string2 = chordConverter.getPrefix(sCCXMLWrapper.getHeaderElementList()[i].content());
            break;
        }
        if (string2.equals("UNDEFINED")) {
            System.out.println(fileWrapperCompatible + " is invalid musickey");
            return null;
        }
        for (SCCXMLWrapper.Annotation annotation : sCCXMLWrapper.getChordList()) {
            String string3 = annotation.content();
            if (string3.equals("D'")) continue;
            int n2 = -1;
            for (SCCXMLWrapper.Note note : sCCXMLWrapper.getPartList()[0].getNoteList()) {
                if (note.onset() < annotation.onset()) continue;
                n2 = note.notenum() % 12;
                break;
            }
            if (n2 == -1) {
                return null;
            }
            n2 = chordConverter.noteTransfer(string2, n2);
            if ((string3 = chordConverter.chordOmitter(chordConverter.chordTransfer(string2, string3))).equals("/")) {
                string3 = string;
            }
            if (string != null && !string.matches(chordConverter.ignore_chords) && !string3.matches(chordConverter.ignore_chords)) {
                this.arff.addData(n + "," + string + "," + n2 + "," + string3);
            }
            n = -1;
            for (SCCXMLWrapper.Note note : sCCXMLWrapper.getPartList()[0].getNoteList()) {
                if (note.onset() >= annotation.offset()) break;
                n = note.notenum();
            }
            if (n == -1) {
                return null;
            }
            n %= 12;
            string = string3;
        }
        return null;
    }

    @Override
    protected void postproc() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        FileOutputStream fileOutputStream = new FileOutputStream(new File("hoge.arff"));
        this.arff.write(fileOutputStream);
    }

    public static void main(String[] stringArray) {
        System.out.println("ugoita--!");
    }
}

