/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

public class ChordConverter {
    final String default_chord = "C";
    final String key_set_Regexp = "C|B#|C#|Db|D|D#|Eb|E|Fb|F|E#|F#|Gb|G|G#|Ab|A|A#|Bb|B|Cb";
    final String[] key_list = new String[]{"C", "B#", "C#", "Db", "D", "D#", "Eb", "E", "Fb", "F", "E#", "F#", "Gb", "G", "G#", "Ab", "A", "A#", "Bb", "B", "Cb"};
    final int[] key_distance = new int[]{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 11};
    final String[] delete_chords = new String[]{"M7", "sus[0-9]", "\\(on.+\\)|on.+", "add[0-9]", "M$", "\\(\\)|\\(#\\)|\\(\\+\\)|\\(-\\)|\\(b\\)", "6|7|9|11|13"};
    final String[][] change_chords = new String[][]{{"t", "bb", "m\\(\\-5\\)", "m\\-5", "mb5", "m\\(b5\\)", "([^m])\\(\\+5\\)", "([^m])\\+5", "([^m])\\(#5\\)", "([^m])#5"}, {"", "b", "dim", "dim", "dim", "dim", "$1aug", "$1aug", "$1aug", "$1aug"}};
    final String[][] format_chords = new String[][]{{"\\(+#([1-9]+)\\)+", "\\(+([1-9]+)\\)+", "\\(*\\+([1-9]+)\\)*", "\\(*b([1-9]+)\\)*", "\\(*-([1-9]+)\\)*", "\\(B([1-9]+)\\)"}, {"\\(#$1\\)", "\\(#$1\\)", "\\(#$1\\)", "\\(b$1\\)", "\\(b$1\\)", "\\(b$1\\)"}};
    final String ignore_chords = ".+\\(b5\\)|.+\\(#5\\)|.+maug|.+mdim";
    final String[] diatonic_inC = new String[]{"C", "Dm", "Em", "F", "G", "Am", "Bm(b5)"};

    public int noteTransfer(String string, int n) {
        return this.noteTransfer(string, n, "C");
    }

    public int noteTransfer(String string, int n, String string2) {
        int n2;
        if (n < 0 || 11 < n) {
            System.out.println("You attempt to transfer less than 0 or more than 11 number note.");
            n %= 12;
            n += 12;
        }
        for (n2 = this.key2dist(string2) - this.key2dist(string); n2 < 0; n2 += 12) {
        }
        if (n + n2 == 0) {
            return n;
        }
        return (n + n2) % 12;
    }

    public String chordTransfer(String string, String string2) {
        return this.chordTransfer(string, string2, "C");
    }

    public String chordTransfer(String string, String string2, String string3) {
        int n;
        if (string2.equals("/")) {
            return "/";
        }
        int n2 = this.key2dist(string3) - this.key2dist(string);
        if (n2 < 0) {
            n2 += 12;
        }
        if (string2.length() == 1 || string2.charAt(1) != '#' && string2.charAt(1) != 'b') {
            n = 1;
        } else if (string2.charAt(1) != '#' || string2.charAt(1) != 'b') {
            n = 2;
        } else {
            System.out.println("ERROR: chord is invalid");
            n = 0;
        }
        String string4 = string2.substring(0, n);
        int n3 = this.key2dist(string4) + n2;
        if (n3 > 11) {
            n3 -= 12;
        }
        String string5 = this.dist2key(n3);
        return string2.replaceFirst(string4, string5);
    }

    public int key2dist(String string) {
        for (int i = 0; i < this.key_list.length; ++i) {
            if (!string.equals(this.key_list[i])) continue;
            int n = this.key_distance[i];
            return n;
        }
        if (string.equals("/")) {
            return -1;
        }
        System.out.println("Invalid Chord: " + string);
        return -1;
    }

    public String dist2key(int n) {
        for (int i = 0; i < this.key_distance.length; ++i) {
            if (n != this.key_distance[i]) continue;
            return this.key_list[i];
        }
        return "ERROR";
    }

    public String chordOmitter(String string) {
        int n;
        String string2 = string;
        String string3 = null;
        string3 = null;
        while (!string2.equals(string3)) {
            string3 = string2;
            for (n = 0; n < this.delete_chords.length; ++n) {
                string2 = string2.replaceAll(this.delete_chords[n], "");
            }
        }
        string3 = null;
        while (!string2.equals(string3)) {
            string3 = string2;
            for (n = 0; n < this.change_chords[0].length; ++n) {
                string2 = string2.replaceAll(this.change_chords[0][n], this.change_chords[1][n]);
            }
        }
        string3 = null;
        while (!string2.equals(string3)) {
            string3 = string2;
            for (n = 0; n < this.format_chords[0].length; ++n) {
                string2 = string2.replaceAll(this.format_chords[0][n], this.format_chords[1][n]);
            }
        }
        return this.chordTransfer("C", string2);
    }

    public String getPrefix(String string) {
        if (string.length() == 1 || string.charAt(1) != '#' && string.charAt(1) != 'b') {
            return string.substring(0, 1);
        }
        return string.substring(0, 2);
    }

    public boolean keyNearIs(String string, String string2, int n) {
        return Math.abs(this.key2dist(string) - this.key2dist(string2)) <= n;
    }

    public boolean isDiatonic(String string) {
        for (int i = 0; i < this.diatonic_inC.length; ++i) {
            if (!string.equals(this.diatonic_inC[i])) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        ChordConverter chordConverter = new ChordConverter();
        try {
            System.out.println(chordConverter.chordOmitter("B(b5)"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

