;; cmail-use-feedmail.el --- Send mail with feedmail

;; Copyright (C) 1992-2000 Yukihiro Matsumoto

;; Author: Nakagawa Makoto <makoto.nakagawa@jp.compaq.com>
;; Keywords: mail
;; Created at: Sat Feb 26 15:39:56 JST 2000
;; $Date: 2000/12/06 18:29:09 $
;; $Revision: 1.15 $

;; This file is part of cmail (a mail utility for GNU Emacs)

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or (at
;; your option) any later version.

;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;;; Code:

(require 'path-util)
(eval-when-compile (require 'emu)
		   (require 'cl) ; -> push
		   (require 'cmail-vars))

;; ... $B0MB84X78$N%A%'%C%/(B
(when (module-installed-p 'feedmail)

;;
;; $B%m!<%I;~$K@_Dj$7$F$7$^$&$b$N!#(B
;;
(autoload 'feedmail-send-it "feedmail")
(autoload 'feedmail-run-the-queue "feedmail")
(autoload 'feedmail-run-the-queue-no-prompts "feedmail")
(autoload 'feedmail-queue-reminder "feedmail")

(autoload 'cmail-toggle-use-feedmail "cmail-feedmail")
(autoload 'cmail-feedmail-toggle-queueing "cmail-feedmail") ; not necessary

(defvar si:cmail-send-mail-function 'sendmail-send-it)

;;
;; menu & keymap
;;
(if running-xemacs
    nil ; noop
  (cmail-define-key 'cmail-summary-menu-bar-feedmail nil "Feedmail")
  (define-key cmail-summary-menu-bar-feature [feedmail]
    (cons "Feedmail Feature" cmail-summary-menu-bar-feedmail)))

(cond
 ((or running-emacs-19
      (and (= emacs-major-version 20)
	   (< emacs-minor-version 3)))
  (add-hook 'cmail-toggle-feature-menu-bar-hook
	    'cmail-feedmail-toggle-feature-menu-bar)
  (defun cmail-feedmail-toggle-feature-menu-bar ()
    (if (not cmail-use-feedmail)
	(progn
	  (define-key cmail-summary-menu-bar-feedmail [queue-run] 
	    'undefined)
	  (define-key cmail-summary-menu-bar-feedmail [queue]
	    'undefined)
	  (define-key cmail-summary-menu-bar-feedmail [toggle]
	    '("Use feedmail" . cmail-toggle-use-feedmail)))
      (if cmail-feedmail-enable-queue
	  (progn
	    (define-key cmail-summary-menu-bar-feedmail [queue-run]
	      '("Run the Queue" . cmail-feedmail-run-the-queue))
	    (define-key cmail-summary-menu-bar-feedmail [queue]
	      '("Disable Queue" . cmail-feedmail-toggle-queueing)))
	(define-key cmail-summary-menu-bar-feedmail [queue-run]
	  'undefined)
	(define-key cmail-summary-menu-bar-feedmail [queue]
	  '("Enable Queue" . cmail-feedmail-toggle-queueing)))
      (define-key cmail-summary-menu-bar-feedmail [toggle]
	'("Do not use feedmail" . cmail-toggle-use-feedmail)))))
 ((not running-xemacs) ; over 20.3
  (cmail-define-key
   'cmail-summary-menu-bar-feedmail
   '(([queue]
      (menu-item "Enable Queue" cmail-feedmail-toggle-queueing
		 :enable cmail-use-feedmail
		 :button (:toggle . cmail-feedmail-enable-queue)
		 :keys "\\[cmail-feedmail-enable-queue]"))
     ([queue-run]
      (menu-item "Run the Queue" cmail-feedmail-run-the-queue
		 :enable (and cmail-use-feedmail cmail-feedmail-enable-queue)
		 :keys "\\[cmail-feedmail-run-the-queue]"))
     ([toggle]
      (menu-item "Use feedmail" cmail-toggle-use-feedmail
		 :button (:toggle . cmail-use-feedmail)
		 :keys "\\[cmail-toggle-use-feedmail]")))))
 (t ; xemacs
  ;; define-key $B$K9g$o$;$F%a%K%e!<$N@hF,$KDI2C$7$F$_$?!#(B
  ;; $B$J$s$+$$$^$$$A!)(B
  (let* ((d cmail-summary-menu-bar-feature)
	 (l (catch 'end
	      (while d
		(if (or (vectorp (cadr d))
			(and (listp (cadr d))
			     (stringp (caadr d))))
		    (throw 'end d))
		(setq d (cdr d)))
	      nil)))
    (if l
	(setcdr l
		(push 
		 '("Feedmail Feature"
		   ["Enable Queue" cmail-feedmail-toggle-queueing
		    :active cmail-use-feedmail
		    :style toggle
		    :selected cmail-feedmail-enable-queue]
		   ["Run the Queue" cmail-feedmail-run-the-queue
		    :active (and cmail-use-feedmail
				   cmail-feedmail-enable-queue)]
		   ["Use feedmail" cmail-toggle-use-feedmail
		    :style toggle
		    :selected cmail-use-feedmail])
		 (cdr l)))))))

;;
;; custom $B4XO"(B (minimum set)
;;
(defun cmail-feedmail-set-use-feedmail (symbol value)
  ;; value $B$,(B t $B$N>l9g$O(B cmail-toggle-use-feedmail $B$X$N:G=i$N8F$S=P$7$O(B
  ;; $BI,$:<B9T$9$kI,MW$,$"$k!#(B
  ;; $B$3$N;~E@$G$O(B cmail-use-feedmail $B$ODj5A$5$l$F$$$J$$2DG=@-$"$j!#(B
  (unless (get 'cmail-use-feedmail 'already)
    (setq cmail-use-feedmail nil)
    (put 'cmail-use-feedmail 'already t))
  (unless (equal cmail-use-feedmail value)
    (cmail-toggle-use-feedmail)))

(cmail-i18n-defgroup cmail-use-feedmail-group nil
  ((ja_JP . "feedmail $B$K4X$9$k@_Dj!#(B")
   (en_US . "Settings about feedmail."))
  :group 'cmail-other-features)

(cmail-i18n-defcustom cmail-use-feedmail nil ; $B%G%U%)%k%H(B on $B$K$9$k$K$O$3$$$D(B
  ((ja_JP . "\
*`send-mail-function' $B$K(B `feedmail-send-it' $B$r;HMQ$9$k$+$I$&$+!#(B'setq' $B$GCM$rJQ99$7$J$$$3$H!#(B

feedmail.el $B$,%$%s%9%H!<%k$5$l$F$$$kI,MW$,$"$k!#(B")
   (en_US . "\
*Use `feedmail-send-it' as a `send-mail-function'.  Do not change this variable directly with 'setq'.

feedmail.el needs to be installed."))
  :set 'cmail-feedmail-set-use-feedmail
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-other-features
  :group 'cmail-envriron)
(cmail-custom-add-init 'cmail-feedmail-set-use-feedmail 'cmail-use-feedmail)

(provide 'cmail-use-feedmail)

) ; (when (moudule-installed-p 'feedmail)) ends here

;;; @ End.
;;;

;;; cmail-use-feedmail.el ends here
