;;;
;;;  cmail-vars.el - cmail variables initialization
;;;
;;;  $Author: MaNakagawa $
;;;  created at: Mon Jul 12 10:30:57 JST 1993
;;;
;;;  Copyright (C) 1992-1996 Yukihiro Matsumoto.

;; This file is not part of GNU Emacs but obeys its copyright notice.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.

(provide 'cmail-vars)
;(require 'rfc822)
(eval-when-compile (require 'pcustom)
		   (require 'static))

;;
;; ======= customize $B%7%g!<%H%+%C%H%3%^%s%I(B =============================
(defun cmail-customize nil
  (interactive)
  (if (fboundp 'customize-group)
      (progn
	(customize-group 'cmail)
	(delete-other-windows))
    (error "Sorry, but the custom feature is not available on this system.")))

;;
;; ======= $B%3%s%Q%A%S%j%F%#$N3NJ](B =======================================

;; In case when a custom version that does not support :set feature is
;; loaded, to avoid a problem with compiling/running cmail, here goes
;; some workaround definitions. First, for those Emacs that do not
;; support keywords (symbols that begin with a colon), define them for
;; custom use.
(static-if (null (boundp ':cmail-custom-test-symbol))
    (mapcar
     '(lambda (keyword) (or (boundp keyword) (set-default keyword keyword)))
     '(:initialize :set :get :require :prefix :tag
		   :load :link :options :type :group)))

;; Now, test defcustom if it has the :set feature, and if it does not
;; behave as expected, override defcustom with defvar like tinycustom
;; does. Note that all of these should happen at compile time to limit
;; the scope in order to avoid changing run-time behavior of other
;; packages which assume actual custom (such as Gnus). If this module
;; is loaded or evaluated as a lisp source, then the change will be in
;; effect in a global manner, which may cause some trouble to those
;; packages. Please avoid loading or evaluating the source version of
;; this file unless necessary.
(static-if (let (test-sym)
	     (condition-case nil
		 (defcustom *cmail-custom-test-symbol t ""
		   :set '(lambda (sym val) (setq test-sym val)))
	       (error nil))
	     test-sym)
    (defmacro cmail-custom-add-init (init-function sym) nil)
  (eval-when-compile
    (defmacro defcustom (sym val doc &rest rest)
      "An emulated defcustom in cmail-vars.el, when byte-compile only."
      (` (defvar (, sym) (, val) (,doc)))))
  
  ;; For those customizable variables that supports the defcustom
  ;; :set feature (except for cmail-i18n-doc-language), when
  ;; 'tiny' version of defcustom is used, initialization must be
  ;; explicitly executed.  The following macro can be used to set
  ;; up the initializer for such variables, and cmail-custom-init,
  ;; which is called from the function cmail, will initialize the
  ;; instrumented variables.
  (defvar *cmail-custom-initializer nil)
  (defmacro cmail-custom-add-init (init-function sym)
    (` (progn
	 (setq *cmail-custom-initializer
	       (append *cmail-custom-initializer
		       (list (list (, init-function) (, sym))))))))
  
  (defun cmail-custom-init ()
    (mapcar
     (function
      (lambda (init)
	(if (boundp (elt init 1))
	    (funcall (elt init 0) (elt init 1) (eval (elt init 1))))))
     *cmail-custom-initializer)))

;;
;; ======= $B%I%-%e%a%s%H$NJ#?t8@8l$N%5%]!<%H(B =============================
(defvar cmail-doc-custgroup nil)
(put 'cmail-i18n-defgroup 'lisp-indent-function 2)
(defmacro cmail-i18n-defgroup (group something doc &rest rest)
  (` (prog1
	 (, (append (` (defgroup (, group) (, something)
			 (, (cdr (car doc))))) rest))
       (, (append (` (setq cmail-doc-custgroup
			   (cons
			    (quote (, (cons group doc)))
			    cmail-doc-custgroup))))))))

(defvar cmail-doc-custvars nil)
(put 'cmail-i18n-defcustom 'lisp-indent-function 2)
(defmacro cmail-i18n-defcustom (name value doc &rest rest)
  (` (prog1
	 (, (append (` (defcustom (, name) (, value)
			 (, (cdr (car doc))))) rest))
       (, (append (` (setq cmail-doc-custvars
			   (cons
			    (quote (, (cons name doc)))
			    cmail-doc-custvars))))))))

(defun cmail-i18n-set-doc-language (symbol language)
  (set symbol language)
  (cmail-i18n-swap-doc language))

(defun cmail-i18n-swap-doc (language)
  (cmail-i18n-swap-doc2 language 'variable-documentation cmail-doc-custvars)
  (cmail-i18n-swap-doc2 language 'group-documentation cmail-doc-custgroup))

(defun cmail-i18n-swap-doc2 (language doc-property doc-list)
  (while doc-list
    (setq doc (cdr (assq language (cdr (car doc-list)))))
    (if (stringp doc)
	(put (car (car doc-list)) doc-property doc))
    (setq doc-list (cdr doc-list))))

;;
;; ======= $B%+%9%?%^%$%:%0%k!<%W@_Dj(B =====================================
(cmail-i18n-defgroup cmail nil
  ((ja_JP . "Emacs $BMQ$N%a!<%k%j!<%@(B")
   (en_US . "Yet another mail reader for Emacs"))
  :group 'mail)

(cmail-i18n-defgroup cmail-general nil
  ((ja_JP . "$B%f!<%6>pJs!"4D6-Ey$N@_Dj(B")
   (en_US . "Account, user info and environments."))
  :group 'cmail)

(cmail-i18n-defgroup cmail-directories nil
  ((ja_JP . "$B;HMQ%G%#%l%/%H%j!"%a!<%k%9%W!<%k$N@_Dj(B.")
   (en_US . "Directories, mail spools, POP account."))
  :group 'cmail-general)

(cmail-i18n-defgroup cmail-mime nil
  ((ja_JP . "MIME $B4X78$N@_Dj(B.")
   (en_US . "MIME related options."))
  :group 'cmail-general)

(cmail-i18n-defgroup cmail-other-features nil
  ((ja_JP . "$BB>$N%Q%C%1!<%84X78$N@_Dj(B.")
   (en_US . "Options for other packages."))
  :group 'cmail-general)

(cmail-i18n-defgroup cmail-startup nil
  ((ja_JP . "$B%9%?!<%H%"%C%W$N@_Dj(B")
   (en_US . "Start up options."))
  :group 'cmail-general)

(cmail-i18n-defgroup cmail-display-style nil
  ((ja_JP . "$BJ8;z?'!"I=<(%9%?%$%kEy$N@_Dj(B.")
   (en_US . "Typeface, display styles options."))
  :group 'cmail-general)

(cmail-i18n-defgroup cmail-menu-style nil
  ((ja_JP . "$B%a%K%e!<$N@_Dj(B")
   (en_US . "Menu customization."))
  :group 'cmail-general)

(cmail-i18n-defgroup cmail-printing nil
  ((ja_JP . "$B0u:~$N@_Dj(B")
   (en_US . "Printing options"))
  :group 'cmail-general)

(cmail-i18n-defgroup cmail-archive nil
  ((ja_JP . "$B%U%)%k%@A`:n(B/$B<+F0J,N`$K4X$9$k@_Dj(B.")
   (en_US . "Customize folder file manipulation and auto archiving."))
  :group 'cmail)

(cmail-i18n-defgroup cmail-summary nil
  ((ja_JP . "$B%5%^%j%b!<%I$K4X$9$k@_Dj(B.")
   (en_US . "Customize cmail summary mode."))
  :group 'cmail)

(cmail-i18n-defgroup cmail-readmail nil
  ((ja_JP . "$B<u?.%a!<%k$NI=<($K4X$9$k@_Dj(B.")
   (en_US . "Customize cmail message viewer."))
  :group 'cmail)

(cmail-i18n-defgroup cmail-sendmail nil
  ((ja_JP . "$BAw?.%a!<%k$NA`:n$K4X$9$k@_Dj(B.")
   (en_US . "Customize cmail mail composer."))
  
  :group 'cmail)

(cmail-i18n-defgroup cmail-folders nil
  ((ja_JP . "$B%U%)%k%@0lMw%b!<%I$K4X$9$k@_Dj(B.")
   (en_US . "Customize cmail folders list mode."))
  :group 'cmail)

(cmail-i18n-defgroup cmail-all-variables nil
  ((ja_JP . "$BA4$F$N%+%9%?%^%$%:JQ?t$N%j%9%H(B.")
   (en_US . "List of all customizable variable in cmail."))
  :group 'cmail)

;;
;; ======= $B=i4|@_Dj(B ==================================================
(cmail-i18n-defcustom cmail-folder-alist nil
  ((ja_JP . "\
*$B%a%$%k$r<+F0E*$K%U%)%k%@$KJ,$1$k$?$a$N(Balist.

		(header (pattern . folder))

$B$NJB$S$K$J$C$F$$$k(B. $BO"A[%j%9%H$N@hF,$K6a$$$[$IM%@h=g0L$,9b$/$J$C$F$$$k(B.
$B0J2<$O$=$NO"A[%j%9%H$NNc$G$"$k(B.

((\"From\" (\"foo\" . \"FOO\")
         (\"bar\" . \"BAR\"))
 (\"Cc\" (\"glorp\" . \"GLORP\"))
 (\"Subject\" (\"nerp\" . \"NERP\"))
 (\"Header_field\" (\"header_value\" . \"FOLDER_NAME\")))

$B%U%)%k%@;XDj%j%9%H$NBe$o$j$K4X?t$r;XDj$9$k$H(B, $B$=$N4X?t$NJV$9CM$,(B,
$BJ8;zNs$N;~(B, $BLa$jCM$N<($9%U%)%k%@$KJ,N`$5$l$k(B. $B4X?t$,8F$P$l$k;~$K$O(B
current-folder$B$K$O%a%$%k$N%X%C%@$,3JG<$5$l$F$$$k(B.")
   (en_US . "\
*An association list used for the automatic archiving.

Value shall be a list of lisp expressions with the following form.

		(header (pattern . folder))

An element is used as in the order it appears in the list. The
following is an example association list.

((\"From\" (\"foo\" . \"FOO\")
         (\"bar\" . \"BAR\"))
 (\"Cc\" (\"glorp\" . \"GLORP\"))
 (\"Subject\" (\"nerp\" . \"NERP\"))
 (\"Header_field\" (\"header_value\" . \"FOLDER_NAME\")))

Instead of a list of pattern/folder list, you may use a function which
returns a string as the destination folder. At the time the function
is called, it is coordinated such that the current buffer contains the
message header of the message being processed."))
  :type 'sexp
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-sort-header-alist nil
  ((ja_JP . "\
*$B%U%)%k%@Kh$K%5%^%j$N%=!<%HJ}K!$r;XDj$9$k$?$a$N(B alist.

$B0J2<$N$I$A$i$+$NJB$S$K$J$C$F$$$k(B. $BO"A[%j%9%H$N@hF,$K6a$$$[$I(B
$BM%@h=g0L$,9b$/$J$C$F$$$k(B.

		(key (folder $B!D(B))
		(key (pattern (folder $B!D(B)))

$B0J2<$O$=$NA0<T$NO"A[%j%9%H$NNc$G$"$k(B.

((\"S\" (\"foo\" \"bar\" \"hoge\" \"uja\"))
 (\"A\" (\"glorp\" \"nerp\"))
 (\"D\" (\"archive\"))
 (\"R\" (\"folder\" \"folder_name\" \"etc\")))

$B$3$3$G(B, \"S\"$B$b$7$/$O(B\"s\"$B$O%5%V%8%'%/%H=g$N%5%^%j%=!<%H$rI=$7(B,
\"R\"$B$b$7$/$O(B\"r\"$B$O4XO"$N$"$k%5%V%8%'%/%H=g$N%5%^%j%=!<%H$r(B,
\"A\"$B$b$7$/$O(B\"a\"$B$OAw$j<g$NL>A0=g$N%5%^%j%=!<%H$r(B, \"D\"$B$b$7$/$O(B
\"d\"$B$OF|IU=g$N%5%^%j%=!<%H$r(B, \"T\"$B$b$7$/$O(B\"t\"$B$O;~9o$r4^$`F|IU=g$N(B
$B%5%^%j%=!<%H$r$=$l$>$lI=$9(B.

$B$^$?(B, $B0J2<$K8e<T$NO"A[%j%9%H$NNc$r<($9(B.

((\"N\" (\"X-MAIL-Count\" (\"foo\" \"bar\"))
      (\"X-Sequence\" (\"hoge\" \"uja\")))
 (\"H\" (\"Header-Field\" (\"glorp\" \"nerp\")))
 (\"F\" (func_name (\"folder_name\" \"etc\"))))

$B$3$3$G(B, \"N\"$B$b$7$/$O(B\"n\"$B$O?tCM$KJQ492DG=$J%U%#!<%k%I$r;}$D%X%C%@$r(B
$B%=!<%H$K;HMQ$7(B, \"H\"$B$b$7$/$O(B\"h\"$B$O$=$l0J30$N%U%#!<%k%I$r;}$D%X%C%@(B
$B$r%=!<%H$K;HMQ$9$k(B. $B$^$?(B, \"F\"$B$b$7$/$O(B\"f\"$B$N>l9g$O4X?t$r;XDj$7$F(B, 
$B$=$NLa$jCM$r%=!<%H$K;HMQ$9$k(B.")
   (en_US . "\
*An association list used for the automatic archiving.

Value shall be a list of lisp expressions with the following form.

		(header (pattern . folder))

An element is used as in the order it appears in the list. The
following is an example association list.

((\"From\" (\"foo\" . \"FOO\")
         (\"bar\" . \"BAR\"))
 (\"Cc\" (\"glorp\" . \"GLORP\"))
 (\"Subject\" (\"nerp\" . \"NERP\"))
 (\"Header_field\" (\"header_value\" . \"FOLDER_NAME\")))

Instead of a list of pattern/folder list, you may use a function which
returns a string as the destination folder. At the time the function
is called, it is coordinated such that the current buffer contains the
message header of the message being processed."))
  :type 'sexp
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-sort-header-alist nil
  ((ja_JP . "\
*$B%U%)%k%@Kh$K%5%^%j$N%=!<%HJ}K!$r;XDj$9$k$?$a$N(B alist.

$B0J2<$N$I$A$i$+$NJB$S$K$J$C$F$$$k(B. $BO"A[%j%9%H$N@hF,$K6a$$$[$I(B
$BM%@h=g0L$,9b$/$J$C$F$$$k(B.

		(key (folder $B!D(B))
		(key (pattern (folder $B!D(B)))

$B0J2<$O$=$NA0<T$NO"A[%j%9%H$NNc$G$"$k(B.

((\"S\" (\"foo\" \"bar\" \"hoge\" \"uja\"))
 (\"A\" (\"glorp\" \"nerp\"))
 (\"D\" (\"archive\"))
 (\"R\" (\"folder\" \"folder_name\" \"etc\")))

$B$3$3$G(B, \"S\"$B$b$7$/$O(B\"s\"$B$O%5%V%8%'%/%H=g$N%5%^%j%=!<%H$rI=$7(B,
\"R\"$B$b$7$/$O(B\"r\"$B$O4XO"$N$"$k%5%V%8%'%/%H=g$N%5%^%j%=!<%H$r(B,
\"A\"$B$b$7$/$O(B\"a\"$B$OAw$j<g$NL>A0=g$N%5%^%j%=!<%H$r(B, \"D\"$B$b$7$/$O(B
\"d\"$B$OF|IU=g$N%5%^%j%=!<%H$r(B, \"T\"$B$b$7$/$O(B\"t\"$B$O;~9o$r4^$`F|IU=g$N(B
$B%5%^%j%=!<%H$r$=$l$>$lI=$9(B.

$B$^$?(B, $B0J2<$K8e<T$NO"A[%j%9%H$NNc$r<($9(B.

((\"N\" (\"X-MAIL-Count\" (\"foo\" \"bar\"))
      (\"X-Sequence\" (\"hoge\" \"uja\")))
 (\"H\" (\"Header-Field\" (\"glorp\" \"nerp\")))
 (\"F\" (func_name (\"folder_name\" \"etc\"))))

$B$3$3$G(B, \"N\"$B$b$7$/$O(B\"n\"$B$O?tCM$KJQ492DG=$J%U%#!<%k%I$r;}$D%X%C%@$r(B
$B%=!<%H$K;HMQ$7(B, \"H\"$B$b$7$/$O(B\"h\"$B$O$=$l0J30$N%U%#!<%k%I$r;}$D%X%C%@(B
$B$r%=!<%H$K;HMQ$9$k(B. $B$^$?(B, \"F\"$B$b$7$/$O(B\"f\"$B$N>l9g$O4X?t$r;XDj$7$F(B, 
$B$=$NLa$jCM$r%=!<%H$K;HMQ$9$k(B.")

   (en_US . "\
*Association list to specify sort pedicate for folders.

Either the following two foramt. The element that appears first has
precedence.

		(key (folder $B!D(B))
		(key (pattern (folder $B!D(B)))

The following is an example of the former format.

((\"S\" (\"foo\" \"bar\" \"hoge\" \"uja\"))
 (\"A\" (\"glorp\" \"nerp\"))
 (\"D\" (\"archive\"))
 (\"R\" (\"folder\" \"folder_name\" \"etc\")))

Where \"S\" or \"s\" specifies sort by subject. \"R\" or \"r\" specifies
sort by related subject, \"A\" or \"a\" specifies sort by sender address,
\"D\" or \"d\" specifies sort by date, \"T\" or \"t\" specifies sort by
time.

Next, the following is an example of the latter format.

((\"N\" (\"X-MAIL-Count\" (\"foo\" \"bar\"))
      (\"X-Sequence\" (\"hoge\" \"uja\")))
 (\"H\" (\"Header-Field\" (\"glorp\" \"nerp\")))
 (\"F\" (func_name (\"folder_name\" \"etc\"))))

Where \"N\" or \"n\" specifies sort by value in the specified header
field if convertible to a number, \"H\" or \"h\" specifies sort by
other field than specified, and \"F\" or \"f\" specifies function
whose return value will be used to sort."))
  :type 'sexp
  :group 'cmail-all-variables
  :group 'cmail-summary)

(cmail-i18n-defcustom cmail-sort-header-default nil
  ((ja_JP . "\
*$B%5%^%j$N%G%U%)%k%H$N%=!<%HJ}K!$N;XDj(B

cmail-sort-header-alist $B$N;XDj$K%^%C%A$7$J$$%U%)%k%@$N$_$KE,MQ$5$l$k(B.
cmail-sort-header-alist $B$N(B key $B$H$7$F;HMQ$5$l$k(B
\"S\", \"R\", \"A\", \"D\", \"T\" ($B$=$l$>$l>.J8;z$b2DG=(B)$B$r;XDj$9$k$3$H(B
$B$,2DG=(B.")
   (en_US . "\
*Default sort predicate charactor

Only applied to folders that do not match cmail-sort-header-alist.
Sort predicate charactors \"S\", \"R\", \"A\", \"D\", \"T\" (lower
letter is accepted) used in cmail-sort-header-alist may be used for
this variable as well."))
  :type '(choice (const nil)
		 (const :tag "Subject" "S")
		 (const :tag "Related Subject" "R")
		 (const :tag "Sender" "A")
		 (const :tag "Date" "D")
		 (const :tag "Time" "T"))
  :group 'cmail-all-variables
  :group 'cmail-summary)

(defvar cmail-default-headers '(("From")("To")("Cc")("Subject"))
  "cmail-mark-specified-mails$B$GJd40$9$k%X%C%@L>(B")

;; expire$B5!G=$O(Bfloat$B$N$J$$8E$$(Bemacs$B$G$O%5%]!<%H$5$l$J$$!%(B
(cmail-i18n-defcustom cmail-use-regexp-in-folder-alist nil
  ((ja_JP . "\
*cmail-folder-alist $B$NCf$K(B elisp $B$N@55,I=8=$r;HMQ$9$k$+$I$&$+(B.  

$B;HMQ$9$k>l9g!"5-=R$,4V0c$C$F$$$k$H@55,I=8=$NE83+%(%i!<$,=P$k(B
$B2DG=@-$,$"$k(B.")

   (en_US . "\
*Whether to allow regular expression in cmail-folder-alist.

Note that if regular expression is used, a parsing error could occur
and automatic archiving might be aborted abnormally when the regular
expression syntax is incorrect."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-auto-expirable-folders nil
  ((ja_JP . "\
*$B4{$KFI$s$@%a%$%k$r(Bexpire$B$9$k%U%)%k%@$N%j%9%H!%(B")
   (en_US . "\
*list of folders to expire read messages."))
  :type '(repeat string)
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-expiry-days-alist nil
  ((ja_JP . "\
*$B%U%)%k%@Kh$N(Bexpiry days $B$N;XDj(B.")
   (en_US . "\
*An assoc list specifies number of days to keep messages per folder."))
  :type '(choice (const nil)
		 (repeat (cons string integer)))
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-default-expiry-days 7
  ((ja_JP . "\
*cmail-expiry-days-alist $B$G@_Dj$5$l$F$$$J$$%U%)%k%@$N(B expiry-days$B!%(B")
   (en_US . "\
*Days to keep msgs in folders unspecified by cmail-expiry-days-alist"))
  :type 'integer
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-archive-on-get nil 
  ((ja_JP . "\
*non-nil$B$N;~(B, $B?7Ce(Bmail$B$N(Bget$B;~$K(Bauto-archive$B$9$k(B.")
   (en_US . "\
*Whether to perform auto archive immediately after getting new messages."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-archive-on-quit t
  ((ja_JP . "\
*non-nil$B$N;~(B, quit$B;~$K(Bauto-archive$B$9$k(B.")
   (en_US . "\
*Whether to perform auto archive just before quitting cmail."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-archive-on-visit t
  ((ja_JP . "\
*non-nil$B$N;~(B, visit$B;~$K(Bauto-archive$B$9$k(B.")
   (en_US . "\
*Whether to perform auto archive just before visiting another folder."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-expunge-on-save t
  ((ja_JP . "\
*non-nil$B$N;~(B, save$BA0$K%U%)%k%@$r@0M}$9$k(B.

$BCM$,@0?t$N>l9g(B, $B%U%)%k%@Fb$N(Bmail$B?t$,$=$NCM0J2<$N>l9g$@$1@0M}$9$k(B.")

   (en_US . "\
*Expunge messages before saving the visiting folder, if this is non-nil.

If this value is integer, expunge only when the folder contains less
number of messages than the number."))
  :type '(choice (const t) (const nil) integer)
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-default-from nil
  ((ja_JP . "\
$B<+J,<+?H$N%"%I%l%9J8;zNs(B.

non-nil $B$N;~$=$NCM$r(B From $B$K(B, cmail-always-cc-me $B$,(B on $B$N;~$O(BCC $B$K$b%;%C(B
$B%H$9$k(B. $B$^$?(B, cmail-self-addresses $B$,L@<(E*$K;XDj$5$l$J$$>l9g(B, $B$3$NCM(B
$B$,<+J,<+?H$rH=Dj$9$kJ8;zNs$H$7$F;HMQ$5$l$k(B. (user@FQDN) $B$N%U%)!<%^%C%H(B
$B$G$J$$$H8mF0:n$9$k2DG=@-$,$"$k(B.")
   (en_US . "\
Address string for yourself.

When non-nil, the value is used in the FROM field, and added to CC
list if cmail-always-cc-me is on. In addition, if cmail-self-addresses is
not explicitly designated, this string will be used to determine if an
address is considered as a self-address. It should be in (user@FQDN)
format, or may cause unexpected behavior."))
  :type '(choice (const nil) string)
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-self-addresses 'auto
  ((ja_JP . "\
*$B<+J,<+?H$H$_$J$9%"%I%l%9$K%^%C%A$9$kJ8;zNs(B/$B@55,I=8=$N%j%9%H(B. 

'auto $B$N;~$O<+J,<+?H$N%"%I%l%9(B (cmail-default-from $B$b$7$/$O<+F0E*$K@8(B
$B@.$5$l$?$b$N(B) $B$,;HMQ$5$l$k(B.

$BJ8;zNs$b$7$/$O@55,I=8=$N%j%9%H(B. $BJ8;zNs$,(B \"regexp: \" $B$G;O$^$C$F$$$k>l(B
$B9g@55,I=8=$G$"$k$H$_$J$5$l$k(B. $B%Q%?!<%s%^%C%A$O%"%I%l%9It$N(B addr-spec 
$BItJ,$G9T$o$l$k(B. $BL>A0Ey%3%a%s%H$O%Q%?!<%s%^%C%A$NBP>]$K$J$i$J$$$N$GCm0U(B.

$BNc(B:
     foo@bar.org              ; foo@bar.org $B$K%^%C%A$9$k(B
     regexp: foo@.*\\.bar\\.org ; bar.org $BFb$N%5%V%I%a%$%sFb$N%f!<%6(B
                              ; foo $B$K%^%C%A$9$k(B
")
   (en_US . "\
*A list of address strings that represents your self email address.

When 'auto, your address (derived from either cmail-default-from or
automatically generated) will be used.

The data type is string, and may contain a regular expression. A
string that starts with \"regexp: \" is processed as a regular
expression. The target string for the address pattern match is
restricted to only the addr-spec part. Comments such as quoted names
will be exclueded from the target string.

Examples:
     foo@bar.org              ; match for foo@bar.org
     regexp: foo@.*\\.bar\\.org ; match for user foo of a sub-domain
                              ; under bar.org domain
"))
  :type '(choice (const auto) (repeat string))
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-dont-cc-me-destinations nil
  ((ja_JP . "\
*$B%a%C%;!<%808@h$,$3$N%j%9%H$K4^$^$l$F$$$k>l9g$O<+J,$r(B CC $B$K$D$1$J$$(B.

$BJ8;zNs$b$7$/$O@55,I=8=$N%j%9%H(B. $BJ8;zNs$,(B \"regexp: \" $B$G;O$^$C$F$$$k>l(B
$B9g@55,I=8=$G$"$k$H$_$J$5$l$k(B. $B%Q%?!<%s%^%C%A$O%"%I%l%9It$N(B addr-spec 
$BItJ,$G9T$o$l$k(B. $BL>A0Ey%3%a%s%H$O%Q%?!<%s%^%C%A$NBP>]$K$J$i$J$$$N$GCm0U(B.

$BNc(B:
     foo@bar.org              ; foo@bar.org $B$K%^%C%A$9$k(B
     regexp: foo@.*\\.bar\\.org ; bar.org $BFb$N%5%V%I%a%$%sFb$N%f!<%6(B
                              ; foo $B$K%^%C%A$9$k(B
")
   (en_US . "\
*Don't add myself to CC when destination is found in this list.

The data type is string, and may contain a regular expression. A
string that starts with \"regexp: \" is processed as a regular
expression. The target string for the address pattern match is
restricted to only the addr-spec part. Comments such as quoted names
will be exclueded from the target string.

Examples:
     foo@bar.org              ; match for foo@bar.org
     regexp: foo@.*\\.bar\\.org ; match for user foo of a sub-domain
                              ; under bar.org domain
"))
  :type '(repeat string)
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-always-cc-me '(when-follow-up)
  ((ja_JP . "\
*$B<+J,<+?H$N%"%I%l%9$r(B CC $B$K$D$1$k5!G=$N@)8fJQ?t!%(B

$BCM$O(B t, nil $B$^$?$O%*%W%7%g%s$N%j%9%H$G%*%W%7%g%s$O(B when-new-compose
when-reply, when-follow-up, when-used-as-agent $B$,2DG=(B. t $B$N;~$OA4$F$N(B
$B%a!<%k:n@.;~$K(BCC$B<+J,IU2C5!G=$rM-8z$K$9$k!%?7$7$$%a!<%k$N:n@.;~!$JV?.%a!<(B
$B%k:n@.;~%U%)%m!<%"%C%W%a!<%k:n@.;~$KJL!9$K(BCC$B<+J,IU2C5!G=$rM-8z$K$9$k;~(B
$B$K$OBP1~$9$k%*%W%7%g%s$r%j%9%H$K$7$F$3$NJQ?t$K%;%C%H$7$F$*$/!%(B")
   (en_US . "\
*Option variable to control the function to add self address to CC.

The value can be either t, nil or a list of option atoms. The option
atoms include when-new-compose, when-reply, when-follow-up and
when-used-as-agent. When t, the CC-me function is enabled for all mail
composition types. To enable the CC-me function selectibly for each
differnt type of mail composition, list corresponding option atoms in
this variable."))
  :type '(choice (const t)
		 (repeat (choice (const when-new-compose)
				 (const when-reply)
				 (const when-follow-up)
				 (const when-used-as-agent))))
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-dont-cc-addresses 'self
  ((ja_JP . "\
follow-up $B$N:]!$(BCC $B$K4^$a$J$$%"%I%l%9$N%j%9%H(B.

'self $B$N;~$O<+J,<+?H$N%"%I%l%9(B (cmail-default-from $B$b$7$/$O<+F0E*$K(B
$B@8@.$5$l$?$b$N(B) $B$,;HMQ$5$l$k(B.

$BJ8;zNs$b$7$/$O@55,I=8=$N%j%9%H(B. $BJ8;zNs$,(B \"regexp: \" $B$G;O$^$C$F$$$k>l(B
$B9g@55,I=8=$G$"$k$H$_$J$5$l$k(B. $B%Q%?!<%s%^%C%A$O%"%I%l%9It$N(B addr-spec 
$BItJ,$G9T$o$l$k(B. $BL>A0Ey%3%a%s%H$O%Q%?!<%s%^%C%A$NBP>]$K$J$i$J$$$N$GCm0U(B.

$BNc(B:
     foo@bar.org              ; foo@bar.org $B$K%^%C%A$9$k(B
     regexp: foo@.*\\.bar\\.org ; bar.org $BFb$N%5%V%I%a%$%sFb$N%f!<%6(B
                              ; foo $B$K%^%C%A$9$k(B
")
   (en_US . "\
List of addresses to be excluded from the CC field when forwarding.

When 'self, your address (derived from either cmail-default-from or
automatically generated) will be used.

The data type is string, and may contain a regular expression. A
string that starts with \"regexp: \" is processed as a regular
expression. The target string for the address pattern match is
restricted to only the addr-spec part. Comments such as quoted names
will be exclueded from the target string.

Examples:
     foo@bar.org              ; match for foo@bar.org
     regexp: foo@.*\\.bar\\.org ; match for user foo of a sub-domain
                              ; under bar.org domain
"))
  :type '(choice (const self) (repeat string))
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-dont-reply-to-addresses 'self
  ((ja_JP . "\
*follow-up $B$N:]!"(BTO $B$K4^$a$J$$%"%I%l%9$N%j%9%H(B.

'self $B$N;~$O<+J,<+?H$N%"%I%l%9(B (cmail-default-from $B$b$7$/$O<+F0E*$K(B
$B@8@.$5$l$?$b$N(B) $B$,;HMQ$5$l$k(B.

$BJ8;zNs$b$7$/$O@55,I=8=$N%j%9%H(B. $BJ8;zNs$,(B \"regexp: \" $B$G;O$^$C$F$$$k>l(B
$B9g@55,I=8=$G$"$k$H$_$J$5$l$k(B. $B%Q%?!<%s%^%C%A$O%"%I%l%9It$N(B addr-spec 
$BItJ,$G9T$o$l$k(B. $BL>A0Ey%3%a%s%H$O%Q%?!<%s%^%C%A$NBP>]$K$J$i$J$$$N$GCm0U(B.

$BNc(B:
     foo@bar.org              ; foo@bar.org $B$K%^%C%A$9$k(B
     regexp: foo@.*\\.bar\\.org ; bar.org $BFb$N%5%V%I%a%$%sFb$N%f!<%6(B
                              ; foo $B$K%^%C%A$9$k(B
")
   (en_US . "\
*List of addresses to be excluded from To field when reply/follow-up.

When 'self, your address (derived from either cmail-default-from or
automatically generated) will be used.

The data type is string, and may contain a regular expression. A
string that starts with \"regexp: \" is processed as a regular
expression. The target string for the address pattern match is
restricted to only the addr-spec part. Comments such as quoted names
will be exclueded from the target string.

Examples:
     foo@bar.org              ; match for foo@bar.org
     regexp: foo@.*\\.bar\\.org ; match for user foo of a sub-domain
                              ; under bar.org domain
"))
  :type '(choice (const self) (repeat string))
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-mail-insert-x-mailer t
  ((ja_JP . "\
Non-nil $B$N;~!$Aw$k%a%$%k$K(BX-Mailer$B$rIU2C$9$k(B.")
   (en_US . "\
Non-nil means attach X-Mailer field to every out-going message."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-mail-query-cc nil
  ((ja_JP . "\
Non-nil $B$N;~%a!<%k:n@.%P%C%U%!$r8F$S=P$9;~$K(B CC $B$r?R$M$k(B.")
   (en_US . "\
Non-nil means to prompt for CC address when invoking the draft mode."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-path "~/Mail/"
  ((ja_JP . "\
*$B%U%)%k%@$rJ];}$9$k%G%#%l%/%H%j(B. $B:G8e$OI,$:%9%i%C%7%e(B/$B$G=*$o$k(B.")
   (en_US . "\
*Directory to store all folders. String must end with '/' (slash)."))
  :type '(directory)
  :group 'cmail-all-variables
  :group 'cmail-directories)

(cmail-i18n-defcustom cmail-compressed-folders nil
  ((ja_JP . "\
*$BCM$,(B'jam-zcat$B$G$"$k;~(B, $B%U%)%k%@Jd40%j%9%H$G(B.gz|.Z$B$,<h$j=|$+$l$k(B.

$B05=L%U%)%k%@$N%"%/%;%9$K$O(Bjam-zcat$B$^$?$O(Bjka-compr$B$,I,MW(B.")
   (en_US . "\
*When 'jam-zcat, suffix .gz|.Z will be hidden from the folder names.

To use compressed folders, either jam-zcat or jka-compr is required."))
  :type '(choice (const nil) (const jam-zcat))
  :group 'cmail-all-variables
  :group 'cmail-archive)

(defvar *cmail-crash-box "~/cmail.crash" "$B%/%i%C%7%e%U%!%$%k(B.")

(cmail-i18n-defcustom cmail-folder-modes 384
  ((ja_JP . "\
$B%U%)%k%@$N%Q!<%_%C%7%g%s(B($B%G%U%)%k%H%b!<%I(B 0600 octal)")
   (en_US . "\
File permission mode for folders. (Default 0600 octal)"))
  :type 'integer
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-save-to cmail-path
  ((ja_JP . "\
*$BJQ49$7$?%a%$%k$d%U%)%k%@$r%;!<%V$9$k@h$N%G%#%l%/%H%j(B.

$B:G8e$OI,$:%9%i%C%7%e(B/$B$G=*$o$k(B.")
   (en_US . "\
*Directory where converted messages and/or folders are saved.

The directory name must end with '/' (slash)"))
  :type 'string
  :group 'cmail-all-variables
  :group 'cmail-directories)

(cmail-i18n-defcustom cmail-work-dir cmail-path
  ((ja_JP . "\
*cmail-pipe$B$r<B9T$9$k%G%#%l%/%H%j(B.")
   (en_US . "\
*Directory where a shell command is executed by cmail-pipe"))
  :type 'string
  :group 'cmail-all-variables
  :group 'cmail-directories)

(cmail-i18n-defcustom cmail-addresses "~/.addresses"
  ((ja_JP . "\
*$B%f!<%6$NJd40MQ%"%I%l%9%U%!%$%k(B.

$B=q<0$O(B,

	E-mail-address	Comment

$B$N(B, $BMeNs$G$"$k(B. Comment$B$O;2>H$7$J$$(B.")
   (en_US . "\
*Address file name for the address completion feature.

Format shall be repeat of the following line:

        E-mail-address  Comment

Comment is ignored."))
  :type 'string
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-ok-if-backup-exists "DELETE"
  ((ja_JP . "\
*\"OK\"$B$N>l9g(B, cmail$B$rN)$A>e$2$k;~$K%P%C%/%"%C%W$,$"$C$F$b>C5n$7$J$$(B.

\"DELETE\"$B$N>l9g$O(B, $B<+F0E*$K>C5n$9$k(B. nil$B$N>l9g$O>C5n$N3NG'$r9T$J$&(B.")
   (en_US . "\
*If \"OK\", cmail will not delete backup folder files when starting up.

If \"DELETE\", cmail automatically deletes backup folder files.
If nil, cmail prompts for confirmation before deleting the files."))
  :type 'string
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-query-delete nil
  ((ja_JP . "\
*non-nil$B$N$H$-(B, $B%a%$%k$r:o=|$9$k:]$K0l$D0l$D3NG'$r9T$J$&(B.")
   (en_US . "\
*Non-nil means prompt for confirmation for each message deletion."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-query-save-folder nil
  ((ja_JP . "\
*non-nil$B$N$H$-(B, $B%U%)%k%@$r%;!<%V$9$k:]$K0l$D0l$D3NG'$r9T$J$&(B.")
   (en_US . "\
*Non-nil means prompt for confirmation for each folder saving."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-check-virtual-folder-on-clean t
  ((ja_JP . "\
*non-nil$B$N;~(B, virtual-folder$B$N:o=|$N;~(B, $B%a%$%k$,$"$l$P3NG'$r$H$k(B.")
   (en_US . "\
*Non-nil means prompt user before deleting non-empty virtual folder."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-print-proc (lambda ()
			      (shell-command-on-region 
			       (point-min) (point-max) cmail-print-command t))
  ((ja_JP . "\
*$B0u:~MQ4X?t(B. cmail-print$B$G;HMQ$9$k(B.")
   (en_US . "\
*Function to be used for printing. Used by cmail-print."))
  :type '(choice function (const nil))
  :group 'cmail-all-variables
  :group 'cmail-printing)

(cmail-i18n-defcustom cmail-print-command "expand|fold -80|pr -w80 -l66 -h 'cmail-printings'|expand|jc -e|jtops -vg|lpr -P$PRINTER"
  ((ja_JP . "\
*$B0u:~%3%^%s%I(B. cmail-print-proc$B$G;HMQ$9$k(B.")
   (en_US . "\
*Shell command for printing. Used by cmail-print-proc."))
  :type 'string
  :group 'cmail-all-variables
  :group 'cmail-printing)

(cmail-i18n-defcustom cmail-highlight-mode window-system
  ((ja_JP . "\
*non-nil$B$N;~(B, $B%a%C%;!<%8$N%O%$%i%$%H5!G=$r;HMQ$9$k(B.")
   (en_US . "\
*Non-nil means use highlight in message display."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(cmail-i18n-defcustom cmail-highlight-mouse nil
  ((ja_JP . "\
*$B%^%&%9%+!<%=%k$,%5%^%j9T$d%U%)%k%@L>$N0LCV$K$-$?$H$-$KIU2C$9$k(Bface.")
   (en_US . "\
*face to add when mouse cursor moved over summary line/folder name."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(cmail-i18n-defcustom cmail-cite-regexp
  "^\\(In article\\|In message\\|[ \t]*\\w*[]>}|]\\).*$"
  ((ja_JP . "\
*$B%O%$%i%$%H5!G=;HMQ;~$K$*$1$k0zMQItJ,<1JL$N$?$a$N@55,I=8=(B.")
   (en_US . "\
*Regular expression to identify message part for highlight."))
  :type 'regexp
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(defvar cmail-highlight-attribute-alist
  '((cmail-header-from-face          "blue"          nil       nil nil)
    (cmail-header-subject-face       "tomato"        nil       nil nil)
    (cmail-header-date-face          "DodgerBlue"    nil       nil nil)
    (cmail-header-to-cc-face         "black"         nil       nil nil)
    (cmail-header-name-face          "green4"        nil       t   nil)
    (cmail-header-content-face       "grey50"        nil       nil t  )
    (cmail-header-separator-face     "black"         "tan"     nil nil)
    (cmail-cite-face                 "SteelBlue"     nil       nil nil)
    (cmail-summary-mode-seen-face    "grey50"        nil       nil nil)
    (cmail-summary-mode-hold-face    "ForestGreen"   nil       nil nil)
    (cmail-summary-mode-reply-face   "DodgerBlue"    nil       nil nil)
    (cmail-summary-mode-unread-face  "blue"          nil       nil nil)
    (cmail-summary-mode-marked-face  "black"         nil       nil nil)
    (cmail-summary-mode-edited-face  "DarkOrchid"    nil       nil nil)
    (cmail-summary-mode-delete-face  "firebrick"     nil       nil nil)
    (cmail-summary-mode-current-face "black"         "skyblue" t   nil)
    (cmail-folders-mode-dir-face     "DarkSlateBlue" nil       nil nil))
  "*face$BL>(B, $BI=LL?'(B, $BGX7J?'(B, bold$B$d(Bitalic$B$r;HMQ$9$k$+$I$&$+$N(Bface alist.

$B%G%U%)%k%HCM$O0J2<$N$H$*$j(B.

        FACE $BL>(B                   $BI=LL?'(B          $BGX7J?'(B       BOLD ITALIC
((cmail-header-from-face          \"blue\"          nil          nil  nil)
 (cmail-header-subject-face       \"tomato\"        nil          nil  nil)
 (cmail-header-date-face          \"DodgerBlue\"    nil          nil  nil)
 (cmail-header-to-cc-face         \"black\"         nil          nil  nil)
 (cmail-header-name-face          \"green4\"        nil          t    nil)
 (cmail-header-content-face       \"grey50\"        nil          nil  t  )
 (cmail-header-separator-face     \"black\"         \"tan\"        nil  nil)
 (cmail-cite-face                 \"SteelBlue\"     nil          nil  nil)
 (cmail-summary-mode-seen-face    \"grey50\"        nil          nil  nil)
 (cmail-summary-mode-hold-face    \"ForestGreen\"   nil          nil  nil)
 (cmail-summary-mode-reply-face   \"DodgerBlue\"    nil          nil  nil)
 (cmail-summary-mode-unread-face  \"blue\"          nil          nil  nil)
 (cmail-summary-mode-marked-face  \"black\"         nil          nil  nil)
 (cmail-summary-mode-edited-face  \"DarkOrchid\"    nil          nil  nil)
 (cmail-summary-mode-delete-face  \"firebrick\"     nil          nil  nil)
 (cmail-summary-mode-current-face \"black\"         \"skyblue\"    t    nil)
 (cmail-folders-mode-dir-face     \"DarkSlateBlue\" nil          nil  nil))

$B$b$7(B, $BGX7J?'$,0E$$G[?'$G$"$k>l9g(B, $B%G%U%)%k%HCM$NBe$j$K0J2<$NCM$r(B
$B;n$9$HNI$$$+$bCN$l$J$$(B.

        FACE $BL>(B                   $BI=LL?'(B           $BGX7J?'(B       BOLD ITALIC
((cmail-header-from-face          \"SpringGreen\"    nil          nil  nil)
 (cmail-header-subject-face       \"tomato\"         nil          nil  nil)
 (cmail-header-date-face          \"LightSteelBlue\" nil          nil  nil)
 (cmail-header-to-cc-face         \"white\"          nil          nil  nil)
 (cmail-header-name-face          \"SeaGreen3\"      nil          t    nil)
 (cmail-header-content-face       \"grey80\"         nil          nil  t  )
 (cmail-header-separator-face     \"white\"          \"tan\"        nil  nil)
 (cmail-cite-face                 \"pink\"           nil          nil  nil)
 (cmail-summary-mode-seen-face    \"grey80\"         nil          nil  nil)
 (cmail-summary-mode-hold-face    \"pink\"           nil          nil  nil)
 (cmail-summary-mode-reply-face   \"LightSteelBlue\" nil          nil  nil)
 (cmail-summary-mode-unread-face  \"yellow\"         nil          nil  nil)
 (cmail-summary-mode-marked-face  \"skyblue\"        nil          nil  nil)
 (cmail-summary-mode-edited-face  \"green\"          nil          nil  nil)
 (cmail-summary-mode-delete-face  \"white\"          nil          nil  nil)
 (cmail-summary-mode-current-face \"green\"          \"DimGrey\"    t    nil)
 (cmail-folders-mode-dir-face     \"cyan\"           nil          nil  nil))"
)

(defvar cmail-inbox-folder "INBOX"
  "*$B4pK\E*%U%)%k%@(B.")

(cmail-i18n-defcustom cmail-query-limit-except-inbox-folder nil
  ((ja_JP . "\
*$BI=<($9$k>e8B$N%a!<%k?t$r(BINBOX$B%U%)%k%@I=<(;~$K?R$M$k$+$I$&$+(B.

Non-nil$B$N$H$-(B, cmail-inbox-folder $B$K0\F0$9$k:]!"(Bcmail-large-folder
$B$N@_DjCM0J>e$N%a%$%k$,$"$C$F$b(B limit $B$r?R$M$J$$(B.")
   (en_US . "\
*Non-nil means do not prompt for upper limit when displaying INBOX.

Usually if a folder contains more messages than number specified by
cmail-large-folder, when the folder is visited, cmail prompts for upper
limit of messages to disaply. The INBOX folder is handled differently
if this value is non-nil, it displays all messages without querying the
uppler limit."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-summary)

(defvar cmail-current-folder cmail-inbox-folder
  "$B;HMQCf%U%)%k%@(B.")

(cmail-i18n-defcustom cmail-spool-directory rmail-spool-directory
  ((ja_JP . "\
*$B%a%$%k$N%9%W!<%k%G%#%l%/%H%j(B.")
   (en_US . "\
*Mail spool directory to be used to construct default spool file name." ))
  :type 'string
  :group 'cmail-all-variables
  :group 'cmail-directories)

(cmail-i18n-defcustom cmail-mail-spools nil
  ((ja_JP . "\
*$B%a%$%k$N%9%W!<%k%U%!%$%k(B($B$^$?$O(BPOP$B%5!<%P(B).

POP $B%5!<%P>pJs$O<!$N%U%)!<%^%C%H$G$9(B.

(\"po:POP$B%"%+%&%s%HL>(B\" \"$B%a%$%k%[%9%HL>(B\" \"$B%*%W%7%g%s(B\" \"$B%Q%9%o!<%I(B\")")
   (en_US . "\
*List of mail spool file names, and/or POP account information.

POP account information is the following format:

(\"po:account\" \"PPP-host\" \"movemail-options\" \"password\")"))
  :type '(choice (const nil)
		 string
		 (repeat (choice string
				 sexp)))
  :group 'cmail-all-variables
  :group 'cmail-directories)

;;; cmail-spool-directory->cmail-mail-spools$B0\9TMQ$N%3!<%I(B
;;; $B>-Mh:o=|$5$l$k(B($B$O$:(B)
(and (null cmail-mail-spools)
     (listp cmail-spool-directory)
     (setq cmail-mail-spools cmail-spool-directory)
     (setq cmail-spool-directory nil))
(and (null cmail-mail-spools)
     (stringp cmail-spool-directory)
     (string-match "^po:" cmail-spool-directory)
     (setq cmail-mail-spools (list cmail-spool-directory))
     (setq cmail-spool-directory nil))

(defvar cmail-cursor-fast t
  "*$B%5%^%j$G$N%+!<%=%k0\F0$N%9%T!<%I(B. non-nil$B$N>l9g$OAGAa$$%+!<%=%k0\F0(B
$B$N4X?t$r%P%$%s%I$9$k(B.")

(defvar cmail-broken-cursor nil
  "*$B%U%)%k%@$r3+$$$?;~!$%+!<%=%k$N0LCV$,$:$l$k%P%0$KEv$?$C$?;~$K$O$3$NCM$r(Bt$B$K$9$k(B.")

(cmail-i18n-defcustom cmail-large-folder 50
  ((ja_JP . "\
*$BBg$-$J%U%)%k%@$G$"$k$H8+$J$9?t(B.

$B%U%)%k%@Fb$N%a!<%k$N?t$,$3$NCM$h$jBg$-$$;~$K$OI=<(?t$N3NG'$,9T$J$o$l$k(B.")
   (en_US . "\
*Number of messages a folder is considered a 'large folder'.

If the number of messages in a folder exceeds this number, when visiting
the large folder, cmail will prompt for upper limit to display."))
  :type 'integer
  :group 'cmail-all-variables
  :group 'cmail-summary)
  
(defvar cmail-incoming-mails-folder ".BACKUP"
  "* cmail$B$r5/F0$7$F$+$i!$<u$1<h$C$?%a%$%k$N%3%T!<$r3JG<$9$k%U%)%k%@L>!%(B

nil$B$N;~$O%3%T!<$7$J$$!%(Bcmail$B=*N;;~$K<+F0E*$K:o=|$5$l$k!%(B%$B$G;O$^$kL>A0$K(B
$B$9$k$H(Bcmail$B5/F0;~$K<+F0E*$K:o=|$5$l$k(B(cmail-ok-if-backup-exists$B$,@_Dj(B
$B$5$l$F$$$k;~(B)$B$N$GHr$1$?J}$,NI$$(B($B5$$,$9$k(B)")

(cmail-i18n-defcustom cmail-backup-version nil
  ((ja_JP . "\
*$B%U%)%k%@$r%;!<%V$9$k;~$KJ]B8$9$k%P!<%8%g%s$N?t(B.

nil$B$N>l9g$O(B1$B@$Be$N%P%C%/%"%C%W$r:n@.$9$k(B. ($B>\$7$/$O(B save-buffer $B$H(B
version-control $B$N@bL@$r;2>H(B.) 0$B$K$9$l$P%P%C%/%"%C%W$r9T$J$o$J$$(B.")
   (en_US . "\
*The number of backup file versions to preserve when saving folders.

If this is nil, only one backup file is created. (Please refer to
save-buffer and version-control documentaion for file version concept.)
If the value is 0, no backup file will be taken."))
  :type '(choice integer (const nil))
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-ignored-headers
  "^From \\|^X-cmail\\|^Received:\\|^Return-Path:\\|^Return-Receipt-To:\\|^Message-ID:\\|^Errors-To:\\|^References:\\|^Sender:\\|^Lines:\\|Status:\\|Replied:"
  ((ja_JP . "\
*$BI=<($7$J$$%X%C%@$r<($9@55,I=8=(B.")
   (en_US . "\
*Regular expression that matches message headers not to display."))
  :type 'regexp
  :group 'cmail-all-variables
  :group 'cmail-readmail)

(cmail-i18n-defcustom cmail-always-shown-headers "^$"
  ((ja_JP . "\
*$B>o$KI=<($5$l$k%X%C%@$r<($9@55,I=8=(B.")
   (en_US . "\
*Regular expression that matches message headers to always display"))
  :type 'regexp
  :group 'cmail-all-variables
  :group 'cmail-readmail)

(defvar *cmail-show-all-headers nil
  "Non-nil $B$N>l9g(B, $B%X%C%@$rA4$FI=<($9$k(B.")

(defvar *cmail-have-all-headers nil)

(cmail-i18n-defcustom cmail-reply-heading-format
  "\nIn message \"%S\"\n    on %D, %n <%a> writes:\n"
  ((ja_JP . "\
*reply $B;~$N0zMQIt$N@hF,$K$D$/%X%C%@$N%U%)!<%^%C%H$^$?$O4X?t(B.

nil $B$N>l9g$OI=<($r9T$J$o$J$$(B. $B%U%)!<%^%C%H$K4X$9$k5-=R$OJQ?t(B
cmail-summarize-format $B$r;2>H$N$3$H(B.

S	: $B%5%V%8%'%/%H(B
s	: $B%5%V%8%'%/%H(B(\"Re: \"$B$,IU$$$F$$$J$$$b$N(B)
d	: $BF|IU(B
D	: $BF|IU(B($BNc(B 92/11/01)
n	: $BL>A0(B
l	: $B%m%0%$%sL>(B($BNc(B hayasima)
a	: $B%"%I%l%9(B($BNc(B hayasima@opal.esi.yamanashi.ac.jp)

$B$3$NJQ?t$NCM$,J8;zNs$G$J$/4X?t$G$"$C$?>l9g$K$O$=$N4X?t$,8F$S=P$5$l$k(B.
$B30It%Q%C%1!<%8(B (super-cite $BEy(B)$B$r;HMQ$9$k>l9g$O;HMQ$5$l$J$$(B.")
   (en_US . "\
*Format string or function that returns string for citation header.

When nil, no header is attached. Please refer to cmail-summarize-format
for more description regarding the format string.

S       : Subject
s       : Subject (After \"Re: \" is removed)
d       : Date
D       : Date (example 92/11/01)
n       : name
l       : login name (example hayasima)
a       : address (example hayasima@opal.esi.yamanashi.ac.jp)

If this variable is a function instead of a string, the function will
be called. This variable would not be used if other add-on package for
citation such as super-cite is used."))
  :type '(choice string function)
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-replyaddress-without-quoted-name t
  ((ja_JP . "\
*$BJV?.$9$k;~$K(B($BL>A0$J$I$r=|$$$?(B)$B%"%I%l%9$N$_$r%3%T!<$9$k$+(B.

non-nil$B$N;~!"(Breply$B;~$K(BTo:$B%U%#!<%k%I$K$O%"%I%l%9$@$1$r4^$a!"L>A0$J$I$O(B
$B:o=|$9$k(B.  nil$B$N;~$O85%a!<%k$K$"$kL>A0$J$I$N>pJs$r;D$9$,!"(Bsendmail.el
$B$N;EMM$K=>$($P!"$3$l$O@5$7$/$J$$F0:n$G$"$j!"%"%I%l%9$K$h$C$F$OIT6q9g$r(B
$B@8$:$k(B.")
   (en_US . "\
*Use fully qualified email addresses only when replying a message

When non-nil, only the fully qualified email adderesses are copied
into To: or CC: field from the original message upon cmail-reply
command. Extra informational parts like name strings will be removed.
If this is nil, the extra information will be included, which may or
may not cause a problem in processing the reply message because the
lisp library cmail uses to send it to the network does not expect such
extra information string in the address fields."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-unify-multi-re t
  ((ja_JP . "\
*$B%5%V%8%'%/%H$NJ#?t$N(B Re $B$r$R$H$D$K$^$H$a$k$+(B")
   (en_US . "\
*Whether to unify multiple Re in the Subject field."))
  :type '(choice (const :tag "Unify" t) (const :tag "As is" nil))
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

;; --- Copied from rmail.el ---
;; Some mailers use "Re(2):" or "Re^2:" or "Re: Re:" or "Re[2]:".
;; This pattern should catch all the common variants.
(cmail-i18n-defcustom cmail-re-regexp "\\`\\(Re\\(([0-9]+)\\|\\[[0-9]+\\]\\|\\^[0-9]+\\)?: *\\)+"
  ((ja_JP . "\
*Re: $B$r$D$1$kA0$K:o=|$9$kJ8;zNs$K%^%C%A$9$k@55,I=8=(B.")
   (en_US . "\
*Regular expression that matches subject string to be removed."))
  :type 'regexp
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-remove-re nil
  ((ja_JP . "\
*Non-nil $B$N;~(B, $B%5%V%8%'%/%H$K(B Re: $B$rIU$1$J$$(B. Re: $B$,$"$C$?$i:o$k(B.")
   (en_US . "\
*Non-nil means do not attach Re: to subject. Remove if present."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(defvar cmail-current-point-mark t
  "*Non-nil$B$N;~(B, $BI=<(Cf$N%a%$%k$N%$%s%G%C%/%9$r;X$9%^!<%/$r$D$1$k(B.")

(cmail-i18n-defcustom cmail-mark-delete-show-next nil
  ((ja_JP . "\
*non-nil$B$N;~(B, D$B%^!<%/$r$D$1$?;~<!%a!<%k$,L$FI$G$"$l$P$=$l$rI=<($9$k(B.")
   (en_US . "\
*Non-nil means that after deletion display the next message if unread."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-summary)

(cmail-i18n-defcustom cmail-display-thread t
  ((ja_JP . "\
*$B%9%l%C%II=<($r$9$k$+$I$&$+(B.")
   (en_US . "\
*Whether or not thread display is used."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-summary)

(cmail-i18n-defcustom cmail-thread-indent 2
  ((ja_JP . "\
*$B%9%l%C%II=<($N:]$N%$%s%G%s%HI}(B.")
   (en_US . "\
*Indent width in number of white space when displaying thread trees."))
  :type 'integer
  :group 'cmail-all-variables
  :group 'cmail-summary)

(cmail-i18n-defcustom cmail-thread-folder-regexp nil
  ((ja_JP . "\
*$B%9%l%C%II=<($NBP>]$H$J$k%U%)%k%@$N@55,I=8=(B.

nil $B$N>l9g$O(B cmail-display-thread $B$N@_Dj$K$9$Y$F$N%U%)%k%@$,=>$&(B.

ex.
  (setq cmail-display-thread t)
  (setq cmail-thread-folder-regexp \"^.*ml$\\\\|^ml/.*$\")

$B$3$N>l9g!":G8e$,(B ml $B$G=*$k%U%)%k%@L>$H3,AX%U%)%k%@(B ml $B$N2<$N(B
$B$9$Y$F$N%U%)%k%@$,(B thread $BI=<($NBP>]$H$J$k(B.")
   (en_US . "\
*Regular expression that matches the folder names to thread.

If this is nil, threading is performed according to cmail-display-thread.

ex.
  (setq cmail-display-thread t)
  (setq cmail-thread-folder-regexp \"^.*ml$\\\\|^ml/.*$\")

In this case, all folders that has ml at the tail, or all folders under
directory ml/ would be threaded."))
  :type '(choice (const nil) regexp)
  :group 'cmail-all-variables
  :group 'cmail-summary)


(cmail-i18n-defcustom cmail-thread-ignored-folder-regexp nil
  ((ja_JP . "\
*$B%9%l%C%II=<($NBP>]30$H$J$k%U%)%k%@$N@55,I=8=(B.

cmail-thread-folder-regexp $B$N@_Dj$KM%@h$9$k(B.
cmail-thread-folder-regexp $B$,(B nil $B$N>l9g!"(B
cmail-thread-ignored-folder-regexp $B$G$N@_DjCM$K(B
match $B$7$?%U%)%k%@0J30$,(B thread $BI=<($NBP>]%U%)%k%@$K$J$k(B.

ex.
  (setq cmail-display-thread t)
  (setq cmail-thread-folder-regexp nil)
  (setq cmail-thread-ignored-folder-regexp \"^INBOX$\\\\|^WORK$\")

$B$3$N>l9g!"(BINBOX $B$H(B WORK $B0J30$N$9$Y$F$N%U%)%k%@$,(B thread $BI=<($NBP>]$H$J$k(B.")
   (en_US . "\
*Regular expression that matches the folder names to NOT thread.

This has precedence to cmail-thread-folder-regexp. If
cmail-thread-folder-regexp is nil, all other folders than the folders
that matches this regular expression will be threaded.

ex.
  (setq cmail-display-thread t)
  (setq cmail-thread-folder-regexp nil)
  (setq cmail-thread-ignored-folder-regexp \"^INBOX$\\\\|^WORK$\")

In this case, all folders other than INBOX and WORK would be threaded."))
  :type '(choice (const nil) regexp)
  :group 'cmail-all-variables
  :group 'cmail-summary)

(cmail-i18n-defcustom cmail-thread-ignore-limit t
  ((ja_JP . "\
*$B%9%l%C%II=<($N:]$K%a%C%;!<%8?t$N>e8B@_Dj$rL5;k$9$k$+(B.")
   (en_US . "\
*Whether or not to ignore limit number of messages when threading."))
  :type '(choice (const :tag "Ignore" t) (const :tag "Don't Ignore" nil))
  :group 'cmail-all-variables
  :group 'cmail-summary)

(defvar cmail-thread-prepare-data-on-archive nil
  "auto-archive$B;~$K(Bthread$B%G!<%?$rM=$a:n@.$7$F$*$/$+$I$&$+(B.")

(cmail-i18n-defcustom cmail-window-size '(1 . 5)
  ((ja_JP . "\
*$B%5%^%j%P%C%U%!$N9T?t$H%a!<%kI=<(%P%C%U%!$N9T?t$N3d9g(B.

$B%a!<%kI=<(%P%C%U%!$N9T?t$r(Bnil$B$H$9$k$H%5%^%j%P%C%U%!$O$=$N9T?t$r3NJ]$9$k(B.")
   (en_US . "\
*Vertical window size ratio between summary and message view buffer.

If message view buffer size factor is nil, the summary buffer size factor
will be the actual size of the summary buffer window."))
  :type '(cons integer integer)
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(cmail-i18n-defcustom cmail-window-horizontal-size '(1 . 3)
  ((ja_JP . "\
*$B%U%)%k%@0lMw%P%C%U%!$NNs?t$H%5%^%j%P%C%U%!$NNs?t$N3d9g(B.

$B%U%)%k%@0lMw%P%C%U%!$NNs?t$r(Bnil$B$H$9$k$H%5%^%j%P%C%U%!$O$=$NNs?t$r3NJ]$9$k(B.")
   (en_US . "\
*Horizontal window size ratio between folders list and summary buffer.

If the folders list buffer size factor is nil, the summary buffer size
factor will be the actual size of the summary buffer window."))

  :type '(cons integer integer)
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(cmail-i18n-defcustom cmail-use-full-window t
  ((ja_JP . "\
*Non-nil$B$N>l9g(B, cmail$B$,A42hLL$r;H$&(B.")
   (en_US . "\
*Cmail will use the entire frame if this variable is non-nil."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(cmail-i18n-defcustom cmail-summarize-format nil
  ((ja_JP . "\
*$B%5%^%j%b!<%I$G$N%5%^%j$N%U%)!<%^%C%H$r;XDj$9$kJ8;zNs(B.

nil $B$N>l9g$O(B, $BI8=`$NI=<(%U%)!<%^%C%H$r:NMQ$9$k(B($BI=<(B.EY$,B.$/$J$k(B).
$BI8=`%U%)!<%^%C%H$N7A<0$O(B\"%d [%-17n] %I%j\n\"$B$G$"$k(B.

p	: $B%Z!<%8HV9f(B
s	: $B%9%F%$%?%95-9f(B(Active $B$O%9%Z!<%9$GI=<((B)
S	: $B%9%F%$%?%95-9f(B
n	: $BL>A0(B
a	: $B%"%I%l%9(B
j	: $B%5%V%8%'%/%H(B
l	: $B%a%$%k$N9T?t(B($B8E$$%U%)!<%^%C%H$N>l9g$O(B0)
I	: thread$BI=<($N%$%s%G%s%H(B

%$B$KB3$$$F?tCM$r=q$$$F$*$/$H$=$N7e?tFb$K6/@)E*$KJ8;zNs$r<}$a$k(B.
$BB($A(B, $B%"%I%l%9$,(B\"hayasima\"$B$G(B, $BL>A0$,(B\"Macot HAYASHI\"$B$N>l9g(B,
\"<%:-10a> (%:10n)\"$B$O(B,
	\"<  hayasima> (Macot HAYA)\"
$B$K$J$k(B.

$B$3$NJQ?t$NCM$,J8;zNs$G$J$/4X?t$G$"$k;~$K$O$=$N4X?t$r8F$S=P$9(B.")
   (en_US . "\
*Format string for summary line in summary mode.

When nil, the standard format will be used, in which case display speed
is relatively faster. The standard format is \"%d [%-17n] %I%j\n\".

p	: Page number
s	: Message status (Active will be a space)
S	: Message status
n	: Sender name
a	: Sender address
j	: Subject
l	: Number of lines in message (0 in the old format)
I	: thread indent

The number immediately after % specifies a fixed string width. For
example, the sender address is \"hayasima\" and the sender name is
\"Macot HAYASHI\", using a format string \"<%:-10a> (%:10n)\" would
result in \"<  hayasima> (Macot HAYA)\"."))
  :type '(choice (const nil) string)
  :group 'cmail-all-variables
  :group 'cmail-summary)

(cmail-i18n-defcustom cmail-summarize-format-alist nil
  ((ja_JP . "\
*$B%U%)%k%@Kh$K%5%^%j$N%U%)!<%^%C%H$r;XDj$9$k(B.

     '((folder . format) ...)

$B$H$$$&7A<0$G;XDj$9$k!%(B")
   (en_US . "\
*Designate summary format per folder.

A list in form of:

     '((folder . format) ...)

is used to designate format per folder."))
  :type 'alist
  :group 'cmail-all-variables
  :group 'cmail-summary)

(cmail-i18n-defcustom cmail-use-X-Nsubject t
  ((ja_JP . "\
*X-Nsubject$B%U%#!<%k%I$r%5%V%8%'%/%H$H8+$J$9(B(Subject$B$h$jM%@h$9$k(B).")
   (en_US . "\
*Use X-Nsubject field as the actual subject. (Precedes to subject)"))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-summary)

(cmail-i18n-defcustom cmail-forwarded-mail-border-cons
  '("------- Start of forwarded message -------\n" .
    "------- End of forwarded message -------\n")
  ((ja_JP . "\
*$B%a!<%k$r%U%)%o!<%I$9$k;~$KA^F~$9$k6-3&@~(B.")
   (en_US . "\
*Boundary strings to be inserted when forwarding a message."))
  :type '(cons string string)
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-rfc934-forwarding t
  ((ja_JP . "\
*RFC-934$B$K=>$$(B, $B9TF,$N(B\"--\"$B$r(B\"- -\"$B$KJQ49$9$k(B.

RFC-934 $B$OJ#?t$N%a!<%k$rJL$N%a!<%k$KE:IU$7I|85$9$k$?$a$NJ}K!$rDj5A(B
$B$7$F$$$k(B. MIME $B$,;HMQ$G$-$k4D6-$G$O(B MIME $B$K$h$kE>Aw$,$h$jE,Ev(B.")
   (en_US . "\
*Convert \"--\" at the beginning of line to \"- -\" per RFC-934.

RFC-934 specifies a rule to encapsulate a message within another
message.  When MIME is supported, it is more appropriate to use MIME
for message encapsulation."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-mime-forwarding t
  ((ja_JP . "\
*MIME $B7A<0$G%U%)%o!<%I$r9T$&(B.

non-nil $B$+$D(B cmail-use-mime $B$,(B non-nil $B$N;~$N$_M-8z(B.")
   (en_US . "\
*Forward using MIME facility.

Effective only if cmail-use-mime is non-nil."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-mime
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-make-References-header t
  ((ja_JP . "\
*non-nil $B$N>l9g(B, $B%X%C%@(BReferences$B$r;HMQ$9$k(B.")
   (en_US . "\
*Non-nil means use References: header."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-complete-header-regexp "^\\(To\\|From\\|Cc\\|Bcc\\|Reply-To\\|Return-Receipt-To\\):"
  ((ja_JP . "\
*$B%"%I%l%9Jd40$r9T$J$&%U%#!<%k%I$r;XDj$9$k@55,I=8=(B.")
   (en_US . "\
*Regexp that matches header fields where address completion is done."))
  :type 'regexp
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-use-visiting-parent-dir-as-quit nil
  ((ja_JP . "\
*$B%U%)%k%@0lMw%5%V%G%#%l%/%H%j$G(B quit $B$7$?$H$-$N5sF0(B.")
   (en_US . "\
*Behavior when quit from a subdirectory in folders mode."))
  :type '(choice (const :tag "Return To Upper Directory" t)
		 (const :tag "Quit Folders Mode" nil))
  :group 'cmail-all-variables
  :group 'cmail-folders)

(cmail-i18n-defcustom cmail-always-display-folders (if cmail-use-full-window 'auto nil)
  ((ja_JP . "\
*$B%U%)%k%@0lMw%b!<%I$r>o;~I=<($9$k$+$I$&$+(B.")
   (en_US . "\
*Whether or not folders list mode is always displayed."))
  :type '(choice (const :tag "Always display" t)
		 (const :tag "Based on window size" auto)
		 (const :tag "Don't display" nil))
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(cmail-i18n-defcustom cmail-always-display-folders-threshold 100
  ((ja_JP . "\
*$B%U%)%k%@0lMw$N>o;~I=<($r9T$&$+$I$&$+$N%&%#%s%I%&I}$N$7$-$$CM(B.

cmail-always-display-folders$B$K(B'auto (based on window size)$B$r;XDj(B
$B$7$?>l9g$K$N$_M-8z!#(B")
   (en_US . "\
*Threshold size of frame to display folders list buffer.

Effective only when cmail-always-display-folders is set to 'auto
(based on window size)."))
  :type 'integer
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(cmail-i18n-defcustom cmail-use-folders-mode-first t
  ((ja_JP . "\
*$B%U%)%k%@0lMw%b!<%I$+$i5/F0$9$k$+$I$&$+(B.")
   (en_US . "\
*Start up from folders list mode."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-startup)

(cmail-i18n-defcustom cmail-folders-unfold-dirs '()
  ((ja_JP . "\
*$BE83+$9$k%G%#%l%/%H%j$N%j%9%H(B ($B=*C<$K(B`/'$B$,I,MW(B).

$BNc(B: (setq cmail-folders-unfold-dirs (\"DIR1/\" \"DIR1/DIR2/\" \"DIR3/\"))")
   (en_US . "\
*List of dirs in which folder names are expanded in folders mode.

ex: (setq cmail-folders-unfold-dirs (\"DIR1/\" \"DIR1/DIR2/\" \"DIR3/\"))"))
  :type '(repeat string)
  :group 'cmail-all-variables
  :group 'cmail-folders)

(cmail-i18n-defcustom cmail-folders-list-top (list cmail-inbox-folder)
  ((ja_JP . "\
*$B0lMw$N@hF,$K;}$C$F$/$k%U%)%k%@$N%j%9%H(B.")
   (en_US . "\
*List of folders placed at the top of folders mode buffer."))
  :type '(repeat string)
  :group 'cmail-all-variables
  :group 'cmail-folders)


(cmail-i18n-defcustom cmail-folders-list-bottom '()
  ((ja_JP . "\
*$B0lMw$N=*C<$K;}$C$F$/$k%U%)%k%@$N%j%9%H(B.")
   (en_US . "\
*List of folders placed at the bottom of folders mode buffer."))
  :type '(repeat string)
  :group 'cmail-all-variables
  :group 'cmail-folders)

(cmail-i18n-defcustom cmail-folders-display-all-folders t
  ((ja_JP . "\
*nil$B$N;~L$FI%a!<%k$N$J$$%U%)%k%@$rI=<($7$J$$(B")
   (en_US . "\
*Always display all folders regardless unread messages in folders mode.

If this variable is nil, only folders that contain unread messages
will be disaplayed in the folders mode buffer."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-folders)

(cmail-i18n-defcustom cmail-folders-display-unread-mails nil
  ((ja_JP . "\
*Non-nil$B$N;~(B, $B%U%)%k%@$N%a!<%k?t$H$7$FL$FI%a!<%k?t$rI=<($9$k(B.")
   (en_US . "\
*Non-nil means display number of unread msgs instead of total."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-folders)

(cmail-i18n-defcustom cmail-use-mime nil
  ((ja_JP . "\
*MIME $B$r07$&$+$I$&$+(B.

$BJLES(B MIME $B%Q%C%1!<%8$N%$%s%9%H!<%k$,I,MW(B.")
   (en_US . "\
*Use MIME option.

A compatible MIME package must be installed to turn on this option."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-mime
  :group 'cmail-envriron)

(cmail-i18n-defcustom cmail-mime-decode nil
  ((ja_JP . "\
*MIME $B%a!<%k$r%G%3!<%I$9$k$+$I$&$+(B.")
   (en_US . "\
*Whether to decode MIME message."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-mime
  :group 'cmail-envriron)

(cmail-i18n-defcustom cmail-mime-encode nil
  ((ja_JP . "\
*MIME $B%a!<%k$r%(%s%3!<%I$9$k$+$I$&$+(B.")
   (en_US . "\
*Whether to encode MIME message."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-mime
  :group 'cmail-envriron)

(defvar cmail-content-filter-function
  'cmail-default-content-filter "for cmail-mime")

(if (null cmail-use-mime)
    nil
  (setq cmail-mime-decode t)
  (setq cmail-mime-encode t))

(cmail-i18n-defcustom cmail-delete-file-after-conversion nil
  ((ja_JP . "\
*$BJQ49A0$N(Bmbox$B$^$?$O(BRMAIL$B7A<0$N%U%!%$%k$r:o=|$9$k(B.")
   (en_US . "\
*Delete mbox or RMAIL files after conversion."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-use-mailcrypt nil
  ((ja_JP . "\
*PGP$B%a!<%k$r07$&$+$I$&$+(B.

$BJLES(B PGP $B%Q%C%1!<%8$N%$%s%9%H!<%k$,I,MW(B.")
   (en_US . "\
*Use PGP feature.

A compatible PGP package must be installed to turn on this option."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-other-features
  :group 'cmail-envriron)

(cmail-i18n-defcustom cmail-use-send-mail-archive nil
  ((ja_JP . "\
*$BAw?.$7$?%a%$%k$N%m%0$r;XDj$7$?%U%)%k%@$K;D$9$+$I$&$+(B.")
   (en_US . "\
*Whether to store sent messages in a specified 'archive' folder."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(autoload 'cmail-archive "cmail-archive" nil t)

(cmail-i18n-defcustom cmail-mail-callback t
  ((ja_JP . "\
*$B%5%^%j$N%j%W%i%$%^!<%/(B(R)$B$r$I$N%?%$%_%s%0$G$D$1$k$+(B.

t $B$GAw=P;~!"(Bnil $B$G%3%^%s%I$r<B9T$7$?;~(B.")
   (en_US . "\
*When message status is changed to replied (R) in summary mode.

It will be done when message is sent if this variable is set to t, or
when reply command is invoked in summary mode."))
  :type '(choice (const :tag "When sent" t) (const :tag "When invoked" nil))
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-rename-sent-mail-buffer nil
  ((ja_JP . "\
*non-nil$B$N$H$-(B, $BAw?.:Q$_%a!<%k%P%C%U%!$N%P%C%U%!L>$rJQ99$9$k(B.")
   (en_US . "\
*Non-nil means the mail buffer is renamed after sending message."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-sendmail)

(cmail-i18n-defcustom cmail-max-crash-box-size nil
  ((ja_JP . "\
$B@0?tCM$N$H$-(B, $B%/%i%C%7%e%\%C%/%9$N%5%$%:$,;XDjCM$rD6$($k$H7Y9p$r=P$9(B.")
   (en_US . "\
If integer, cmail warns when crash box size exceeds this value."))
  :type '(choice integer (const :tag "Disabled" nil))
  :group 'cmail-all-variables
  :group 'cmail-archive)

(cmail-i18n-defcustom cmail-i18n-message t
  ((ja_JP . "\
*$B%a%C%;!<%8$N8@8l$r<+F0E*$K@Z$jBX$($k$+$I$&$+(B. load $B;~$N$_M-8z(B.

Emacs 20.3 $B0J9_$^$?$O(B XEmacs $B$G(B current-language-environment
$B$K=>$C$F@ZBX$($k(B. nil $B$N>l9g$O>o$K1Q8l$N%a%C%;!<%8$K$J$k(B. 
$B8=:_$O(B current-language-environment $B$,(B \"Japanese\" $B$N$H$-$OF|K\8l$K!"(B
$B$=$l0J30$N$H$-$O1Q8l$K$J$k(B.

$BJQ99$O0lC6(B Emacs $B$r=*N;$7:F%m!<%I$r9T$&;v$K$h$jM-8z$K$J$j$^$9(B.")
   (en_US . "\
*Non-nil means use user preferred language for messages if possible.

When non-nil, based on the Emacs variant, version and variable
current-language-environment content, use the user preferred language
for messages displayed in the echo area. When nil, cmail always use
messages in English. At this point, if current-language-environment
is set to \"Japanese\", cmail uses Japanese, otherwise uses English.

Change will take effect when Emacs is restarted.
"))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(cmail-i18n-defcustom cmail-i18n-doc-language 'ja_JP
  ((ja_JP . "\
*$B%*%W%7%g%sJQ?t%I%-%e%a%s%H$N8@8l$N;XDj(B.

$B%5%]!<%H$5$l$F$$$k8@8l(B: ja_JP, en_US")
   (en_US . "\
*Documentation language selection.

Currently supported languages are: ja_JP, en_US."))
  :type '(choice (const :tag "US English" en_US)
		 (const :tag "Japanese" ja_JP))
  :set 'cmail-i18n-set-doc-language
  :group 'cmail-all-variables
  :group 'cmail-display-style)

(cmail-i18n-defcustom cmail-sum-pop-up-menu-2
  '(("Mark" . cmail-mark)
    ("Mark Delete" . cmail-mark-delete)
    ("Mark Hold" . cmail-mark-hold)
    ("Unmark" . cmail-unmark)
    ""
    ("Reply" . cmail-reply)
    ("Follow-up" . cmail-follow-up)
    ("Forward" . cmail-forward))
  ((ja_JP . "\
*$B%5%^%j$GDL>o(B2$BHVL\$N%^%&%9%\%?%s(B($B%@%V%k%/%j%C%/(B)$B$N%]%C%W%"%C%W%a%K%e!<(B.

$B8=:_%+!<%=%k$N$"$k%a%C%;!<%8$,%a%K%e!<%?%$%H%k$KI=<($5$l$k(B.")
   (en_US . "\
*Pop-up menu which is usually assigned to 3rd mouse button.

Menu title will show the current message."))
  :type '(repeat (choice (cons string function) string))
  :group 'cmail-all-variables
  :group 'cmail-menu-style)

(cmail-i18n-defcustom cmail-sum-pop-up-menu-1
  `(,@(if running-xemacs
	  '(["Get New Message" cmail-summary-get-newmail t]
	    ["Folders List" cmail-folders t]
	    ["Expand Window" cmail-sum-mouse-expand t]
	    ["Archive" cmail-auto-archive t]
	    ["Expunge" cmail-execute-index t]
	    ["Save All" cmail-save-all-folders t]
	    "---"
	    ["Quit" cmail-summary-quit t])
	'(("Get New Message" . cmail-summary-get-newmail)
	  ("Folders List" . cmail-folders)
	  ("Expand Window" . cmail-sum-mouse-expand)
	  ("Archive" . cmail-auto-archive)
	  ("Expunge" . cmail-execute-index)
	  ("Save All" . cmail-save-all-folders)
	  ""
	  ("Quit" . cmail-summary-quit))))
  ((ja_JP . "\
*$B%5%^%j$GDL>o(B3$BHVL\$N%^%&%9%\%?%s$N%]%C%W%"%C%W%a%K%e!<(B.

$B8=:_$N%U%)%k%@!<L>$,%a%K%e!<%?%$%H%k$KI=<($5$l$k(B.")
   (en_US . "\
*Pop-up menu which is usually assigned to 3rd mouse button.

Menu title will show the current folder name."))
  :type '(repeat (choice (cons string function) string))
  :group 'cmail-all-variables
  :group 'cmail-menu-style)

(cmail-i18n-defcustom cmail-option-path-list
		      (list (concat
			     (file-name-directory (locate-library "cmail"))
			     "options/"))
  ((ja_JP . "\
*$B%*%W%7%g%s5!G=MQ$N%U%!%$%k$rCV$/%G%#%/%H%j!#(B")
   (en_US . "\
*A direcoty for files providing optional features."))
  :type '(repeat directory)
  :group 'cmail-all-variables
  :group 'cmail-directories)

(cmail-i18n-defcustom cmail-auth-file "~/.cmail-auth"
  ((ja_JP . "\
*POP$B$J$I$N%Q%9%o!<%I$rJ]B8$9$k%U%!%$%kL>!#(B

cmail-use-auth-file $B$,(B non nil $B$N;~$KM-8z$K$J$k!#(B")
   (en_US . "\
*Name of file to store password for mail retrieval protocol such as POP.

Used when cmail-use-auth-file is non nil."))
  :type 'directory
  :group 'cmail-all-variables
  :group 'cmail-directories)

(cmail-i18n-defcustom cmail-use-auth-file nil
  ((ja_JP . "\
*Non nil $B$N;~%Q%9%o!<%I$r(B cmail-auth-file $B$G;XDj$N%U%!%$%k$KJ]B8$9$k!#(B

$B%Y!<%9%7%9%F%`$,%U%!%$%k$N5v2D%b!<%I$r%5%]!<%H$7$F$$$J$$$H%U%!%$%k$O(B
$B:n@.$5$l$^$;$s!#(B")
   (en_US . "\
*Non nil means store passwords in a file specified by cmail-auth-file.

The system must support file permission mode to create the auth file."))
  :type 'boolean
  :group 'cmail-all-variables
  :group 'cmail-directories)


;; ==== $B:n6HMQJQ?t(B($B5Z$SDj?t(B) ====

(defvar *cmail-pagelist nil "$B%U%)%k%@Fb$N3FJG$r;X$9%^!<%+$N%j%9%H(B.")
(defvar *cmail-backuped nil "$B%U%)%k%@$N%P%C%/%"%C%W$,:n@.$5$l$?$+(B.")

(defvar *cmail-summary-limit nil
  "*$B%5%^%j$NI=<(5-;v?t(B. 0$B$^$?$O(Bnil$B$N>l9g$OEv3:5-;vA4$F$r%5%^%i%$%:$9$k(B.
$B@0?t$N>l9g$O$=$N5-;v?t$@$1%5%^%i%$%:$9$k(B.")

(defconst cmail-summary-regexp
  "^\\([0-9]+\\) \\(.\\) \\([0-9/]+\\) \\(.*\\) <\\([^<>]+\\)> \\([0-9]+\\) ?\\[\\(\\(R[Ee]: \\)*\\(.*\\)\\)\\]$"
  "$B%5%^%j$r2r@O$9$k;~$N9T$N@55,I=8=(B.
\"PAGE STATUS DATE NAME MAIL-ADDRESS LINES BEGINNING-OF-SUBJECT BOS SUBJECT\"$B$N=g(B.")

(defconst cmail-sort-key-alist '(("DATE" ."\\3")
				 ("NAME" ."\\4")
				 ("ADDRESS" ."\\5")
				 ("SUBJECT" ."\\7")
				 ("SUBJECT(relative)" ."\\9"))
  "$B%5%^%j$r%=!<%H$9$k;~$K;HMQ$9$k%-!<$NO"A[%j%9%H(B.")

(defvar *cmail-movemail-command "movemail" "*movemail$B$N%3%^%s%I(B.")

;; modified by himi to handle pop password
(defvar *cmail-pop-password nil "POP Password-nil$B$G$"$k$3$H$r6/$/?d>)(B")

(defvar *cmail-save-to-dir nil "$B%;!<%V@h$N%G%#%l%/%H%j$rJ];}$9$k(B.")

(defvar *cmail-save-to-name nil "$B%;!<%V@h$N%U%!%$%kL>$rJ];}$9$k(B.")

(defconst *cmail-border "\^_\^L"
  "$B%U%)%k%@$N%Z!<%86-3&J8;z(B.")

(defconst *cmail-decoded-border "^_^L"
  "border$B$N%G%3!<%I$5$l$?$b$N(B.")

(defconst *cmail-borderline (concat *cmail-border "\n")
  "$B%U%)%k%@$N%Z!<%86-3&J8;z(B. $B2~9T$r4^$`(B.")

(defconst *cmail-re-bdr (concat "^" *cmail-border)
  "$B%Z!<%86-3&J8;z$N@55,I=8=(B.")

(defconst *cmail-re-bln (concat *cmail-re-bdr "\n")
  "$B%Z!<%86-3&J8;z$N@55,I=8=$G(B, $B2~9T$r4^$`(B.")

(defconst *cmail-bln (concat "\n" *cmail-borderline)
  "$B%Z!<%86-3&8!:wMQ(B, $B2~9T$r4^$`(B.")

(defconst *cmail-new-arrivals-buffer " *cmail-new-arrivals*"
  "$B?7$7$$%a%$%k(B($B72(B)$B$rCy$a$k%P%C%U%!(B($B:n6HMQ(B).")

(defconst *cmail-arrived-mail-buffer " *cmail-arrived-mail*"
  "$B?7$7$$%a%$%k$r<}$a$k%P%C%U%!(B($B:n6HMQ(B).")

(defconst *cmail-folder-buffer-prefix " *cmail-folder-"
  "$B%U%)%k%@$NFbMF$r<}$a$k%P%C%U%!(B($B:n6HMQ(B)$B$N%W%l%U%#%C%/%9(B.")

(defconst *cmail-header-buffer-prefix " *cmail-header-"
  "$B%U%)%k%@$N%X%C%@$NFbMF$r<}$a$k%P%C%U%!(B($B:n6HMQ(B)$B$N%W%l%U%#%C%/%9(B.")

(defconst *cmail-summary-buffer "**cmail-summary**" "$B%5%^%jI=<(MQ%P%C%U%!(B.")

(defconst *cmail-mail-buffer "*cmail-mail*" "$B%a%$%kI=<(MQ%P%C%U%!(B.")

(defconst *cmail-index-buffer " *cmail-index*"
  "$B%$%s%G%C%/%9$r9=C[$9$k$?$a$N%P%C%U%!(B.")

(defconst *cmail-complete-address-buffer " *cmail-address*"
  "$B%"%I%l%9Jd40MQ%P%C%U%!(B.")

(defconst *cmail-reply-mail-buffer " *cmail-reply*"
  "$B%j%W%i%$%a%$%k$NFbMF$r3JG<$9$k%P%C%U%!(B.")

(defvar *cmail-last-opened-folder nil "$B:G8e$K(Bopen$B$7$?%U%)%k%@(B.")
(defvar *cmail-current-page 0 "$B8=:_I=<(Cf$N%a%$%k$N%Z!<%8?t(B($B:n6HMQ(B).")
(defvar *cmail-current-folder "" "$B8=:_I=<(Cf$N%a%$%k$N%U%)%k%@(B($B:n6HMQ(B).")
(defvar *cmail-opened-folders-list nil "$B;HMQ$7$?%U%)%k%@$N%j%9%H(B.")

(defconst *cmail-backup-prefix "%"
  "$B:o=|$5$l$?%U%)%k%@$N%P%C%/%"%C%W%U%!%$%k$N%W%l%U%#%C%/%9(B.")

(defconst *cmail-unknown-field-value "(nil)"
  "$B>JN,$J$I$K$h$C$FCM$N$J$$%X%C%@%U%#!<%k%I$NCM(B.")

(defvar *cmail-reply-info nil "reply$B;~$N%X%C%@$NJ8;zNs(B.")
(defvar *cmail-match-data nil "match-data$B$rJ];}$9$k(B.")

(defvar *cmail-file-coding-system '*noconv*)
(defvar *cmail-primary-coding-system '*junet*)

(defvar *cmail-reorder-folder "/ reorder" "$BJB$Y49$(MQ:n6H%U%)%k%@(B")

(defvar *cmail-folders-cache-alist nil
  "$B%U%)%k%@>pJs%-%c%C%7%e(B. $B%(%s%H%j$NFbMF$O0J2<$NDL$j(B:

$B!&%P%C%U%!$KJ];}$5$l$?%U%)%k%@(B
    (FOLDERNAME DEPTH nil NUM UNUM . FLAG)
$B!&%U%!%$%k>e$N%U%)%k%@(B
    (FOLDERNAME DEPTH (SIZE MTIME1 MTIME2) NUM UNUM . FLAG)
$B!&%U%)%k%@$G$J$$%U%!%$%k(B
    (NOTFOLDERNAME DEPTH (SIZE MTIME1 MTIME2) nil nil . FLAG)
$B!&%G%#%l%/%H%j(B
    (DIRNAME DEPTH 'directory FOLDERNUM UNREADNUM . FLAG)")

;;
;; ======= $B:G8e$K%I%-%e%a%s%H$rF~$l49$((B =================================
;(cmail-i18n-swap-doc cmail-i18n-doc-language)
;-> cmail.el $B$N:G8e$X(B
;; ======================================================================
