;;;
;;;  cmail-e20.el - cmail functions for emacs 20, 21
;;; 
;;;  Author:        Toshihiko Ueki <toshi@he.kobelcosys.co.jp>
;;;  Created:       1997/08/22
;;;  Last modified: 1997/09/03
;;;
;;;  Copyright (C) 1995-1997 Yukihiro Matsumoto.

;;; cmail-e20.el

(provide 'cmail-e20)
(require 'cmail-20)

(setq *cmail-file-coding-system 'no-conversion)
(setq *cmail-primary-coding-system 'iso-2022-7bit)

(let ((alist cmail-highlight-attribute-alist) entry name fore back bold italic)
  (while (setq entry (pop alist))
    (setq name (nth 0 entry)
	  fore (nth 1 entry)
	  back (nth 2 entry)
	  bold (nth 3 entry)
	  italic (nth 4 entry))
    (if fore (set-face-foreground name fore))
    (if back (set-face-background name back))
    (if bold (set-face-bold-p name bold))
    (if italic (set-face-italic-p name italic))))

(define-key menu-bar-tools-menu [rmail] '("Read Mail" . cmail))
(define-key menu-bar-tools-menu [compose-mail] '("Send Mail" . cmail))

(defadvice cmail-derived-mail-mode-setter
  ;; move menu item added by cmail-e19
  (before cmail-derived-mail-mode-setter-emacs-20 activate)
  (define-key cmail-mail-mode-map [menu-bar cmail] 'undefined)
  (define-key cmail-mail-mode-map [menu-bar mail]
    (cons "Mail" cmail-mail-menu-bar)))

(require 'cmail-e19)

;;
;; modify menus using emacs 20 specific features
;;
(when (or (> emacs-major-version 20)
	  (>= emacs-minor-version 3))
  ;; extended menu format is since emacs 20.3
  (remove-hook 'menu-bar-update-hook 'cmail-toggle-feature-menu-bar)
  (cmail-define-key
   'cmail-summary-menu-bar-feature
   '(([adispf]
      (menu-item "Always displaying folders"
		 cmail-toggle-always-display-folders
		 :visible cmail-use-full-window
		 :button (:toggle . cmail-always-display-folders)))
     ([hilit]
      (menu-item "Highlighting"
		 cmail-toggle-highlight-mode
		 :visible (not (featurep 'hilit19))
		 :button (:toggle . cmail-highlight-mode)))
     ([mimefw]
      (menu-item "MIME forwarding"
		 cmail-toggle-mime-forwarding
		 :visible cmail-use-mime
		 :button (:toggle . cmail-mime-forwarding)))
     ([tmauto]
      (menu-item "Automatic MIME preview"
		 cmail-mime-toggle-automatic-preview
		 :visible cmail-use-mime
		 :button (:toggle . cmail-mime-automatic-preview)))
     ([mcauto]
      (menu-item "Automatic PGP decrypt/verify"
		 cmail-crypt-toggle-automatic-decrypt/verify
		 :visible cmail-use-mailcrypt
		 :button (:toggle . cmail-crypt-automatic-decrypt/verify)))

     ;; ... menu-item $B$G$O(B item-name $B$K<0$r;XDj2DG=(B!!!
     ([pgpver]
      (menu-item (cond
		  ((string= cmail-crypt-default-version "5.0")
		   "Default PGP version -> 2.6")
		  ((string= cmail-crypt-default-version "2.6")
		   "Default PGP version -> GPG")
		  (t
		   "Default PGP version -> 5.0"))
		 cmail-crypt-change-default-version
		 :visible (and cmail-use-mailcrypt
			       (not (string= mc-version "3.4")))))))
  (cmail-define-key
   'cmail-summary-menu-bar-sort
   '(([thread]
      (menu-item "Sort by thread"
		 cmail-toggle-thread
		 :enable (not (cmail-thread-p))
		 :keys "\\[cmail-toggle-thread]")))))

;; Emacs 21 tool bar 
(defvar cmail-summary-tool-bar
  (if (and (functionp 'display-graphic-p)
	   (display-graphic-p))
      (let ((tool-bar-map (make-sparse-keymap)))
	(tool-bar-add-item "get-mail" 'cmail-get-newmail 'mail
			   :help "Get new mail")
	(tool-bar-add-item "write-mail" 'cmail-mail-from-summary 'mail-send
			   :help "Write mail")
	(tool-bar-add-item "folders" 'cmail-folders 'list
			   :help "View folders")
	(tool-bar-add-item "reply" 'cmail-reply 'reply
			   :help "Reply")
	(tool-bar-add-item "reply-include" 'cmail-reply-include-text 'replyi
			   :help "Reply (include text)")
	(tool-bar-add-item "follow" 'cmail-followup 'follow
			   :help "Follow up")
	(tool-bar-add-item "follow-include" 'cmail-followup-include-text 'followi
			   :help "Follow up (include text)")
	(tool-bar-add-item "forward" 'cmail-forward 'forward
			   :help "Forward")
	(tool-bar-add-item "delete" 'cmail-mark-delete 'delete
			   :help "Mark delete")
	tool-bar-map))
  "Emacs 21 tool bar for cmail-summary-mode.")

(defvar cmail-folders-tool-bar
  (if (and (functionp 'display-graphic-p)
	   (display-graphic-p))
      (let ((tool-bar-map (make-sparse-keymap)))
	(tool-bar-add-item "update" 'cmail-folders-update 'update
			   :help "Update folders")
	(tool-bar-add-item "copy" 'cmail-folders-copy-folder 'copy
			   :help "Copy Folder")
	(tool-bar-add-item "rename" 'cmail-folders-rename-folder 'rename
			   :help "Rename Folder")
	(tool-bar-add-item "delete" 'cmail-folders-kill-folder 'delete
			   :help "Kill Folder")
	(tool-bar-add-item "write-mail" 'cmail-folders-mail 'mail
			   :help "Write mail")
	tool-bar-map))
  "Emacs 21 tool bar for cmail-folders-mode.")

(add-hook 'cmail-summary-mode-hook
	  '(lambda ()
	     (set (make-local-variable 'tool-bar-map) cmail-summary-tool-bar)
	     ))

(add-hook 'cmail-folders-mode-hook
	  '(lambda ()
	     (set (make-local-variable 'tool-bar-map) cmail-folders-tool-bar)
	     ))

;;; cmail-e20.el ends here
