;;;
;;;  cmail-e19.el - cmail functions for emacs 19 or later
;;; 
;;;  $Author: MaNakagawa $
;;;           toshi@he.kobelcosys.co.jp
;;;  created at: Wed Aug 20 14:00:00 JST 1997
;;;  last modified at: Wed May 31 12:00:00 JST 2000
;;;
;;;  Copyright (C) 1995-1996 Yukihiro Matsumoto.

;;; cmail-e19.el

(provide 'cmail-e19)
(eval-when-compile (require 'emu)
		   (require 'cl)) ;-> ignore errors

(defun cmail-define-key (keymap &optional keydef string)
  "A utility function for setting menus."
  (let ((sym (intern (symbol-name keymap))))
    (unless (ignore-errors (symbol-value sym))
      (set sym (make-sparse-keymap string)))
    (dolist (def (nreverse keydef))
      (define-key (symbol-value sym) (nth 0 def) (nth 1 def)))))

;;
;; mail mode menu
;;
(defadvice cmail-derived-mail-mode-setter
  (before cmail-derived-mail-mode-setter-emacs-19 activate)
  ;; ... keymaps are merged ok, but menus are not quite so.
  ;; ... I will copy it here.
  (defvar cmail-mail-menu-bar
    (copy-keymap (lookup-key cmail-mail-mode-map [menu-bar mail])))
  (define-key cmail-mail-mode-map [menu-bar cmail]
    (cons "Cmail" cmail-mail-menu-bar)))

(add-hook
 'cmail-derived-mail-mode-setter
 (function
  (lambda ()
    ;; why do not you re-use already defined mail menu,
    ;; but how about XEmacs?
    ;; -> mail-menubar-menu
    (cmail-define-key
     'cmail-mail-menu-bar
     '(([cmail-summary] ("Go to Cmail Summary Buffer" . cmail-go-summary))
       ([separator-cmail] ("--"))
       ([send-stay]	("Send, Keep Editing" . cmail-send))
       ([send]		("Send Message" . cmail-send-and-exit))
       ([cancel]	("Cancel" . (lambda (arg)
				      (interactive "P")
				      (if (and (not arg)
					       (not (one-window-p)))
					  (delete-window))
				      (cmail-go-summary))))
       ([yank]		("Cite Original" . cmail-yank-original)))))))

;;
;; summary menu
;;
;(defvar cmail-summary-menu-bar-feature (make-sparse-keymap "Feature"))
(cmail-define-key 'cmail-summary-menu-bar-feature nil "Feature")
(add-hook 'menu-bar-update-hook 'cmail-toggle-feature-menu-bar)
(defun cmail-toggle-feature-menu-bar ()
  "Toggle display contents of feature control menu bar."
  (if cmail-use-mailcrypt
      (progn
	(if (not (string= mc-version "3.4"))
	    (cond
	     ((string= cmail-crypt-default-version "5.0")
	      (define-key cmail-summary-menu-bar-feature [pgpver]
		'("Default PGP version -> 2.6" . cmail-crypt-change-default-version)))
	     ((string= cmail-crypt-default-version "2.6")
	      (define-key cmail-summary-menu-bar-feature [pgpver]
		'("Default PGP version -> GPG" . cmail-crypt-change-default-version)))
	     (t
	      (define-key cmail-summary-menu-bar-feature [pgpver]
		'("Default PGP version -> 5.0" . cmail-crypt-change-default-version)))))
	(if cmail-crypt-automatic-decrypt/verify
	    (define-key cmail-summary-menu-bar-feature [mcauto]
	      '("Automatic PGP decrypt/verify off" . cmail-crypt-toggle-automatic-decrypt/verify))
	  (define-key cmail-summary-menu-bar-feature [mcauto]
	    '("Automatic PGP decrypt/verify on" . cmail-crypt-toggle-automatic-decrypt/verify)))))
  (if cmail-use-mime
      (progn
	(if cmail-mime-automatic-preview
	    (define-key cmail-summary-menu-bar-feature [tmauto]
	      '("Automatic MIME preview off" . cmail-mime-toggle-automatic-preview))
	  (define-key cmail-summary-menu-bar-feature [tmauto]
	    '("Automatic MIME preview on" . cmail-mime-toggle-automatic-preview)))
	(if cmail-mime-forwarding
	    (define-key cmail-summary-menu-bar-feature [mimefw]
	      '("MIME forwarding off" . cmail-toggle-mime-forwarding))
	  (define-key cmail-summary-menu-bar-feature [mimefw]
	    '("MIME forwarding on" . cmail-toggle-mime-forwarding)))))
  (if (not (featurep 'hilit19))
      (if cmail-highlight-mode
	  (define-key cmail-summary-menu-bar-feature [hilit]
	    '("Highlighting off" . cmail-toggle-highlight-mode))
	(define-key cmail-summary-menu-bar-feature [hilit]
	  '("Highlighting on" . cmail-toggle-highlight-mode))))
  (if cmail-use-full-window
      (if cmail-always-display-folders
	  (define-key cmail-summary-menu-bar-feature [adispf]
	    '("Always displaying folders off" . cmail-toggle-always-display-folders))
	(define-key cmail-summary-menu-bar-feature [adispf]
	  '("Always displaying folders on" . cmail-toggle-always-display-folders))))
  (run-hooks 'cmail-toggle-feature-menu-bar-hook))
(cmail-toggle-feature-menu-bar)

(cmail-define-key
 'cmail-summary-menu-bar-transfer
 '(([m2c]	("unix mail to cmail" . cmail-m2c))
   ([r2c]	("Cmail to unix mail" . cmail-c2m))
   ([c2m]	("Cmail to unix mail" . cmail-c2m)))
 "Transfer")

(cmail-define-key
 'cmail-summary-menu-bar-sort
 '(([subject]	("Sort by subject" . cmail-sort-by-subject))
   ([subjectr]	("Sort by subject(relative)" . cmail-sort-by-subject-relative))
   ([time]	("Sort by time" . cmail-sort-by-time))
   ([number]	("Sort by number" . cmail-sort-by-number))
   ([author]	("Sort by author" . cmail-sort-by-author))
   ([byte]	("Sort by byte" . cmail-sort-by-bytes))
   ([thread]	("Sort by thread" .
		 (lambda (arg)
		   (interactive "P")
		   (unless (cmail-thread-p)
		     (cmail-toggle-thread)))))
   ([original] ("Sort by orignal order" .
		(lambda (arg)
		  (interactive "P")
		  (cmail-get-folder)
		  (setq *cmail-disp-thread
			(cmail-check-display-thread cmail-current-folder))
		  (cmail-sort-header)
		  (cmail-disp-summary)))))
 "Sort")

(cmail-define-key
 'cmail-summary-menu-bar-digest
 '(([send]	("Send digest" . cmail-send-digest))
   ([burst]	("Burst digest" . cmail-burst-digest)))
 "Digest")

(cmail-define-key
 'cmail-summary-menu-bar-mark
 '(([mail]	("Mark ^" . cmail-mark-mail))
   ([all]	("Mark ^ to all mails" . cmail-mark-all))
   ([unmark]	("Unmark ^" . cmail-unmark))
   ([active]	("Mark active" . cmail-mark-active))
   ([delete]	("Mark delete" . cmail-mark-delete))
   ([hold]	("Mark hold" . cmail-mark-hold))
   ([unread]	("Mark unread" . cmail-mark-unread)))
 "Mark")

(cmail-define-key
 'cmail-summary-menu-bar-misc
 '(([pipe]	("Mail to pipe" . cmail-pipe))
   ([print]	("Print mail" . cmail-print))
   ([caesar]	("Caesar message" . cmail-caesar-message))
   ([wide]	("Stop page breaking" . cmail-stop-page-breaking))))

(cmail-define-key
 'cmail-summary-menu-bar-folder
 '(([list]	("List Folders" . cmail-folders))
   ([rename]	("Rename Folder" . cmail-rename-folder))
   ([copy]	("Copy Folder" . cmail-copy-folder))
   ([save]	("Save Folder" . cmail-save-folder))
   ([archive]	("Auto archive" . cmail-auto-archive))
   ([catchup]	("Catch up all" . cmail-catch-up-all))))

(cmail-define-key
 'cmail-summary-menu-bar
 (` ((,@ (if (fboundp 'customize-group)
	     '(([customize]		("Cmail Customize" . cmail-customize))
	       ([separator-customize]	("--")))))
   ([dispsum]	("Display summary" . cmail-disp-summary))
   ([goto]	("Go to mail" . cmail-goto-index))
   ([get]	("Get new mail" . cmail-summary-get-newmail))
   ([visit]	("Visit Folder" . cmail-visit-folder))
   ([folder]	(, (cons "Folder" cmail-summary-menu-bar-folder)))
   ([separator-message]	("--"))
   ([mail]	("Mail send" . cmail-mail-from-summary))
   ([reply]	("Reply" . cmail-reply))
   ([replyi]	("Reply(include)" . cmail-reply-include-text))
   ([follow]	("Followup" . cmail-followup))
   ([followi]	("Followup(include)" . cmail-followup-include-text))
   ([forward]	("Forward" . cmail-forward))
   ([misc]	(, (cons "Misc" cmail-summary-menu-bar-misc)))
   ([separator-summary]	("--"))
   ([mark]	(, (cons "Mark" cmail-summary-menu-bar-mark)))
   ([digest]	(, (cons "Digest" cmail-summary-menu-bar-digest)))
   ([sort]	(, (cons "Sort" cmail-summary-menu-bar-sort)))
   ([trans]	(, (cons "Transfer" cmail-summary-menu-bar-transfer)))
   ([fcntl]	(, (cons "Feature Control" cmail-summary-menu-bar-feature)))
   ([separator-quit]	("--"))
   ([quit]	("Summary Quit" . cmail-summary-quit)))))

(define-key cmail-summary-mode-map [menu-bar] (make-sparse-keymap))
(define-key cmail-summary-mode-map [menu-bar cmail]
  (cons "Cmail" cmail-summary-menu-bar))

(define-key cmail-summary-mode-map [mouse-2] 'cmail-mouse-select)
(define-key cmail-summary-mode-map [double-mouse-2]
  'cmail-sum-mouse-selected-msg-menu)
(define-key cmail-summary-mode-map [down-mouse-3]
  'cmail-sum-mouse-folder-menu)
(define-key cmail-summary-mode-map [double-mouse-3]
  'cmail-sum-mouse-folder-menu)

(defun cmail-mouse-select (event)
  (interactive "e")
  (mouse-set-point event)
  (cmail-read-contents (cmail-get-page-number-from-summary)))

(defun cmail-sum-mouse-selected-msg-menu (event)
  "Pop up menu for selected message in the cmail summary."
  (interactive "e")
  (let* ((msg-num (save-excursion
		    (mouse-set-point event)
		    (cmail-get-page-number-from-summary)))
         (selection
          (x-popup-menu
           event
           (list (format "Message %d" msg-num)
		 (cons "" cmail-sum-pop-up-menu-2)))))
    (if selection
	(progn
	  (mouse-set-point event)
	  (call-interactively selection)))))

(defun cmail-sum-mouse-folder-menu (event)
  "Pop up menu for folder in the cmail summary."
  (interactive "e")
  (let ((selection
	 (x-popup-menu
	  event
	  (list (format "Current Folder: %s" cmail-current-folder)
		(cons "" cmail-sum-pop-up-menu-1)))))
    (if selection
	(call-interactively selection))))

(defun cmail-sum-mouse-expand ()
  (interactive)
  (delete-other-windows)
  (recenter))

;;; cmail-e19.el ends here.
