<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

include_once('./cenote/cenote_smarty.php');
include_once('./cenote/core/validate.php');
/* -------------------------------------------------------------------
	モジュールインスタンス
-------------------------------------------------------------------- */
class view1 extends cenote_smarty {
	
	// 表示するページ番号を保存、外部からアクセスされる
	public	$page;
	public	$err_msg;
	public	$request;
	private	$acl;
	
	/* -----  コンストラクタ  ----- */
	public function __construct($req){
		parent::__construct();
		$this->request 				= $req;
		$this->smarty->config_dir 	= "./modules/".$this->request['module'];
		$this->page					= $this->request['page'];
		$this->acl					= $this->request['user'];
	}
	/* -----  デストラクタ  ----- */
	public function __destruct(){
		parent::__destruct();
	}
	/*------------------------------------------------------------
	   INIT 初期画面用項目セット初期化が必要な場合ここに記述
	------------------------------------------------------------ */
	public function init(){
	}
	/* ------------------------------------------------------------
		モジュールの利用権限確認
	------------------------------------------------------------ */
	public function acl(){
		return true;
	}
	/* ------------------------------------------------------------
		処理ごとの詳細な動作はこちらに記述
	   --------------------------------------------------------- */
	public function action(){
		if(isset($this->request['name']) && $this->request['name'] != ""){
			$this->assign("name",$this->request['name']);
			$this->page = 1;
			
		}
	}
	/* ------------------------------------------------------------
		エラーメッセージ配列に追加する
	   --------------------------------------------------------- */
	public function err_msg_add($str){
		$cnt = count($this->err_msg);
		$this->err_msg[$cnt] = $str;
	}
}
