<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

include_once('./cenote/core/db_class.php');
include_once('./cenote/core/date_class.php');
include_once('./cenote/core/injection_class.php');

class multiview_edit{

	public $request;

	public function __construct($req){
		$this->request = $req;
	}

	public function maintenance(){

		// DBクラスインスタンス
		$db = new db_class();

		// 項目初期化
		$id = 0;
		$title = $comment = $date = $order = $message = "";
		$err = false;
		$res = "";

		if(isset($this->request['Submit'])){
			switch($this->request['Submit']){
				case "登録":
					$res = $this->add();
					break;
				case "修整":
					$res = $this->up();
					break;
				case "削除":
					$res = $this->del();
					header("location:index.php?mod=AdminTool&page=7&emod=multiview_edit&edit=.%2Fmodules%2Fmultiview%2Fmultiview_edit");
					break;
			}
			if($res){
				$message = "入力にエラーがあります。(". $res .")";
				$id = $this->request['mview_id'];
				$order = $this->request['mview_order'];
				$title = $this->request['mview_title'];
				$comment = $this->request['mview_comment'];
				$date = $this->request['mview_date'];
			}
		}

		if(!$res){
			if(isset($this->request['edt'])){
				$id = $this->request['edt'];
				$sql = "SELECT * FROM cenote_mview WHERE mview_id = $id";
				$mview = $db->getData2($sql);
				if(is_array($mview)){
					for($ix=0; $ix < count($mview['mview_title']); $ix++){
						$id = $mview['mview_id'][$ix];
						$order = $mview['mview_order'][$ix];
						$title = $mview['mview_title'][$ix];
						$comment = $mview['mview_comment'][$ix];
						$date = $mview['mview_create_date'][$ix];
					}
				}
			}
		}



		//  VIEWファイルが登録されているか確認
		$sql = "SELECT * FROM cenote_mview ORDER BY mview_order";
		$mview_cnt = $db->getDataCnt($sql);


		//  画面表示
		$edit = '
			<script src="./extensions/fckeditor/fckeditor.js" type="text/javascript"></script>
			<script type="text/javascript">
			window.onload = function()
      		{
        			var oFCKeditor = new FCKeditor( \'mview_comment\' ) ;
       				oFCKeditor.BasePath = "./extensions/fckeditor/" ;
       				oFCKeditor.Height	= 300 ;
					oFCKeditor.Width	= 745 ;
        			oFCKeditor.ReplaceTextarea() ;
      		}
    		</script>';

		if($message){
			$edit .= '
				<table width="100%" border="1">
				  <tr>
				    <td color="#FF0000">'. $message. '</td>
			  	  </tr>
			 	</table>';
		}

		$edit .= '
			<table width="100%" border="1">
			  <tr>
			    <th width="20%" colspan="2">ページ登録＆修整</th>
			  </tr>
			  <tr>
			    <td width="20%">並び順</td>
			    <td width="80%"><input type="text" name="mview_order" size="2" maxlength="2" value="'.$order.'"/></td>
			  </tr>
			  <tr>
			    <td width="20%">ページタイトル</td>
			    <td width="80%"><input type="text" name="mview_title" size="80" maxlength="150" value="'.$title.'"/>
					<input type="hidden" name="mview_id" value="'.$id.'"/>
					<input type="hidden" name="mview_date" value="'.$date.'"/>
				</td>
			  </tr>
			  <tr>
			    <td colspan="2"><textarea name="mview_comment" cols="80" rows="10">'.$comment.'</textarea></td>
			  </tr>
			  <tr>
   				 <td colspan="2">';
		if(isset($this->request['edt'])){
			$edit .= '
					<input type="submit" name="Submit" value="修整" />　
					<input type="submit" name="Submit" value="削除" />
					<a href="index.php?mod=AdminTool&page=7&emod=multiview_edit&edit=.%2Fmodules%2Fmultiview%2Fmultiview_edit">戻る</a>';
		} else {
			$edit .= '<input type="submit" name="Submit" value="登録" />';
		}
		$edit .= '
				</td>
			  </tr>
			</table>
			<br />
			<table width="100%" border="1">
			  <tr>
			    <th width="20%" scope="col">登録日</th>
			    <th width="80%" scope="col">ページタイトル</th>
			  </tr>';

		if($mview_cnt > 0){
			$mview_list = $db->getData2($sql);
			for($ix=0; $ix < count($mview_list['mview_title']); $ix++){
				$edit .= '
				  <tr>
				    <td><a href="index.php?mod=AdminTool&page=7&emod=multiview_edit&edit=.%2Fmodules%2Fmultiview%2Fmultiview_edit&edt='.$mview_list['mview_id'][$ix].'">'.$mview_list['mview_create_date'][$ix].'</a></td>
				    <td>'.$mview_list['mview_title'][$ix].'</td>
				  </tr>';
			}
		}

		$edit .= '	</table>';

		return $edit;
	}

	// 追加ファンクション
	private function add(){
		if(trim($this->request['mview_title']) == ""){
			return "タイトル未入力";
		}
		if(!is_numeric($this->request['mview_order'])){
			return "表示順エラー";
		}
		$date = new date_class();
		$inj = new injection_class();
		$db = new db_class();


		$sql = sprintf("INSERT INTO cenote_mview (mview_title,mview_comment,mview_create_date,mview_order) VALUES ('%s','%s','%s',%d)",
		$inj->injection($this->request['mview_title']),
		$inj->injection(str_replace("\r\n","<br />",$this->request['mview_comment'])),
		$date->get_date('datetime'),
		$this->request['mview_order']
		);

		$db->putData($sql);
		return "";
	}
	// 更新ファンクション
	private function up(){
		if(trim($this->request['mview_title']) == ""){
			return "タイトル未入力";
		}
		if(!is_numeric($this->request['mview_order'])){
			return "表示順エラー";
		}

		$inj = new injection_class();
		$db = new db_class();

		$edit = str_replace("\r\n","",$this->request['mview_comment']);
		$edit = str_replace("\n", "", $edit);
		$edit = str_replace("\r", "", $edit);
		
		
		
		$sql = sprintf("UPDATE cenote_mview SET mview_title = '%s',
												mview_order = '%d',
												mview_comment = '%s',
												mview_update_date = '%s'
						WHERE mview_id = %d",
		$inj->injection($this->request['mview_title']),
		$this->request['mview_order'],
		$inj->injection($edit),
		$inj->injection($this->request['mview_date']),
		$inj->injection($this->request['mview_id'])
		);

		$db->putData($sql);
		return "";
	}
	// 削除ファンクション
	private function del(){
		$inj = new injection_class();
		$db = new db_class();

		$sql = sprintf("DELETE FROM cenote_mview WHERE mview_id = %d",
		$inj->injection($this->request['mview_id']));

		$db->putData($sql);
		return "";
	}
}