<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//
include_once('./cenote/cenote_smarty.php');
include_once('./cenote/core/validate.php');
/* -------------------------------------------------------------------
	モジュールインスタンス ＊編集不可
-------------------------------------------------------------------- */
class index extends cenote_smarty {

	// 表示するページ番号を保存、外部からアクセスされる
	public $page;
	// 画面に入力された内容をコントローラから受け取る配列
	public $request;
	// エラーメッセージ
	public $err_msg;
	/* 内部変数 */
	private $acl;
	
	/* -----  コンストラクタ  ----- */
	public function __construct($req){
		parent::__construct();
		
		$this->request				= $req;
		$this->smarty->config_dir 	= "./modules/".$this->request['module'];
		$this->page					= $this->request['page'];
		$this->acl					= $this->request['user'];
	}
	/* -----  デストラクタ  ----- */
	public function __destruct(){
		parent::__destruct();
	}
	/* ------------------------------------------------------------
	   INIT 初期画面用項目セット初期化が必要な場合ここに記述
	------------------------------------------------------------ */
	public function init(){
	}
	/* ------------------------------------------------------------
		モジュールの利用権限確認
	------------------------------------------------------------ */
	public function acl(){
		return true;
	}
	/* ------------------------------------------------------------
		処理ごとの詳細な動作はこちらに記述
	   --------------------------------------------------------- */
	public function action(){
		$html = "<h2>サンプルINDEXファイルです</h2><br />
管理画面は「index.php?mod=AdminTool」で開くことができます。<br />
サイトにトラブルが発生した場合は<a href=\"index.php?mod=AdminTool\">こちら</a>からLoginしてください。<br /><br />
PHP5とDB(PostgreSQL/MySQL)を利用しサイト立ち上げ支援の為のCMSです。すべての機能はモジュールで提供し、拡張しやすくなっています。CENOTE自身をコントロールするプログラムもモジュールで出来ています。<br />
基本的にデザインはテーマにまとめ、コードはモジュールとウィジットのみ作成するよう設計しています。<br />
面倒な画面のコントロールや値の取得、送信はCENOTEが行いプログラマはコード作成に専念できるようにしています。また、ユーザー管理やモジュールのON/OFFやユーザーごとの利用できるモジュールの権限などもCENOTEが行います。<br />
モジュールやウィジット、テーマなどは簡単に作成することが出来るよう雛形やマニュアルを作成しています。<br /><br /><h4>※このページはメンテナンスメニューのデザイン修正で開き{sumple}を削除して書き換えてください。</h4>

";
		$this->assign("sample",$html);
	}
}
