<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//


/**
 * DBアクセスのためのクラス
 */
class db_class{

	private $debg_msg = true;
	private $dbh;

	public $err_msg;
	public $err;

	public function __construct(){
		if(_DB_TYPE == "pgsql"){
			$DSN = _DB_TYPE;
			$DSN .= ":host="._DB_HOST;
			$DSN .= " port="._DB_PORT;
			$DSN .= " dbname="._DB_NAME;
			$DSN .= " user="._DB_USER;
			$DSN .= " password="._DB_PASSWD;

			try {
				$this->dbh = new PDO($DSN);
					
				// カラム名を小文字で取得する
				$this->dbh->setAttribute(PDO::ATTR_CASE, PDO::CASE_LOWER);

				// エラー時にExceptionをthrowさせる
				$this->dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
					
				$db = $this->dbh->prepare("SET NAMES 'UTF-8';");
				try {
					$db->execute();
				}
				catch (PDOException $e) {
					echo '文字コード変換ERROR';
					echo 'execute failed: ' . $e->getMessage() . '<br>';
					echo '	error code: ' . $e->getCode() . '<br>';
					echo '	DB error info: ' . $e->errorInfo[1] . '<br>';
				}
			}
			catch (PDOException $e) {
				echo 'データベースに接続できませんでした: ' . $e->getMessage(). '<br>';
				echo 'Connection failed: ' . $e->getMessage(). '<br>';
				echo 'error code: ' . $e->getCode(). '<br>';
				exit;
			}
		}
		if(_DB_TYPE == "mysql"){

			$DSN = _DB_TYPE;
			$DSN .= ":dbname="._DB_NAME;
			$DSN .= ";port="._DB_PORT;
			$DSN .= ";host="._DB_HOST;

			try {
				$this->dbh = new PDO($DSN, _DB_USER, _DB_PASSWD);
					
				// カラム名を小文字で取得する
				$this->dbh->setAttribute(PDO::ATTR_CASE, PDO::CASE_LOWER);

				// エラー時にExceptionをthrowさせる
				$this->dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
					
				$db = $this->dbh->prepare("set names utf8");
				try {
					$db->execute();
				}
				catch (PDOException $e) {
					echo '文字コード変換ERROR';
					echo 'execute failed: ' . $e->getMessage() . '<br>';
					echo '	error code: ' . $e->getCode() . '<br>';
					echo '	DB error info: ' . $e->errorInfo[1] . '<br>';
				}
			}
			catch (PDOException $e) {
				echo 'データベースに接続できませんでした: ' . $e->getMessage(). '<br>';
				echo 'Connection failed: ' . $e->getMessage(). '<br>';
				echo 'error code: ' . $e->getCode(). '<br>';
				exit;
			}


		}
	}

	public function __destruct(){
	}

	/* -------------------------------------------
	 データベースからデータを取り出す
	 ----------------------------------------------
	 引数：		SQL文
	 戻り値：　	Array()
	 配列['レコード番号']['項目']
	 false = 異常
	 --------------------------------------------*/
	public function getData($Query){

		$db = $this->dbh->prepare($Query);
		try {
			$db->execute();
		}

		catch (PDOException $e) {
			echo 'データを取得できませんでした<br>';
			echo 'execute failed: ' . $e->getMessage() . '<br>';
			echo '	error code: ' . $e->getCode() . '<br>';
			echo '	DB error info: ' . $e->errorInfo[1] . '<br>';
			exit;
		}
		$rec = "";
		$cnt = 0;
		$row = array();
		while ($row = $db->fetch(PDO::FETCH_ASSOC)) {
			foreach ($row as $column_name => $column_value) {
				$rec[$cnt][$column_name] = $column_value;
			}
			$cnt++;
		}
		return $rec;
	}

	/* -------------------------------------------
	 データベースからデータを取り出す
	 ----------------------------------------------
	 引数：		SQL文　配列の格納順の違い
	 戻り値：　	Array()
	 配列['項目']['レコード番号']
	 false = 異常
	 --------------------------------------------*/
	public function getData2($Query){

		$db = $this->dbh->prepare($Query);
		try {
			$db->execute();
		}

		catch (PDOException $e) {
			echo 'データを取得できませんでした<br>';
			echo 'execute failed: ' . $e->getMessage() . '<br>';
			echo '	error code: ' . $e->getCode() . '<br>';
			echo '	DB error info: ' . $e->errorInfo[1] . '<br>';
			exit;
		}
		$rec = "";
		$cnt = 0;
		$row = array();
		while ($row = $db->fetch(PDO::FETCH_ASSOC)) {
			foreach ($row as $column_name => $column_value) {
				$rec[$column_name][$cnt] = $column_value;
			}
			$cnt++;
		}
		return $rec;
	}
	/* -------------------------------------------
	 データベースに登録されている件数を求める
	 ----------------------------------------------
	 引数：		SQL文
	 戻り値：    SQLで見つかった件数
	 --------------------------------------------*/
	public function getDataCnt($Query){

		$db = $this->dbh->prepare($Query);
		try {
			$db->execute();
		}

		catch (PDOException $e) {
			$this->err = true;

			echo 'データを取得できませんでした<br>';
			echo 'execute failed: ' . $e->getMessage() . '<br>';
			echo '	error code: ' . $e->getCode() . '<br>';
			echo '	DB error info: ' . $e->errorInfo[1] . '<br>';
			exit;
		}
		return $db->rowCount();
	}

	/* -------------------------------------------
	 データベースに登録または更新する
	 ----------------------------------------------
	 引数：		SQL文を直接記入
	 戻り値：　	true  = 正
	 false = 異常
	 --------------------------------------------*/
	public function putData($Query){

		$db = $this->dbh->prepare($Query);

		try {
			//$this->dbh->beginTransaction();
			$db->execute();
			//$this->dbh->commit();
		}
		catch (PDOException $e) {
			echo 'データを追加できませんでした';
			echo $Query;
			echo 'transaction failed: ' . $e->getMessage();
			echo '	error code: ' . $e->getCode();
			echo '	DB error info: ' . $e->errorInfo[1];
			//$this->dbh->rollback();
			//return false;
			//exit;
		}
		return true;
	}


	/* -------------------------------------------
	 データベース トランザクション開始
	 --------------------------------------------*/
	public function startTransaction(){
		try {
			$this->dbh->beginTransaction();
		}
		catch (PDOException $e) {
			echo 'トランザクション開始に失敗しました';
			//echo 'transaction failed: ' . $e->getMessage();
			echo '	error code: ' . $e->getCode();
			echo '	DB error info: ' . $e->errorInfo[1];
			return false;
			exit;
		}
		return true;
	}
	/* -------------------------------------------
	 データベース トランザクション終了コミット
	 --------------------------------------------*/
	public function commitTransaction(){
		try {
			$this->dbh->commit();
		}
		catch (PDOException $e) {
			echo 'コミットに失敗しました';
			//echo 'transaction failed: ' . $e->getMessage();
			echo '	error code: ' . $e->getCode();
			echo '	DB error info: ' . $e->errorInfo[1];
			//return false;
			exit;
		}
		return true;
	}
	/* -------------------------------------------
	 データベース トランザクション異常終了ロールバック
	 --------------------------------------------*/
	public function rollbackTransaction(){
		try {
			$this->dbh->rollback();
		}
		catch (PDOException $e) {
			echo 'ロールバックに失敗しました';
			//echo 'transaction failed: ' . $e->getMessage();
			echo '	error code: ' . $e->getCode();
			echo '	DB error info: ' . $e->errorInfo[1];
			//return false;
			exit;
		}
		return true;
	}
}


