<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4 foldmethod=marker: */
// +------------------------------------------------------------------------+
// | Application: Cenote CMS												|
// +------------------------------------------------------------------------+
// | Copyright: (c) 2007.9 Akira Tanaka										|
// +------------------------------------------------------------------------+
// | 利用に関して: /cenote.txtを参照してください。							|
// +------------------------------------------------------------------------+
// | Author: Original Author <akirat28@gmail.com>							|
// +------------------------------------------------------------------------+
//

// include　classfile
include_once('./cenote/core/core.php');
include_once('./cenote/core/login_class.php');
include_once('./cenote/core/logout_class.php');
include_once('./cenote/core/injection_class.php');
include_once('./cenote/core/db_class.php');
include_once('./cenote/core/widget.php');


// confiuguration include
include_once("./configuration.php");

define('_CENOTE_VERSION', 'Version 0.9');


/**
 * agent Class
 *
 * coreクラスを効率よく呼び出すためのクラスです。
 * agentクラスはcoreクラスを継承し処理手順を明確にし制御を行います。
 */


class agent extends core{
	
	public function __construct(){
		
		parent::__construct();
		

		 // セッション開始
		agent::session_start();
		
		// ユーザー情報取得
		agent::get_user_info();
		
		// モージュールコンフィグロード
		agent::module_config_load();
		
		// 画面遷移リクエスト取得
		agent::get_page_request();

		// ユーザーログイン／ログアウトリクエスト取得
		agent::get_user_request();
		
		// リクエスト編集
		agent::make_request_arr();
		
		// アクセスコントロール
		agent::access_controll();	
			
		// 描画モジュール選択
		agent::main_module();

		// 管理者用画面の分岐
		if(agent::getModuleName() == 'AdminTool'){
			// 管理画面表示
			agent::admin_display();
		} else {
			// ウィジット情報取得
			agent::get_use_widget();

			// エディットボタン 
			agent::edit_button();
			
			//メンテエディットボタン
			agent::mnt_edit_button();
			
			// ヘッダーウィジット 
			agent::header_widget();
			
			// ナビゲーションウィジット 
			agent::navi_widget();
			
			// 左ウィジット 
			agent::left_widget();
			
			// センターウィジット 
			agent::center_widget();
			
			// 右ウィジット
			agent::right_widget();

			// フッターウィジット
			agent::footer_widget();	
		
			// 通常画面表示
			agent::display();
			
		}
	}
}

// END