[W3C 日本語組版処理の要件（日本語版）]: https://w3c.github.io/jlreq/ja/
[JIS X 4051（日本語文書の組版方法）]: https://kikakurui.com/x4/X4051-2004-02.html
[JIS X 4051]: https://kikakurui.com/x4/X4051-2004-02.html
[WordPress]: https://ja.wordpress.org/
[Jekyll]: https://jekyllrb.com/
[Gatsby]: https://www.gatsbyjs.org/
[Hexo]: https://hexo.io/
[flexmark]: https://github.com/vsch/flexmark-java
[LESS]: http://lesscss.org/
[Apache FreeMarker]: https://freemarker.apache.org/

日本語組版処理について
======================

元々は、印刷工程で活字を組み合わせて版を作ることを組版といいました。
組版には、印刷物を読みやすく、美しく見せるための字間調整などのルールがあります。
印刷物に限らず、HTMLにおいても適切に文字を組むことで、
より読みやすく、美しいWebページを作成することができます。

Catalpaでは[W3C 日本語組版処理の要件（日本語版）][]、[JIS X 4051（日本語文書の組版方法）][]を
参考にして、横組で和文と欧文を混植する際の字間調整をおこなっています。
禁則処理、追い込み・追い出し等はCSS（ブラウザの機能）で指定しています。

Catalpaは日本語サイトの構築に適した静的サイトジェネレーターです。
日本語組版処理の機能が組み込まれており、和文・欧文混在の文章を綺麗にレイアウトすることができます。
アプリケーションの実行には64ビットWindowsが必要です。

### コンテンツ管理システム（CMS）

静的サイトジェネレーターに注目が集まる以前は、
コンテンツ管理システム（CMS）でウェブサイトを作成する方法が一般的でした。

世界で最も人気のあるウェブサイト構築用のCMSといえば間違いなく[WordPress][]です。
CMSは基本的にウェブサーバー上で動作させるプログラムであり、動的にウェブページを生成します。
プログラムの実行環境だけでなくMySQLなどのデータベースも必要となるため、
CMSの運用には比較的性能の高いサーバーが必要になります。

### 静的サイトジェネレーターとは

静的サイトジェネレーターは（ウェブサーバー上ではなく）ローカル環境でウェブサイトを生成ツールです。
出力したサイトコンテンツ一式（HTML、CSS、JavaScript、…）をウェブサーバーにコピーするだけでサイト構築が完了する手軽さがあります。

CMSとは異なりウェブサーバー上でプログラムを実行する必要がないので、ウェブページの表示が速い、
プロバイダーの無料ホームページスペースでも簡単にウェブサイトを公開できる、といった特徴があります。

世界中で多くの静的サイトジェネレーターが開発されており、
[Jekyll][]、[Gatsby][]、[Hexo][] といったソフトウェアが人気を博しています。
