/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.HtmlFormattingAppendableBase;
import com.vladsch.flexmark.util.html.LineFormattingAppendable;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.TagRange;
import java.util.ArrayList;

public class HtmlWriter
extends HtmlFormattingAppendableBase<HtmlWriter> {
    private NodeRendererContext context;
    private AttributablePart useAttributes;

    public HtmlWriter(int indentSize, int formatOptions) {
        super(indentSize, formatOptions);
    }

    public HtmlWriter(HtmlWriter other, boolean inheritIndent) {
        super((LineFormattingAppendable)other, inheritIndent);
        this.context = other.context;
    }

    public HtmlWriter(int indentSize, int formatOptions, boolean suppressOpenTagLine, boolean suppressCloseTagLine) {
        super(indentSize, formatOptions);
        this.setSuppressOpenTagLine(suppressOpenTagLine);
        this.setSuppressCloseTagLine(suppressCloseTagLine);
    }

    void setContext(NodeRendererContext context) {
        this.context = context;
    }

    public NodeRendererContext getContext() {
        return this.context;
    }

    public HtmlWriter srcPos() {
        return this.srcPos(this.context.getCurrentNode().getChars());
    }

    public HtmlWriter srcPosWithEOL() {
        return this.srcPosWithEOL(this.context.getCurrentNode().getChars());
    }

    public HtmlWriter srcPosWithTrailingEOL() {
        return this.srcPosWithTrailingEOL(this.context.getCurrentNode().getChars());
    }

    public HtmlWriter srcPos(BasedSequence sourceText) {
        if (sourceText.isNotNull()) {
            BasedSequence trimmed = (BasedSequence)sourceText.trimEOL();
            return this.srcPos(trimmed.getStartOffset(), trimmed.getEndOffset());
        }
        return this;
    }

    public HtmlWriter srcPosWithEOL(BasedSequence sourceText) {
        if (sourceText.isNotNull()) {
            return this.srcPos(sourceText.getStartOffset(), sourceText.getEndOffset());
        }
        return this;
    }

    public HtmlWriter srcPosWithTrailingEOL(BasedSequence sourceText) {
        if (sourceText.isNotNull()) {
            char c;
            int endOffset;
            BasedSequence base = sourceText.getBaseSequence();
            for (endOffset = sourceText.getEndOffset(); endOffset < base.length() && ((c = base.charAt(endOffset)) == ' ' || c == '\t'); ++endOffset) {
            }
            if (endOffset < base.length() && base.charAt(endOffset) == '\r') {
                ++endOffset;
            }
            if (endOffset < base.length() && base.charAt(endOffset) == '\n') {
                ++endOffset;
            }
            return this.srcPos(sourceText.getStartOffset(), endOffset);
        }
        return this;
    }

    public HtmlWriter srcPos(int startOffset, int endOffset) {
        if (startOffset <= endOffset && !this.context.getHtmlOptions().sourcePositionAttribute.isEmpty()) {
            super.attr((CharSequence)this.context.getHtmlOptions().sourcePositionAttribute, (CharSequence)(startOffset + "-" + endOffset));
        }
        return this;
    }

    public HtmlWriter withAttr() {
        return this.withAttr(AttributablePart.NODE);
    }

    public HtmlWriter withAttr(AttributablePart part) {
        super.withAttr();
        this.useAttributes = part;
        return this;
    }

    public HtmlWriter withAttr(LinkStatus status) {
        this.attr("Link Status", status.getName());
        return this.withAttr(AttributablePart.LINK);
    }

    public HtmlWriter withAttr(ResolvedLink resolvedLink) {
        return this.withAttr(resolvedLink.getStatus());
    }

    public HtmlWriter tag(CharSequence tagName, boolean voidElement) {
        if (this.useAttributes != null) {
            String sourcePositionAttribute;
            Attributes attributes = this.context.extendRenderingNodeAttributes(this.useAttributes, this.getAttributes());
            String attributeValue = attributes.getValue((CharSequence)(sourcePositionAttribute = this.context.getHtmlOptions().sourcePositionAttribute));
            if (!attributeValue.isEmpty()) {
                int pos = attributeValue.indexOf(45);
                int startOffset = -1;
                int endOffset = -1;
                if (pos != -1) {
                    try {
                        startOffset = Integer.valueOf(attributeValue.substring(0, pos));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        endOffset = Integer.valueOf(attributeValue.substring(pos + 1));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (startOffset >= 0 && startOffset < endOffset) {
                    ArrayList tagRanges = (ArrayList)this.context.getDocument().get(HtmlRenderer.TAG_RANGES);
                    tagRanges.add(new TagRange(tagName, startOffset, endOffset));
                }
            }
            this.setAttributes(attributes);
            this.useAttributes = null;
        }
        super.tag(tagName, voidElement);
        return this;
    }
}

