/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.sourcemap;

import com.github.sommeri.sourcemap.SourceMapConsumerV3;
import com.github.sommeri.sourcemap.SourceMapParseException;
import com.github.sommeri.sourcemap.SourceMapSupplier;
import com.github.sommeri.sourcemap.SourceMapping;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;

public class SourceMapConsumerFactory {
    private SourceMapConsumerFactory() {
    }

    public static SourceMapping parse(String contents) throws SourceMapParseException {
        return SourceMapConsumerFactory.parse(contents, null);
    }

    public static SourceMapping parse(String contents, SourceMapSupplier supplier) throws SourceMapParseException {
        if (contents.startsWith("{")) {
            try {
                JsonObject sourceMapRoot = new JsonParser().parse(contents).getAsJsonObject();
                int version = sourceMapRoot.get("version").getAsInt();
                switch (version) {
                    case 3: {
                        SourceMapConsumerV3 consumer = new SourceMapConsumerV3();
                        consumer.parse(sourceMapRoot, supplier);
                        return consumer;
                    }
                }
                throw new SourceMapParseException("Unknown source map version:" + version);
            }
            catch (JsonParseException ex) {
                throw new SourceMapParseException("JSON parse exception: " + (Object)((Object)ex));
            }
        }
        throw new SourceMapParseException("unable to detect source map format");
    }
}

