/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.Indexed;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class IndexedIterator<R, S, I extends ReversibleIterator<Integer>>
implements ReversibleIndexedIterator<R> {
    private final I myIterator;
    private final Indexed<S> myItems;
    private int myLastIndex;
    private int myModificationCount;

    public IndexedIterator(Indexed<S> items, I iterator) {
        this.myItems = items;
        this.myIterator = iterator;
        this.myLastIndex = -1;
        this.myModificationCount = items.modificationCount();
    }

    @Override
    public boolean isReversed() {
        return this.myIterator.isReversed();
    }

    @Override
    public boolean hasNext() {
        return this.myIterator.hasNext();
    }

    @Override
    public R next() {
        if (this.myModificationCount != this.myItems.modificationCount()) {
            throw new ConcurrentModificationException();
        }
        this.myLastIndex = (Integer)this.myIterator.next();
        return (R)this.myItems.get(this.myLastIndex);
    }

    @Override
    public void remove() {
        if (this.myLastIndex == -1) {
            throw new NoSuchElementException();
        }
        if (this.myModificationCount != this.myItems.modificationCount()) {
            throw new ConcurrentModificationException();
        }
        this.myItems.removeAt(this.myLastIndex);
        this.myLastIndex = -1;
        this.myModificationCount = this.myItems.modificationCount();
    }

    @Override
    public int getIndex() {
        if (this.myLastIndex < 0) {
            throw new NoSuchElementException();
        }
        return this.myLastIndex;
    }

    @Override
    public void forEachRemaining(Consumer<? super R> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

