/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.blogs.flexmark.ext.kbd.internal;

import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osdn.blogs.flexmark.ext.kbd.Kbd;

public class KbdInlineParserExtension
implements InlineParserExtension {
    private final Pattern PATTERN = Pattern.compile("\\['([^']*)'\\]");

    public KbdInlineParserExtension(LightInlineParser inlineParser) {
    }

    public void finalizeDocument(InlineParser inlineParser) {
    }

    public void finalizeBlock(InlineParser inlineParser) {
    }

    public boolean parse(LightInlineParser inlineParser) {
        if (inlineParser.peek(1) == '\'') {
            BasedSequence input = inlineParser.getInput();
            Matcher matcher = inlineParser.matcher(this.PATTERN);
            if (matcher != null) {
                BasedSequence tag = (BasedSequence)input.subSequence(matcher.start(), matcher.end());
                BasedSequence text = (BasedSequence)input.subSequence(matcher.start(1), matcher.end(1));
                Kbd node = new Kbd((BasedSequence)tag.subSequence(0, 2), text, (BasedSequence)tag.endSequence(2));
                node.setCharsFromContent();
                inlineParser.flushTextNode();
                inlineParser.getBlock().appendChild((Node)node);
                return true;
            }
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        public Set<Class<? extends InlineParserExtensionFactory>> getAfterDependents() {
            return null;
        }

        public CharSequence getCharacters() {
            return "['";
        }

        public Set<Class<? extends InlineParserExtensionFactory>> getBeforeDependents() {
            return null;
        }

        public InlineParserExtension apply(LightInlineParser inlineParser) {
            return new KbdInlineParserExtension(inlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

