/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.internal.DefinitionListItemBlockPreProcessor;
import com.vladsch.flexmark.ext.definition.internal.DefinitionOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.BlockPreProcessor;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class DefinitionListBlockPreProcessor
implements BlockPreProcessor {
    private final DefinitionOptions options;

    public DefinitionListBlockPreProcessor(DataHolder options) {
        this.options = new DefinitionOptions(options);
    }

    public void preProcess(ParserState state, Block block) {
        Boolean blankLinesInAST = (Boolean)state.getProperties().get(Parser.BLANK_LINES_IN_AST);
        if (block instanceof DefinitionList) {
            DefinitionList definitionList = (DefinitionList)block;
            boolean isTight = definitionList.isTight();
            if (this.options.autoLoose && isTight) {
                for (Node child : definitionList.getChildren()) {
                    if (!(child instanceof DefinitionItem)) continue;
                    if (((DefinitionItem)child).isLoose()) {
                        isTight = false;
                        if (!blankLinesInAST.booleanValue()) break;
                    }
                    if (!blankLinesInAST.booleanValue()) continue;
                    child.moveTrailingBlankLines();
                }
                definitionList.setTight(isTight);
            }
            if (blankLinesInAST.booleanValue()) {
                definitionList.moveTrailingBlankLines();
            }
        }
    }

    public static class Factory
    implements BlockPreProcessorFactory {
        public Set<Class<? extends Block>> getBlockTypes() {
            HashSet<Class<? extends Block>> set = new HashSet<Class<? extends Block>>();
            set.add(DefinitionList.class);
            return set;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getAfterDependents() {
            HashSet<Class<? extends BlockPreProcessorFactory>> set = new HashSet<Class<? extends BlockPreProcessorFactory>>();
            set.add(DefinitionListItemBlockPreProcessor.Factory.class);
            return set;
        }

        public Set<Class<? extends BlockPreProcessorFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return true;
        }

        public BlockPreProcessor apply(ParserState state) {
            return new DefinitionListBlockPreProcessor((DataHolder)state.getProperties());
        }
    }
}

