/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.wrapper.enc;

import java.io.IOException;
import java.nio.ByteBuffer;

class EncoderJNI {
    EncoderJNI() {
    }

    private static native ByteBuffer nativeCreate(long[] var0);

    private static native void nativePush(long[] var0, int var1);

    private static native ByteBuffer nativePull(long[] var0);

    private static native void nativeDestroy(long[] var0);

    static class Wrapper {
        protected final long[] context = new long[5];
        private final ByteBuffer inputBuffer;

        Wrapper(int inputBufferSize, int quality, int lgwin) throws IOException {
            this.context[1] = inputBufferSize;
            this.context[2] = quality;
            this.context[3] = lgwin;
            this.inputBuffer = EncoderJNI.nativeCreate(this.context);
            if (this.context[0] == 0L) {
                throw new IOException("failed to initialize native brotli encoder");
            }
            this.context[1] = 1L;
            this.context[2] = 0L;
            this.context[3] = 0L;
        }

        void push(Operation op, int length) {
            if (length < 0) {
                throw new IllegalArgumentException("negative block length");
            }
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli encoder is already destroyed");
            }
            if (!this.isSuccess() || this.hasMoreOutput()) {
                throw new IllegalStateException("pushing input to encoder in unexpected state");
            }
            if (this.hasRemainingInput() && length != 0) {
                throw new IllegalStateException("pushing input to encoder over previous input");
            }
            this.context[1] = op.ordinal();
            EncoderJNI.nativePush(this.context, length);
        }

        boolean isSuccess() {
            return this.context[1] != 0L;
        }

        boolean hasMoreOutput() {
            return this.context[2] != 0L;
        }

        boolean hasRemainingInput() {
            return this.context[3] != 0L;
        }

        boolean isFinished() {
            return this.context[4] != 0L;
        }

        ByteBuffer getInputBuffer() {
            return this.inputBuffer;
        }

        ByteBuffer pull() {
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli encoder is already destroyed");
            }
            if (!this.isSuccess() || !this.hasMoreOutput()) {
                throw new IllegalStateException("pulling while data is not ready");
            }
            return EncoderJNI.nativePull(this.context);
        }

        void destroy() {
            if (this.context[0] == 0L) {
                throw new IllegalStateException("brotli encoder is already destroyed");
            }
            EncoderJNI.nativeDestroy(this.context);
            this.context[0] = 0L;
        }

        protected void finalize() throws Throwable {
            if (this.context[0] != 0L) {
                this.destroy();
            }
            super.finalize();
        }
    }

    static enum Operation {
        PROCESS,
        FLUSH,
        FINISH;

    }
}

