/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.blogs.flexmark.ext.highlight;

import com.codewaves.codehighlight.core.Highlighter;
import com.codewaves.codehighlight.core.StyleRenderer;
import com.codewaves.codehighlight.core.StyleRendererFactory;
import com.codewaves.codehighlight.renderer.HtmlRenderer;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.osdn.blogs.flexmark.ext.highlight.HighlightExtension;

public class HighlightRenderer
implements NodeRenderer {
    private static final AttributablePart CODE_CONTENT = new AttributablePart("FENCED_CODE_CONTENT");
    private static final String ADDITIONAL_CHARS = "";
    private static final String ATTRIBUTENAME = "[a-zA-Z_:][a-zA-Z0-9:._-]*";
    private static final String UNQUOTEDVALUE = "[^\"'=<>{}`\u0000- ]+";
    private static final String SINGLEQUOTEDVALUE = "'[^']*'";
    private static final String DOUBLEQUOTEDVALUE = "\"[^\"]*\"";
    private static final String ATTRIBUTEVALUE = "(?:[^\"'=<>{}`\u0000- ]+|'[^']*'|\"[^\"]*\")";
    private static final Pattern ATTRIBUTES_TAG = Pattern.compile("\\{((?:[#.])|(?:\\s*([#.][^\"'=<>{}`\u0000- ]+|[a-zA-Z_:][a-zA-Z0-9:._-]*)\\s*(?:=\\s*((?:[^\"'=<>{}`\u0000- ]+|'[^']*'|\"[^\"]*\"))?)?)(?:\\s+([#.][^\"'=<>{}`\u0000- ]+|[a-zA-Z_:][a-zA-Z0-9:._-]*)\\s*(?:=\\s*((?:[^\"'=<>{}`\u0000- ]+|'[^']*'|\"[^\"]*\"))?)?)*\\s*)\\}$");
    private static final Pattern ATTRIBUTE = Pattern.compile("\\s*([#.][^\"'=<>{}`\u0000- ]+|[a-zA-Z_:][a-zA-Z0-9:._-]*)\\s*(?:=\\s*((?:[^\"'=<>{}`\u0000- ]+|'[^']*'|\"[^\"]*\"))?)?");
    private static final String COPY_SCRIPT = "document.getSelection().selectAllChildren(event.target.parentNode.nextSibling);document.execCommand('copy');document.getSelection().removeAllRanges();return false;";
    private final boolean codeContentBlock;
    private final boolean isReplaceYenSign;
    private final Highlighter highlighter = new Highlighter(new StyleRendererFactory(){

        public StyleRenderer create(String languageName) {
            return new HtmlRenderer("hljs-");
        }
    });

    public HighlightRenderer(DataHolder options) {
        this.codeContentBlock = (Boolean)Parser.FENCED_CODE_CONTENT_BLOCK.getFrom(options);
        this.isReplaceYenSign = (Boolean)HighlightExtension.REPLACE_YEN_SIGN.getFrom(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(FencedCodeBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<FencedCodeBlock>(){

            public void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
                HighlightRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    protected void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        String languageName = null;
        BasedSequence language = BasedSequence.NULL;
        BasedSequence title = BasedSequence.NULL;
        boolean isCopyable = false;
        html.line();
        BasedSequence info = node.getInfo();
        if (info.isNotNull() && !info.isBlank()) {
            Matcher matcher = ATTRIBUTES_TAG.matcher((CharSequence)info);
            if (matcher.find()) {
                BasedSequence attributesText = info.subSequence(matcher.start(1), matcher.end(1)).trim();
                if (!attributesText.isEmpty()) {
                    Matcher attributeMatcher = ATTRIBUTE.matcher((CharSequence)attributesText);
                    while (attributeMatcher.find()) {
                        boolean isQuoted;
                        BasedSequence attributeName = attributesText.subSequence(attributeMatcher.start(1), attributeMatcher.end(1));
                        if (!attributeName.isNotNull() || attributeName.length() <= 0) continue;
                        if (attributeName.charAt(0) == '.') {
                            BasedSequence cls = attributeName.subSequence(1);
                            html.attr((CharSequence)"class", (CharSequence)cls);
                            if (!cls.startsWith((CharSequence)"cop")) continue;
                            isCopyable = true;
                            continue;
                        }
                        if (attributeName.charAt(0) == '#') {
                            html.attr((CharSequence)"id", (CharSequence)attributeName.subSequence(1));
                            continue;
                        }
                        BasedSequence attributeValue = attributeMatcher.groupCount() == 1 || attributeMatcher.start(2) == -1 ? BasedSequence.NULL : attributesText.subSequence(attributeMatcher.start(2), attributeMatcher.end(2));
                        boolean bl = isQuoted = attributeValue.length() >= 2 && (attributeValue.charAt(0) == '\"' && attributeValue.endCharAt(1) == '\"' || attributeValue.charAt(0) == '\'' && attributeValue.endCharAt(1) == '\'');
                        if (isQuoted) {
                            attributeValue = attributeValue.midSequence(1, -1);
                        }
                        if (!attributeValue.isNotNull()) continue;
                        html.attr((CharSequence)attributeName, (CharSequence)attributeValue);
                    }
                }
                info = info.subSequence(0, matcher.start()).trim();
            }
            if (info.isNotNull() && !info.isBlank()) {
                int space = info.indexOfAny((CharSequence)" ");
                if (space == -1) {
                    language = info;
                } else {
                    language = info.subSequence(0, space);
                    title = info.subSequence(space).trim();
                }
                languageName = language.unescape();
            }
        }
        ((HtmlWriter)html.srcPosWithTrailingEOL(node.getChars()).withAttr().tag((CharSequence)"pre")).openPre();
        if (title.isNotNull() || isCopyable) {
            ((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"title")).withAttr().tag((CharSequence)"div");
            if (title.isNotNull()) {
                html.append((CharSequence)title);
            }
            if (isCopyable) {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"copy-button")).attr((CharSequence)"onclick", (CharSequence)COPY_SCRIPT)).withAttr().tag((CharSequence)"span")).tag((CharSequence)"/span");
            }
            html.tag((CharSequence)"/div");
        }
        if (language.isNotNull()) {
            html.attr((CharSequence)"class", (CharSequence)(context.getHtmlOptions().languageClassPrefix + language.unescape()));
        } else {
            String noLanguageClass = context.getHtmlOptions().noLanguageClass.trim();
            if (!noLanguageClass.isEmpty()) {
                html.attr((CharSequence)"class", (CharSequence)noLanguageClass);
            }
        }
        html.srcPosWithEOL(node.getContentChars()).withAttr(CODE_CONTENT).tag((CharSequence)"code");
        if (this.codeContentBlock) {
            context.renderChildren((Node)node);
        } else if (languageName == null) {
            html.text((CharSequence)node.getContentChars().normalizeEOL());
        } else if (languageName.equals("raw")) {
            html.append((CharSequence)node.getContentChars().normalizeEOL());
        } else {
            String code = node.getContentChars().normalizeEOL();
            CharSequence content = Highlighter.findLanguage((String)languageName) != null ? this.highlight(languageName, code) : code.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            if (this.isReplaceYenSign) {
                content = content.toString().replace("\\", "&yen;");
            }
            html.append(content);
        }
        html.tag((CharSequence)"/code");
        ((HtmlWriter)html.tag((CharSequence)"/pre")).closePre();
        html.lineIf(context.getHtmlOptions().htmlBlockCloseTagEol);
    }

    protected CharSequence highlight(String languageName, String code) {
        Highlighter.HighlightResult result = this.highlighter.highlight(languageName, code);
        return result.getResult();
    }
}

