/*
 * Decompiled with CFR 0.152.
 */
package lu.luz.jzopfli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import lu.luz.jzopfli.Util;
import lu.luz.jzopfli.ZopfliH;
import lu.luz.jzopfli.Zopfli_lib;

public final class Zopfli_bin {
    private static void LoadFile(String string, byte[][] byArray, int[] nArray) throws IOException {
        int n;
        byArray[0] = null;
        nArray[0] = 0;
        File file = new File(string);
        nArray[0] = (int)file.length();
        byArray[0] = new byte[nArray[0]];
        if (nArray[0] != 0 && byArray[0] != null && (n = (byArray[0] = Files.readAllBytes(file.toPath())).length) != nArray[0]) {
            byArray[0] = null;
            byArray = null;
            nArray[0] = 0;
        }
        assert (nArray[0] == 0 || byArray != null);
        file = null;
    }

    private static void SaveFile(String string, byte[][] byArray, int[] nArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        assert (fileOutputStream != null);
        fileOutputStream.write(byArray[0], 0, nArray[0]);
        fileOutputStream.close();
    }

    private static void CompressFile(ZopfliH.ZopfliOptions zopfliOptions, ZopfliH.ZopfliFormat zopfliFormat, String string, String string2) throws IOException {
        Object object = new byte[][]{{0}};
        int[] nArray = new int[]{0};
        Object object2 = new byte[][]{{0}};
        int[] nArray2 = new int[]{0};
        Zopfli_bin.LoadFile(string, object, nArray);
        if (nArray[0] == 0) {
            System.err.printf("Invalid filename: %s\n", string);
            return;
        }
        Zopfli_lib.ZopfliCompress(zopfliOptions, zopfliFormat, object[0], nArray[0], object2, nArray2);
        if (string2 != null) {
            Zopfli_bin.SaveFile(string2, object2, nArray2);
        } else {
            for (int i = 0; i < nArray2[0]; ++i) {
                System.out.write(object2[0][i]);
            }
        }
        object2 = null;
        object = null;
    }

    private static String AddStrings(String string, String string2) {
        int n = string.length() + string2.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1);
        stringBuilder.append(string);
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static boolean StringsEqual(String string, String string2) {
        return string.equals(string2);
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        int n;
        ZopfliH.ZopfliOptions zopfliOptions = new ZopfliH.ZopfliOptions();
        ZopfliH.ZopfliFormat zopfliFormat = ZopfliH.ZopfliFormat.ZOPFLI_FORMAT_GZIP;
        String string2 = null;
        boolean bl = false;
        Util.ZopfliInitOptions(zopfliOptions);
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (Zopfli_bin.StringsEqual(string, "-v")) {
                zopfliOptions.verbose = true;
                continue;
            }
            if (Zopfli_bin.StringsEqual(string, "-c")) {
                bl = true;
                continue;
            }
            if (Zopfli_bin.StringsEqual(string, "--deflate")) {
                zopfliFormat = ZopfliH.ZopfliFormat.ZOPFLI_FORMAT_DEFLATE;
                continue;
            }
            if (Zopfli_bin.StringsEqual(string, "--zlib")) {
                zopfliFormat = ZopfliH.ZopfliFormat.ZOPFLI_FORMAT_ZLIB;
                continue;
            }
            if (Zopfli_bin.StringsEqual(string, "--gzip")) {
                zopfliFormat = ZopfliH.ZopfliFormat.ZOPFLI_FORMAT_GZIP;
                continue;
            }
            if (Zopfli_bin.StringsEqual(string, "--splitlast")) {
                zopfliOptions.blocksplittinglast = true;
                continue;
            }
            if (string.charAt(0) == '-' && string.charAt(1) == '-' && string.charAt(2) == 'i' && string.charAt(3) >= '0' && string.charAt(3) <= '9') {
                zopfliOptions.numiterations = Integer.valueOf(string.substring(3));
                continue;
            }
            if (!Zopfli_bin.StringsEqual(string, "-h")) continue;
            System.err.printf("Usage: zopfli [OPTION]... FILE\n  -h    gives this help\n  -c    write the result on standard output, instead of disk filename + '.gz'\n  -v    verbose mode\n  --i#  perform # iterations (default 15). More gives more compression but is slower. Examples: --i10, --i50, --i1000\n", new Object[0]);
            System.err.printf("  --gzip        output to gzip format (default)\n  --zlib        output to zlib format instead of gzip\n  --deflate     output to deflate format instead of gzip\n  --splitlast   do block splitting last instead of first\n", new Object[0]);
            return;
        }
        if (zopfliOptions.numiterations < 1) {
            System.err.println("Error: must have 1 or more iterations");
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].charAt(0) == '-') continue;
            string2 = stringArray[n];
            if (bl) {
                string = null;
            } else if (zopfliFormat == ZopfliH.ZopfliFormat.ZOPFLI_FORMAT_GZIP) {
                string = Zopfli_bin.AddStrings(string2, ".gz");
            } else if (zopfliFormat == ZopfliH.ZopfliFormat.ZOPFLI_FORMAT_ZLIB) {
                string = Zopfli_bin.AddStrings(string2, ".zlib");
            } else {
                assert (zopfliFormat == ZopfliH.ZopfliFormat.ZOPFLI_FORMAT_DEFLATE);
                string = Zopfli_bin.AddStrings(string2, ".deflate");
            }
            if (zopfliOptions.verbose && string != null) {
                System.err.printf("Saving to: %s\n", string);
            }
            Zopfli_bin.CompressFile(zopfliOptions, zopfliFormat, string2, string);
        }
        if (string2 == null) {
            System.err.printf("Please provide filename\nFor help, type: %s -h\n", "java -jar " + new File(Zopfli_bin.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName());
        }
    }
}

