/*
 * Decompiled with CFR 0.152.
 */
package lu.luz.jzopfli;

import java.util.Arrays;
import java.util.Comparator;
import lu.luz.jzopfli.KatajainenH;

final class Katajainen
extends KatajainenH {
    private static final Comparator<Node> leafComparator = new Comparator<Node>(){

        @Override
        public int compare(Node node, Node node2) {
            return node.weight - node2.weight;
        }
    };

    Katajainen() {
    }

    private static void InitNode(int n, int n2, Node node, Node node2) {
        node2.weight = n;
        node2.count = n2;
        node2.tail = node;
        node2.inuse = true;
    }

    private static Node GetFreeNode(Node[][] nodeArray, int n, NodePool nodePool) {
        while (true) {
            if (nodePool.next >= nodePool.size) {
                int n2;
                for (n2 = 0; n2 < nodePool.size; ++n2) {
                    nodePool.nodes[n2].inuse = false;
                }
                if (nodeArray != null) {
                    for (n2 = 0; n2 < n * 2; ++n2) {
                        Node node = nodeArray[n2 / 2][n2 % 2];
                        while (node != null) {
                            node.inuse = true;
                            node = node.tail;
                        }
                    }
                }
                nodePool.next = 0;
            }
            if (!nodePool.nodes[nodePool.next].inuse) break;
            ++nodePool.next;
        }
        return nodePool.nodes[nodePool.next++];
    }

    private static void BoundaryPM(Node[][] nodeArray, int n, Node[] nodeArray2, int n2, NodePool nodePool, int n3, boolean bl) {
        Node node;
        int n4 = nodeArray[n3][1].count;
        if (n3 == 0 && n4 >= n2) {
            return;
        }
        Node node2 = Katajainen.GetFreeNode(nodeArray, n, nodePool);
        nodeArray[n3][0] = node = nodeArray[n3][1];
        nodeArray[n3][1] = node2;
        if (n3 == 0) {
            Katajainen.InitNode(nodeArray2[n4].weight, n4 + 1, null, node2);
        } else {
            int n5 = nodeArray[n3 - 1][0].weight + nodeArray[n3 - 1][1].weight;
            if (n4 < n2 && n5 > nodeArray2[n4].weight) {
                Katajainen.InitNode(nodeArray2[n4].weight, n4 + 1, node.tail, node2);
            } else {
                Katajainen.InitNode(n5, n4, nodeArray[n3 - 1][1], node2);
                if (!bl) {
                    Katajainen.BoundaryPM(nodeArray, n, nodeArray2, n2, nodePool, n3 - 1, false);
                    Katajainen.BoundaryPM(nodeArray, n, nodeArray2, n2, nodePool, n3 - 1, false);
                }
            }
        }
    }

    private static void InitLists(NodePool nodePool, Node[] nodeArray, int n, Node[][] nodeArray2) {
        Node node = Katajainen.GetFreeNode(null, n, nodePool);
        Node node2 = Katajainen.GetFreeNode(null, n, nodePool);
        Katajainen.InitNode(nodeArray[0].weight, 1, null, node);
        Katajainen.InitNode(nodeArray[1].weight, 2, null, node2);
        for (int i = 0; i < n; ++i) {
            nodeArray2[i][0] = node;
            nodeArray2[i][1] = node2;
        }
    }

    private static void ExtractBitLengths(Node node, Node[] nodeArray, int[] nArray) {
        Node node2 = node;
        while (node2 != null) {
            for (int i = 0; i < node2.count; ++i) {
                int n = nodeArray[i].count;
                nArray[n] = nArray[n] + 1;
            }
            node2 = node2.tail;
        }
    }

    public static boolean ZopfliLengthLimitedCodeLengths(int[] nArray, int n, int n2, int[] nArray2) {
        int n3;
        NodePool nodePool = new NodePool();
        int n4 = 0;
        Node[] nodeArray = new Node[n];
        for (n3 = 0; n3 < n; ++n3) {
            nArray2[n3] = 0;
        }
        for (n3 = 0; n3 < n; ++n3) {
            if (nArray[n3] == 0) continue;
            nodeArray[n4] = new Node();
            nodeArray[n4].weight = nArray[n3];
            nodeArray[n4].count = n3;
            ++n4;
        }
        if (1 << n2 < n4) {
            return true;
        }
        if (n4 == 0) {
            return false;
        }
        if (n4 == 1) {
            nArray2[nodeArray[0].count] = 1;
            return false;
        }
        Arrays.sort(nodeArray, 0, n4, leafComparator);
        nodePool.size = 2 * n2 * (n2 + 1);
        nodePool.nodes = new Node[nodePool.size];
        nodePool.next = 0;
        for (n3 = 0; n3 < nodePool.size; ++n3) {
            nodePool.nodes[n3] = new Node();
        }
        Node[][] nodeArray2 = new Node[n2][2];
        Katajainen.InitLists(nodePool, nodeArray, n2, nodeArray2);
        int n5 = 2 * n4 - 4;
        for (n3 = 0; n3 < n5; ++n3) {
            boolean bl = n3 == n5 - 1;
            Katajainen.BoundaryPM(nodeArray2, n2, nodeArray, n4, nodePool, n2 - 1, bl);
        }
        Katajainen.ExtractBitLengths(nodeArray2[n2 - 1][1], nodeArray, nArray2);
        return false;
    }

    private static final class NodePool {
        Node[] nodes;
        int next;
        int size;

        private NodePool() {
        }
    }

    private static final class Node {
        int weight;
        Node tail;
        int count;
        boolean inuse;

        private Node() {
        }

        public String toString() {
            return "Node[w=" + this.weight + ",c=" + this.count + ",u=" + this.inuse + "]";
        }
    }
}

