別のページです。
このページの文章はサンプルです。特に意味はありません。


### Java

CatalpaはJavaで開発されています。

Javaは、狭義ではプログラミング言語のJavaを指し、広義ではJava言語を中心にした
コンピューティング・プラットフォームを意味します。後者はJavaプラットフォームと呼ばれます。
Javaの関連技術は「Javaテクノロジー」と総称されています。
Javaの構文はC++に類似しており、オブジェクト指向と並行コンピューティングが主なパラダイムとして導入されています。
Javaテクノロジーの主な目標は、従来のソフトウェアが抱えていた移植性問題の解決でした。
"Write once, run anywhere"（一度書けばどこでも動く）をキャッチコピーにし、
特定の環境に依存しない理想的なクロスプラットフォーム・プログラムの開発・実行環境の実現を目指して設計されました。

JavaプログラムはJavaバイトコードと呼ばれる中間言語（中間表現）にコンパイルされて、
Java仮想マシンと呼ばれるソフトウェア上で実行されます。
各コンピュータ環境に対応したJava仮想マシンがハードウェア間の差異を吸収し、
特定の環境に依存しないプログラム動作を実現する仕組みとなってます。
Java登場初期の対象であった家電機器の組み込みシステムを始め、
マイクロ制御装置、携帯機器、パーソナルコンピュータ、サーバーマシン、
スマートカードといった様々な環境にJavaソフトウェアは普及しています。

Javaは、1995年にサン・マイクロシステムズによって公開された。
2010年にサンはオラクルに吸収合併され、Javaの各種権利もオラクルに移行しました。
おおよそ数年おきに言語仕様の改訂が重ねられており、
2019年3月現在の最新メジャーバージョンは、2018年9月25日に公開された第11版となっています。


### オブジェクト指向

Javaはクラスベースのオブジェクト指向プログラミング言語です。
オブジェクト指向とは、現実世界をモデル化する手法のひとつであり、
データ（状態）とそれに関連する振る舞い（処理）をまとめてオブジェクト（物体）として扱います。

Javaのプログラムは複数のクラスから構成されます。オブジェクト指向におけるクラスとは、オブジェクトの設計図にあたるものです。
各クラスから実体化したオブジェクトはインスタンスと呼ばれます。クラスは再利用可能なソフトウェア部品の単位としてよく使われます。
Javaのクラスはカプセル化・継承・ポリモーフィズムをサポートしています。

Javaでは、クラスに定義する状態を「フィールド」（インスタンス変数）と呼び、振る舞いを「メソッド」と呼びます。
それぞれ、C++で「メンバー変数」「メンバー関数」と呼ばれているものに相当します。
なおJavaのオブジェクト指向は、Smalltalkに代表されるようなメッセージパッシングによるオブジェクト指向ではなく、
C++に代表されるようなクラス機構を中心としたオブジェクト指向です。
後者は、限られた計算機資源でもオブジェクト指向を実現できるというメリットがあります。

継承とは、既存のクラスを基にして、そのクラスの機能を引き継いだ新しいクラスを定義できることをいいます。
継承は拡張とも呼ばれ、Javaのクラス構文では継承の際に`extends`キーワードが使われています。
Javaのクラスはすべて、暗黙的に基底クラス`java.lang.Object`から派生します。
また、C++のような実装の多重継承はサポートせず、単一継承のみをサポートしています。
ただし、クラスは複数のインタフェースを実装（`implements`）することができます。
Javaのインタフェースは、C++では純粋仮想関数のみを持つクラスに相当し、実装を持たない型でした。
ただし、Java 8以降はインタフェースのデフォルトメソッドにより、実装の多重継承も限定的にサポートするようになっています。

>
  * {.pager} [前のページ](index.html){.previous} {.center}
>
