/*
 * 쐬: 2005/06/15
 */
package jp.sourceforge.cafebabe.cbb;

import bsh.Interpreter;
import jp.sourceforge.cafebabe.framework.Command;
import jp.sourceforge.cafebabe.system.SystemManager;

/**
 * @author jin_k
 */
public class BshAdapter implements Command {
	/** BeanShell Interperter */
	private Thread _bshThread;

	/* ( Javadoc)
	 * @see jp.sourceforge.cafebabe.framework.Command#execute(jp.sourceforge.cafebabe.system.SystemManager, java.lang.String[])
	 */
	public String execute(SystemManager manager, String[] args) {
		BabeBshBridge bridge = new BabeBshBridge(manager, this);
		Interpreter bsh = new Interpreter(bridge);
		bsh.setExitOnEOF(false);
		_bshThread = new Thread(bsh);
		_bshThread.start();
		try {
			_bshThread.join();
		} catch (InterruptedException e) {
			_bshThread.interrupt();
		} finally {
			_bshThread = null;
		}
		return SUCCESS;
	}

	/**
	 * bshI܂B
	 */
	void exit() {
		_bshThread.interrupt();
	}
}
