/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cafebabe.cbb;

import java.io.Reader;
import jp.sourceforge.cafebabe.cbb.BshAdapter;
import jp.sourceforge.cafebabe.framework.CommandManager;
import jp.sourceforge.cafebabe.system.SystemManager;

public class CommandReader
extends Reader {
    private SystemManager _manager;
    private BshAdapter _adapter;
    private boolean _isClosed;
    private char[] _buff;
    private int _pos;

    public CommandReader(SystemManager manager, BshAdapter adapter) {
        this._manager = manager;
        this._adapter = adapter;
        this._buff = new char[0];
        this._pos = 0;
    }

    public void close() {
    }

    public int read(char[] cbuf, int off, int len) {
        try {
            if (this._isClosed) {
                return -1;
            }
            if (this._buff.length <= this._pos) {
                String[] macro;
                CommandManager cm;
                String com;
                String command = this._manager.getInput(null);
                if (command == null || command.trim().startsWith("exit()")) {
                    this._isClosed = true;
                    return -1;
                }
                this._buff = (command = String.valueOf(command) + "\n").startsWith("@") ? ((com = (cm = this._manager.getCommandManager()).getMacro((macro = cm.split(command, ' '))[0])) != null ? cm.parseMacro(com, macro).toCharArray() : command.toCharArray()) : command.toCharArray();
                this._pos = 0;
            }
            if (this._isClosed) {
                this._adapter.exit();
                return -1;
            }
            int read = len - off < this._buff.length - this._pos ? len - off : this._buff.length - this._pos;
            System.arraycopy(this._buff, this._pos, cbuf, off, read);
            this._pos += read;
            return read;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

