/*
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

int main (int argc, char **argv)
{
	int ret, c, index = 0;
	pid_t pid;
	struct option *options;


	/* make option table */
	options = append_common_options(NULL, 0);
	options = append_pid_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else if ( !check_pid(c, options, index, &pid) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

	ret = cabi_account_unbind(pid);
	check_setarg_pid(0 ,"Usage: ctunbind --pid=x");
	cabi_result(ret, 1);

	cabi_information("account unbind pid [%d(0x%x)]\n",
			 pid, pid);
	
	return 0;	
}


