/*
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

#define EQ	0
#define NE	1

#define ERR_MSG "Usege: ctucabicomp --cabiid=x --other_options"

static int compmode = EQ;

static void comp_long(long expect, long val, const char *name)
{
	if ( compmode == EQ ){
		if ( expect != val ){
			cabi_fail("%s:%ld != %ld", name, expect, val);
		}
	} else {
		if ( expect == val ){
			cabi_fail("%s:%ld == %ld", name, expect, val);
		}
	}
	
}

static void comp_ulong(unsigned long expect, unsigned long val, const char *name)
{
	if ( compmode == EQ ){
		if ( expect != val ){
			cabi_fail("%s:%lu != %lu", name, expect, val);
		}
	} else {
		if ( expect == val ){
			cabi_fail("%s:%lu == %lu", name, expect, val);
		}
	}
	
}

static void comp_time(const struct timespec *expect, const struct timespec *val, const char *name)
{
	if ( compmode == EQ ){
		if ( expect->tv_sec != val->tv_sec || expect->tv_nsec != val->tv_nsec ){
			cabi_fail("%s:%ld.%09ld != %ld.%09ld", name,
				  expect->tv_sec, expect->tv_nsec, val->tv_sec, val->tv_nsec);
		}
	} else {
		if ( expect->tv_sec == val->tv_sec && expect->tv_nsec == val->tv_nsec ){
			cabi_fail("%s:%ld.%09ld == %ld.%09ld", name,
				  expect->tv_sec, expect->tv_nsec, val->tv_sec, val->tv_nsec);
		}
	}
	
}



int main (int argc, char **argv)
{
	int ret, c, index = 0;
	unsigned long cabiid = -1;
	pid_t pid;
	struct cabi_uaccount ucabi;
	struct option *options;
	static struct option ctucabicomp_options[] = {
		{"eq", no_argument, 0, 'e'},
		{"ne", no_argument, 0, 'n'},
		{0,0,0,0},
	};
	struct timespec tv;


	/* make option table */
	options = append_common_options(ctucabicomp_options, 0);
	options = append_cabiid_options(options, 1);
	options = append_ucabi_options(options, 1);
	options = append_pid_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
		case -1:	// end of argument
			break;
		case 'e':
			compmode = EQ;
			break;
		case 'n':
			compmode = NE;
			break;
		case OPT_CODE_CABI_ID:
			check_cabiid(c, options, index, &cabiid);
//			cabiid = parse_cabi_id(options[index].name, optarg);
			/* clear cabi_uaccount */
			memset(&ucabi, 0, sizeof(struct cabi_uaccount));

			ret = cabi_account_get(cabiid, &ucabi);
			if ( ret != CABI_SUCCESS )
				cabi_result(ret, 1);
			dump_ucabi(&ucabi);
			break;

		case OPT_CODE_UCABI_CABI_ID:
			check_setarg_cabiid(1, ERR_MSG);
			comp_ulong(parse_cabi_id(options[index].name, optarg), ucabi.cabi_id, "ucabi.cabi_id");
			break;
		case OPT_CODE_UCABI_TERM_NONE:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(CABI_TERM_NONE, ucabi.cabi_param.term_act, "ucabi.cabi_param.term_act");
			break;
		case OPT_CODE_UCABI_TERM_BLOCK:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(CABI_TERM_BLOCK, ucabi.cabi_param.term_act, "ucabi.cabi_param.term_act");
			break;
		case OPT_CODE_UCABI_TERM_SIGNAL:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(CABI_TERM_SIGNAL, ucabi.cabi_param.term_act, "ucabi.cabi_param.term_act");
			break;
		case OPT_CODE_UCABI_TERM_UNKNOWN:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(CABI_TERM_UNKNOWN, ucabi.cabi_param.term_act, "ucabi.cabi_param.term_act");
			break;
		case OPT_CODE_UCABI_TERM_ACT:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(parse_int(options[index].name, optarg), ucabi.cabi_param.term_act, "ucabi.cabi_param.term_act");
			break;
		case OPT_CODE_UCABI_PID:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(parse_pid_t(options[index].name, optarg), ucabi.cabi_param.cabi_signal.pid, "ucabi.cabi_param.cabi_signal.pid");
			break;
		case OPT_CODE_UCABI_SIG:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(parse_signal(options[index].name, optarg), ucabi.cabi_param.cabi_signal.sig, "ucabi.cabi_param.cabi_signal.sig");
			break;
		case OPT_CODE_UCABI_FLAG:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(parse_int(options[index].name, optarg), ucabi.cabi_param.cabi_signal.flag, "ucabi.cabi_param.cabi_signal.flag");
			break;
		case OPT_CODE_UCABI_BIND_NORMAL_PROC:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(BIND_NORMAL_PROC, ucabi.cabi_param.bind_proc_type, "ucabi.cabi_param.bind_proc_type");
			break;
		case OPT_CODE_UCABI_BIND_IDLE_PROC:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(BIND_IDLE_PROC, ucabi.cabi_param.bind_proc_type, "ucabi.cabi_param.bind_proc_type");
			break;
		case OPT_CODE_UCABI_BIND_PROC_TYPE:
			check_setarg_cabiid(1, ERR_MSG);
			comp_long(parse_int(options[index].name, optarg), ucabi.cabi_param.bind_proc_type, "ucabi.cabi_param.bind_proc_type");
			break;
		case OPT_CODE_UCABI_CPU_TIME:
			check_setarg_cabiid(1, ERR_MSG);
			parse_time(options[index].name, &tv, optarg);
			comp_time(&tv, &ucabi.cpu_time, "ucabi.cpu_time");
			break;
		case OPT_CODE_UCABI_CPU_TIME_X:
			check_setarg_cabiid(1, ERR_MSG);
			parse_time_x(options[index].name, &tv, optarg);
			comp_time(&tv, &ucabi.cpu_time, "ucabi.cpu_time");
			break;
		case OPT_CODE_UCABI_CPU_PERIOD:
			check_setarg_cabiid(1, ERR_MSG);
			parse_time(options[index].name, &tv, optarg);
			comp_time(&tv, &ucabi.cpu_period, "ucabi.cpu_period");
			break;
		case OPT_CODE_UCABI_CPU_PERIOD_X:
			check_setarg_cabiid(1, ERR_MSG);
			parse_time_x(options[index].name, &tv, optarg);
			comp_time(&tv, &ucabi.cpu_period, "ucabi.cpu_period");
		break;
		case OPT_CODE_PID:
			check_setarg_cabiid(1, ERR_MSG);
			check_pid(c, options, index, &pid);
		{
#define FGETS_BUF 1024
#define POPEN_CMD_BUF 4096
			FILE *pin;
			char get_cabiid[FGETS_BUF];
			char cmd[POPEN_CMD_BUF];

			memset(get_cabiid, 0, FGETS_BUF);
			memset(cmd, 0, POPEN_CMD_BUF);
			sprintf(cmd, "cabipid %d", pid);

			cabi_information("exec cabi util \"%s\"\n", cmd);
			pin = popen(cmd, "r"); // exec cabiutil
			if (!pin) program_fail("pid command exec fail");

			fgets(get_cabiid, FGETS_BUF, pin); // read 1 line

			if (pclose(pin)) program_fail("pid program fail");
			if (!atoi(get_cabiid)) cabi_information("pid not binded\n");

			comp_long(cabiid, atoi(get_cabiid), "pid cabiid");
		}
		break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}


	check_setarg_cabiid(0, ERR_MSG);
	cabi_result(0, 1);

	return 0;	
}


