/*
 * ctgetusedtime
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <cabi/cabi_error.h>
#include "common.h"

#define CT_OPT_NANOSEC		0x01

#define CT_USEDTIME_MARK_L "<<<CTUSEDTIME"
#define CT_USEDTIME_MARK_R "CTUSEDTIME>>>"

int main (int argc, char **argv)
{
	int ret, c, index = 0;
	unsigned long cabiid = -1;
	struct option *options;
        static struct option ctgetusedtime_options[] = {
                {"nanosec", required_argument, 0, CT_OPT_NANOSEC},
                {0,0,0,0},
        };
	unsigned long long *nanosec=NULL;
	int setnanosec=-1;

	/* make option table */
	options = append_common_options(ctgetusedtime_options, 0);
	options = append_cabiid_options(options, 1);

	c = 0;
	while( c != -1 ){
		c = getopt_long_only (argc, argv, "", options, &index);

		switch( c ){
                case CT_OPT_NANOSEC:
                        setnanosec = parse_int(options[index].name, optarg);
                        break;
		case -1:	// end of argument
			break;
		default:
			if ( !check_common(c, options, index) ){
				// accept argument : NOP
			} else if ( !check_cabiid(c, options, index, &cabiid) ){
				// accept argument : NOP
			} else {
				unknown_option(index, c, optarg);
			}
		}
	}

        /* --nanosec=0 */
        if (setnanosec == -1) {
                nanosec = (unsigned long long*)malloc(sizeof(unsigned long long));
                if (nanosec == NULL) {
                        program_fail("no mem");
                }
                *nanosec = 0;
        } else {
                nanosec = (unsigned long long*)setnanosec;
        }

	cabi_information("get used time. object_id [%lu(0x%lx)] nanosec[%p]\n", cabiid, cabiid, nanosec);
	ret = cabi_get_used_time(cabiid, nanosec);
	if ( setnanosec == -1 ){
                if (cabi_export()) {
                        cabi_information("%s%llu%s\n",
                                         CT_USEDTIME_MARK_L,
                                         (*nanosec) / 1000,
                                         CT_USEDTIME_MARK_R);
                } else {
                        cabi_information("used time=%llu\n", *nanosec);
                }
	}
	check_setarg_cabiid(0, "Usage: ctgetusedtime --cabiid=x");
	cabi_result(ret, 1);
	if (setnanosec == -1) {
		free(nanosec);
	}

	return 0;
}


